/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringNfa
implements Nfa<String> {
    protected final Multimap<String, String> followers = ArrayListMultimap.create();
    protected final String start;
    protected final String stop;

    public StringNfa(String start, String stop) {
        this.start = start;
        this.stop = stop;
    }

    @Override
    public Iterable<String> getFollowers(String state) {
        return this.followers.get(state);
    }

    @Override
    public String getStart() {
        return this.start;
    }

    @Override
    public String getStop() {
        return this.stop;
    }

    public StringNfaState start() {
        return new StringNfaState(this.start);
    }

    public StringNfaState state(String state) {
        return new StringNfaState(state);
    }

    public StringNfaState stop() {
        return new StringNfaState(this.stop);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringNfaFactory
    implements NfaFactory<StringNfa, String, Object> {
        protected String nullStart;
        protected String nullState;
        protected String nullStop;

        public StringNfaFactory() {
            this("(start:null)", "(stop:null)");
        }

        public StringNfaFactory(String nullStart, String nullStop) {
            this(nullStart, nullStop, "(null)");
        }

        public StringNfaFactory(String nullStart, String nullStop, String nullState) {
            this.nullStart = nullStart;
            this.nullStop = nullStop;
            this.nullState = nullState;
        }

        @Override
        public StringNfa create(Object start, Object stop) {
            String starts = start != null ? start.toString() : this.nullStart;
            String stops = stop != null ? stop.toString() : this.nullStop;
            return new StringNfa(starts, stops);
        }

        @Override
        public String createState(StringNfa nfa, Object token) {
            return token != null ? token.toString() : this.nullState;
        }

        @Override
        public void setFollowers(StringNfa nfa, String owner, Iterable<String> followers) {
            nfa.state(owner).followedBy(Iterables.toArray(followers, String.class));
        }
    }

    protected class StringNfaState {
        protected String name;

        protected StringNfaState(String name) {
            this.name = name;
        }

        public StringNfaState followedBy(String ... states) {
            StringNfa.this.followers.putAll(this.name, Arrays.asList(states));
            return this;
        }
    }
}

