/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfaGraphFormatter {
    public <STATE> String format(Nfa<STATE> nfa) {
        LinkedHashMap names = Maps.newLinkedHashMap();
        ArrayList<Node> nodes = Lists.newArrayList();
        nodes.add(this.createNodes(nfa, nfa.getStart(), names, new Wrapper<Integer>(0)));
        StringBuilder result = new StringBuilder();
        STATE starts = nfa.getStart();
        STATE stops = nfa.getStop();
        for (Map.Entry e : names.entrySet()) {
            result.append(e.getValue() + ": " + e.getKey());
            if (starts == e.getKey()) {
                result.append(" (start)");
            }
            if (stops == e.getKey()) {
                result.append(" (stop)");
            }
            if (!new NfaUtil().canReachFinalState(nfa, e.getKey())) {
                result.append(" (no connection to final state!)");
            }
            result.append("\n");
        }
        Canvas canvas = new Canvas();
        int width = 0;
        for (Node n : nodes) {
            n.draw(canvas, 0, width, n.getMinWidth());
            width += n.getMinWidth();
        }
        result.append(canvas);
        return result.toString();
    }

    protected <STATE> Node createNodes(Nfa<STATE> nfa, STATE state, Map<STATE, Integer> names, Wrapper<Integer> lastName) {
        Integer name = names.get(state);
        if (name != null) {
            return new Node(String.valueOf(name), true);
        }
        lastName.set(lastName.get() + 1);
        names.put(state, lastName.get());
        Node node = new Node(String.valueOf(lastName.get()), false);
        for (STATE follower : nfa.getFollowers(state)) {
            node.children.add(this.createNodes(nfa, follower, names, lastName));
        }
        return node;
    }

    protected static class Canvas {
        protected List<StringBuffer> document = Lists.newArrayList();

        protected Canvas() {
        }

        public void set(int line, int column, String string) {
            if (line < 0 || column < 0) {
                throw new IndexOutOfBoundsException();
            }
            int i = this.document.size() - 1;
            while (i < line) {
                this.document.add(new StringBuffer());
                ++i;
            }
            StringBuffer l = this.document.get(line);
            int width = column + string.length();
            int i2 = l.length() - 1;
            while (i2 < width) {
                l.append(' ');
                ++i2;
            }
            l.replace(column, column + string.length(), string);
        }

        public String toString() {
            return Joiner.on('\n').join(this.document);
        }
    }

    protected static class Node {
        protected String name;
        protected boolean alias;
        protected List<Node> children = Lists.newArrayList();

        public Node(String name, boolean alias) {
            this.name = name;
            this.alias = alias;
        }

        public int getMinChildrenWidth() {
            int result = 0;
            for (Node child : this.children) {
                result += child.getMinWidth();
            }
            return result += this.children.size() - 1;
        }

        public int getMinWidth() {
            return Math.max(this.name.length(), this.getMinChildrenWidth());
        }

        public String getNameLine() {
            int space = this.getMinWidth() - this.name.length();
            if (space <= 0) {
                return this.name;
            }
            int left = space / 2;
            int right = space - left;
            return String.valueOf(this.ws(left)) + this.name + this.ws(right);
        }

        protected int getNamePos(int column, int width) {
            return column + (width - this.name.length()) / 2;
        }

        protected void drawEdge(Canvas canvas, int fromLine, int fromCol, int fromWidth, int toCol, int toWidth) {
            int toPos = toCol + (toWidth - 1) / 2;
            if (fromCol <= toCol && fromCol + fromWidth >= toCol || fromCol <= toCol + toWidth && fromCol + fromWidth >= toCol + toWidth) {
                int left = Math.max(fromCol, toCol);
                int right = Math.min(fromCol + fromWidth, toCol + toWidth);
                canvas.set(fromLine + 1, left - (left - right) / 2, "|");
            } else if (fromCol + 1 > toPos) {
                int i = toPos + 2;
                while (i < fromCol - 1) {
                    canvas.set(fromLine, i, "_");
                    ++i;
                }
                canvas.set(fromLine + 1, toPos + 1, "/");
            } else if (fromCol + fromWidth - 1 < toPos) {
                int i = toPos - 2;
                while (i > fromCol + fromWidth) {
                    canvas.set(fromLine, i, "_");
                    --i;
                }
                canvas.set(fromLine + 1, toPos - 1, "\\");
            }
        }

        public void draw(Canvas canvas, int line, int column, int width) {
            canvas.set(line, this.getNamePos(column, width), this.name);
            if (this.alias) {
                canvas.set(line + 1, column + (width - 1) / 2, "*");
            } else if (!this.children.isEmpty()) {
                int[] childWidth = new int[this.children.size()];
                int childrenWidth = 0;
                int i = 0;
                while (i < this.children.size()) {
                    childWidth[i] = this.children.get(i).getMinWidth();
                    childrenWidth += childWidth[i];
                    ++i;
                }
                while (childrenWidth < width) {
                    i = this.children.size() - 1;
                    while (i >= 0) {
                        int n = i--;
                        childWidth[n] = childWidth[n] + 1;
                        ++childrenWidth;
                    }
                }
                int childCol = column;
                int i2 = 0;
                while (i2 < this.children.size()) {
                    Node child = this.children.get(i2);
                    this.drawEdge(canvas, line, this.getNamePos(column, width), this.name.length(), this.getNamePos(childCol, childWidth[i2]), child.name.length());
                    child.draw(canvas, line + 2, childCol, childWidth[i2]);
                    childCol += childWidth[i2];
                    ++i2;
                }
            }
        }

        public String getBranchLine() {
            int width = this.getMinWidth();
            int space = width - (this.name.length() + 2);
            int left = space / 2;
            int right = space - left;
            StringBuilder r = new StringBuilder();
            for (Node child : this.children) {
                int w = child.getMinWidth();
                int t = child.getTopAnchor();
                r.append(this.ws(t));
                if (r.length() < left) {
                    r.append("/");
                } else if (r.length() > width - right) {
                    r.append("\\");
                } else {
                    r.append("|");
                }
                r.append(this.ws(w - t));
            }
            return r.toString();
        }

        public int getTopAnchor() {
            return this.getMinWidth() / 2;
        }

        protected String ws(int count) {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < count) {
                b.append(" ");
                ++i;
            }
            return b.toString();
        }
    }
}

