/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitorWithParameter;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.LazyTypeArgumentContext;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Singleton
public class TypeArgumentContextProvider {
    @Inject
    private Provider<LazyTypeArgumentContext> lazyTypeArgumentContextProvider;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypesFactory typesFactory;
    @Inject
    private IRawTypeHelper rawTypeHelper;
    @Inject
    private TypeConformanceComputer conformanceComputer;
    @Inject
    private Primitives primitives;

    public ITypeArgumentContext getTypeArgumentContext(Request request) {
        IInitializableTypeArgumentContext result = this.lazyTypeArgumentContextProvider.get();
        result.initialize(request, this);
        return result;
    }

    protected TypeArgumentContext getReceiverContext(JvmTypeReference receiverType) {
        final Map<JvmTypeParameter, JvmTypeReference> result = this.createTemporaryMap();
        final HashSet visited = Sets.newHashSet();
        boolean rawType = (Boolean)new AbstractTypeReferenceVisitor.InheritanceAware<Boolean>(){

            @Override
            protected Boolean handleNullReference() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean doVisitTypeReference(JvmTypeReference reference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitCompoundTypeReference(JvmCompoundTypeReference reference) {
                for (JvmTypeReference component : reference.getReferences()) {
                    if (!((Boolean)this.visit(component)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                JvmType type = reference.getType();
                if (visited.add(type)) {
                    if (type instanceof JvmTypeParameterDeclarator) {
                        EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters();
                        EList<JvmTypeReference> typeArguments = reference.getArguments();
                        if (!typeArguments.isEmpty()) {
                            int i = 0;
                            while (i < typeArguments.size() && i < typeParameters.size()) {
                                JvmTypeReference argument = (JvmTypeReference)typeArguments.get(i);
                                if (argument != null) {
                                    JvmTypeParameter param = (JvmTypeParameter)typeParameters.get(i);
                                    boolean self = false;
                                    if (argument instanceof JvmParameterizedTypeReference) {
                                        boolean bl = self = param == argument.getType();
                                    }
                                    if (!self && result.put(param, argument) != null) {
                                        throw new IllegalStateException();
                                    }
                                }
                                ++i;
                            }
                        } else if (!typeParameters.isEmpty()) {
                            return Boolean.TRUE;
                        }
                    }
                    if (type instanceof JvmTypeParameter) {
                        EList<JvmTypeConstraint> constraints = ((JvmTypeParameter)type).getConstraints();
                        boolean upperBoundSeen = false;
                        for (JvmTypeConstraint constraint : constraints) {
                            if (!(constraint instanceof JvmUpperBound)) continue;
                            upperBoundSeen = true;
                            if (!((Boolean)this.visit(constraint.getTypeReference())).booleanValue()) continue;
                            return Boolean.TRUE;
                        }
                        if (!upperBoundSeen && ((Boolean)this.visit(TypeArgumentContextProvider.this.typeReferences.getTypeForName(Object.class, (Notifier)type, new JvmTypeReference[0]))).booleanValue()) {
                            return Boolean.TRUE;
                        }
                    } else if (type instanceof JvmDeclaredType) {
                        EList<JvmTypeReference> superTypes = ((JvmDeclaredType)type).getSuperTypes();
                        for (JvmTypeReference superType : superTypes) {
                            if (!((Boolean)this.visit(superType)).booleanValue()) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        }.visit(this.primitives.asWrapperTypeIfPrimitive(receiverType));
        if (rawType) {
            return new TypeArgumentContext(null, this.typeReferences, this.typesFactory, this.rawTypeHelper, this.primitives);
        }
        Map<JvmTypeParameter, JvmTypeReference> normalized = this.normalizedCopy(result);
        if (normalized.isEmpty()) {
            return null;
        }
        return new TypeArgumentContext(normalized, this.typeReferences, this.typesFactory, this.rawTypeHelper, this.primitives);
    }

    protected Map<JvmTypeParameter, JvmTypeReference> normalizedCopy(Multimap<JvmTypeParameter, ResolveInfo> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<JvmTypeParameter, ResolveInfo> singleElement = Iterables.getOnlyElement(map.entries());
            ResolveInfo singleResolveInfo = singleElement.getValue();
            JvmTypeReference reference = this.wildcardAwareGetReference(singleResolveInfo);
            return Collections.singletonMap(singleElement.getKey(), reference);
        }
        Map<JvmTypeParameter, JvmTypeReference> result = this.createMapWithTweakedToString();
        for (JvmTypeParameter boundParameter : map.keySet()) {
            Collection<ResolveInfo> boundTo = map.get(boundParameter);
            if (boundTo.size() == 1) {
                ResolveInfo singleResolveInfo = Iterables.getOnlyElement(boundTo);
                JvmTypeReference reference = this.wildcardAwareGetReference(singleResolveInfo);
                result.put(boundParameter, reference);
                continue;
            }
            ArrayList<ResolveInfo> boundToList = Lists.newArrayList(boundTo);
            ArrayList<JvmTypeReference> uppers = Lists.newArrayListWithCapacity(boundToList.size());
            ArrayList<ResolveInfo> lowers = Lists.newArrayListWithCapacity(boundToList.size());
            boolean done = false;
            int lowerIndex = Integer.MAX_VALUE;
            int upperIndex = Integer.MAX_VALUE;
            int i = 0;
            while (i < boundToList.size()) {
                ResolveInfo info = (ResolveInfo)boundToList.get(i);
                if (info.kind == ResolveInfoKind.EXACT) {
                    result.put(boundParameter, info.reference);
                    done = true;
                    break;
                }
                if (info.kind == ResolveInfoKind.UPPER || info.kind == ResolveInfoKind.WC_UPPER) {
                    if (upperIndex == Integer.MAX_VALUE) {
                        upperIndex = i;
                    }
                    if (!lowers.isEmpty() && upperIndex < lowerIndex) {
                        boolean conformant = true;
                        for (ResolveInfo resolveInfo : lowers) {
                            if (this.getConformanceComputer().isConformant(info.reference, resolveInfo.reference)) continue;
                            conformant = false;
                            break;
                        }
                        if (conformant) {
                            uppers.add(info.reference);
                        }
                    } else {
                        uppers.add(info.reference);
                    }
                } else if (info.kind == ResolveInfoKind.LOWER || info.kind == ResolveInfoKind.WC_LOWER) {
                    if (lowerIndex == Integer.MAX_VALUE) {
                        lowerIndex = i;
                    }
                    lowers.add(info);
                }
                ++i;
            }
            if (done) continue;
            JvmTypeReference reference = null;
            if (!uppers.isEmpty() && upperIndex < lowerIndex) {
                reference = this.conformanceComputer.getCommonSuperType(uppers);
                if (uppers.size() == 1 && ((ResolveInfo)boundToList.get((int)upperIndex)).kind == ResolveInfoKind.WC_UPPER) {
                    boolean useWildcard = true;
                    for (ResolveInfo lowerResolve : lowers) {
                        if (this.conformanceComputer.isConformant(lowerResolve.reference, reference)) continue;
                        useWildcard = false;
                        break;
                    }
                    if (useWildcard) {
                        if (reference.eContainer() != null) {
                            JvmDelegateTypeReference delegate = this.typesFactory.createJvmDelegateTypeReference();
                            delegate.setDelegate(reference);
                            reference = delegate;
                        }
                        JvmWildcardTypeReference wildCard = this.typeReferences.wildCard();
                        JvmUpperBound jvmUpperBound = this.typesFactory.createJvmUpperBound();
                        wildCard.getConstraints().add(jvmUpperBound);
                        jvmUpperBound.setTypeReference(reference);
                        reference = wildCard;
                    }
                }
            } else if (!lowers.isEmpty()) {
                boolean lowerWithWildcard = false;
                ResolveInfo bestResolvedLower = null;
                for (ResolveInfo resolveInfo : lowers) {
                    lowerWithWildcard |= resolveInfo.kind == ResolveInfoKind.WC_LOWER;
                    if (bestResolvedLower == null) {
                        bestResolvedLower = resolveInfo;
                        continue;
                    }
                    TypeConformanceResult conformanceResult = this.conformanceComputer.isConformant(bestResolvedLower.reference, resolveInfo.reference, new TypeConformanceComputationArgument(false, false, true));
                    if (!conformanceResult.isConformant() || !conformanceResult.getKinds().contains((Object)TypeConformanceResult.Kind.SUBTYPE)) continue;
                    bestResolvedLower = resolveInfo;
                }
                if (bestResolvedLower != null) {
                    if (lowers.size() == 1 || lowerWithWildcard) {
                        JvmTypeReference jvmTypeReference;
                        reference = bestResolvedLower.kind != ResolveInfoKind.WC_LOWER ? (!uppers.isEmpty() ? (this.conformanceComputer.isConformant(bestResolvedLower.reference, jvmTypeReference = this.conformanceComputer.getCommonSuperType(uppers)) ? jvmTypeReference : this.wildcardAwareGetReference(bestResolvedLower)) : this.wildcardAwareGetReference(bestResolvedLower)) : this.wildcardAwareGetReference(bestResolvedLower);
                    } else {
                        JvmTypeReference jvmTypeReference;
                        reference = bestResolvedLower.reference;
                        if (!uppers.isEmpty() && this.conformanceComputer.isConformant(reference, jvmTypeReference = this.conformanceComputer.getCommonSuperType(uppers))) {
                            reference = jvmTypeReference;
                        }
                    }
                }
            }
            if (reference == null) continue;
            result.put(boundParameter, reference);
        }
        Map<JvmTypeParameter, JvmTypeReference> normalizedCopy = this.normalizedCopy(result);
        return normalizedCopy;
    }

    protected Map<JvmTypeParameter, JvmTypeReference> createMapWithTweakedToString() {
        return new PrimitiveAwareMap();
    }

    protected JvmTypeReference wildcardAwareGetReference(ResolveInfo resolveInfo) {
        JvmTypeReference reference = resolveInfo.reference;
        ResolveInfoKind kind = resolveInfo.kind;
        if (kind == ResolveInfoKind.WC_UPPER) {
            if (reference.eContainer() instanceof JvmUpperBound && reference.eContainer().eContainer() instanceof JvmWildcardTypeReference) {
                reference = (JvmTypeReference)reference.eContainer().eContainer();
            } else {
                if (reference.eContainer() != null) {
                    JvmDelegateTypeReference delegate = this.typesFactory.createJvmDelegateTypeReference();
                    delegate.setDelegate(reference);
                    reference = delegate;
                }
                JvmWildcardTypeReference wildCard = this.typeReferences.wildCard();
                JvmUpperBound upperBound = this.typesFactory.createJvmUpperBound();
                wildCard.getConstraints().add(upperBound);
                upperBound.setTypeReference(reference);
                reference = wildCard;
            }
        } else if (kind == ResolveInfoKind.WC_LOWER) {
            if (reference.eContainer() instanceof JvmLowerBound && reference.eContainer().eContainer() instanceof JvmWildcardTypeReference) {
                reference = (JvmTypeReference)reference.eContainer().eContainer();
            } else {
                if (reference.eContainer() != null) {
                    JvmDelegateTypeReference delegate = this.typesFactory.createJvmDelegateTypeReference();
                    delegate.setDelegate(reference);
                    reference = delegate;
                }
                JvmWildcardTypeReference wildCard = this.typeReferences.wildCard();
                JvmLowerBound lowerBound = this.typesFactory.createJvmLowerBound();
                wildCard.getConstraints().add(lowerBound);
                lowerBound.setTypeReference(reference);
                reference = wildCard;
            }
        }
        return reference;
    }

    protected Map<JvmTypeParameter, JvmTypeReference> normalizedCopy(final Map<JvmTypeParameter, JvmTypeReference> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<JvmTypeParameter, JvmTypeReference> singleElement = Iterables.getOnlyElement(map.entrySet());
            return Collections.singletonMap(singleElement.getKey(), singleElement.getValue());
        }
        Map<JvmTypeParameter, JvmTypeReference> result = this.createMapWithTweakedToString();
        for (Map.Entry<JvmTypeParameter, JvmTypeReference> entry : map.entrySet()) {
            final JvmTypeParameter parameter = entry.getKey();
            JvmTypeReference boundReference = entry.getValue();
            final HashSet seen = Sets.newHashSet();
            JvmTypeReference normalized = (JvmTypeReference)new AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference>(){

                @Override
                public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                    JvmTypeReference transitive;
                    JvmType type = reference.getType();
                    if (type instanceof JvmTypeParameter && type != parameter && (transitive = (JvmTypeReference)map.get(type)) != null && seen.add(transitive)) {
                        try {
                            JvmTypeReference jvmTypeReference = (JvmTypeReference)this.visit(transitive);
                            return jvmTypeReference;
                        }
                        finally {
                            seen.remove(transitive);
                        }
                    }
                    return reference;
                }

                @Override
                public JvmTypeReference doVisitTypeReference(JvmTypeReference reference) {
                    return reference;
                }
            }.visit(boundReference);
            if (normalized == null) continue;
            result.put(parameter, normalized);
        }
        return result;
    }

    protected ITypeArgumentContext getExplicitArgumentContext(JvmExecutable executable, List<JvmTypeReference> explicitTypeArguments) {
        JvmDeclaredType declaringType;
        Map<JvmTypeParameter, JvmTypeReference> result = this.createTemporaryMap();
        EList<JvmTypeParameter> typeParameters = executable.getTypeParameters();
        if (typeParameters.isEmpty() && executable instanceof JvmConstructor && (declaringType = executable.getDeclaringType()) instanceof JvmTypeParameterDeclarator) {
            typeParameters = ((JvmTypeParameterDeclarator)((Object)declaringType)).getTypeParameters();
        }
        int i = 0;
        while (i < typeParameters.size() && i < explicitTypeArguments.size()) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)typeParameters.get(i);
            JvmTypeReference typeArgument = explicitTypeArguments.get(i);
            if (typeParameter != null && typeArgument != null) {
                result.put((JvmTypeParameter)typeParameters.get(i), explicitTypeArguments.get(i));
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return new TypeArgumentContext(result, this.typeReferences, this.typesFactory, this.rawTypeHelper, this.primitives);
    }

    protected ITypeArgumentContext getExpectedTypeContext(JvmTypeReference declaredType, JvmTypeReference expectedType) {
        Multimap<JvmTypeParameter, ResolveInfo> result = this.createTemporaryMultimap();
        this.resolveAgainstActualType(declaredType, expectedType, result, false, -1);
        Map<JvmTypeParameter, JvmTypeReference> normalized = this.normalizedCopy(result);
        if (normalized.isEmpty()) {
            return null;
        }
        return new TypeArgumentContext(normalized, this.typeReferences, this.typesFactory, this.rawTypeHelper, this.primitives);
    }

    protected Multimap<JvmTypeParameter, ResolveInfo> createTemporaryMultimap() {
        return new ForwardingMultimap<JvmTypeParameter, ResolveInfo>(){
            final Multimap<JvmTypeParameter, ResolveInfo> delegate = LinkedHashMultimap.create(2, 1);

            @Override
            protected Multimap<JvmTypeParameter, ResolveInfo> delegate() {
                return this.delegate;
            }

            @Override
            public boolean put(JvmTypeParameter key, ResolveInfo value) {
                if (value != null) {
                    if (TypeArgumentContextProvider.this.isRecursive(key, value.reference)) {
                        return false;
                    }
                    if (value.reference instanceof JvmParameterizedTypeReference) {
                        value = new ResolveInfo(TypeArgumentContextProvider.this.primitives.asWrapperTypeIfPrimitive(value.reference), value.kind, value.hint);
                    }
                }
                return super.put(key, value);
            }
        };
    }

    protected boolean isRecursive(final JvmTypeParameter param, JvmTypeReference reference) {
        boolean result = (Boolean)new AbstractTypeReferenceVisitor.InheritanceAware<Boolean>(){

            @Override
            protected Boolean handleNullReference() {
                return true;
            }

            @Override
            public Boolean doVisitTypeReference(JvmTypeReference reference) {
                return false;
            }

            @Override
            public Boolean doVisitWildcardTypeReference(JvmWildcardTypeReference reference) {
                for (JvmTypeConstraint constraint : reference.getConstraints()) {
                    if (!((Boolean)this.visit(constraint.getTypeReference())).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                if (param == reference.getType()) {
                    return true;
                }
                return false;
            }
        }.visit(reference);
        return result;
    }

    protected Map<JvmTypeParameter, JvmTypeReference> createTemporaryMap() {
        return new PrimitiveAwareMap(){

            public JvmTypeReference put(JvmTypeParameter key, JvmTypeReference value) {
                if (TypeArgumentContextProvider.this.isRecursive(key, value)) {
                    return null;
                }
                return super.put(key, TypeArgumentContextProvider.this.getWithObjectUpperBoundIfNecessary(value));
            }
        };
    }

    protected JvmTypeReference getWithObjectUpperBoundIfNecessary(JvmTypeReference reference) {
        return reference;
    }

    protected ITypeArgumentContext getDeclaredBoundsContext(JvmExecutable executable) {
        JvmTypeParameterDeclarator declarator = executable;
        Map<JvmTypeParameter, JvmTypeReference> result = this.createTemporaryMap();
        while (declarator != null) {
            EList<JvmTypeParameter> typeParameters = declarator.getTypeParameters();
            for (JvmTypeParameter typeParameter : typeParameters) {
                ArrayList<JvmTypeReference> allUppers = Lists.newArrayList();
                for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    allUppers.add(constraint.getTypeReference());
                }
                if (allUppers.isEmpty()) {
                    result.put(typeParameter, this.typeReferences.getTypeForName(Object.class, (Notifier)declarator, new JvmTypeReference[0]));
                    continue;
                }
                if (allUppers.size() == 1) {
                    result.put(typeParameter, (JvmTypeReference)allUppers.get(0));
                    continue;
                }
                JvmMultiTypeReference bound = this.typesFactory.createJvmMultiTypeReference();
                for (JvmTypeReference upper : allUppers) {
                    if (upper.eContainer() == null) {
                        bound.getReferences().add(upper);
                        continue;
                    }
                    JvmDelegateTypeReference delegate = this.typesFactory.createJvmDelegateTypeReference();
                    delegate.setDelegate(upper);
                    bound.getReferences().add(delegate);
                }
                result.put(typeParameter, bound);
            }
            if (declarator.eContainer() == null) break;
            declarator = EcoreUtil2.getContainerOfType(declarator.eContainer(), JvmTypeParameterDeclarator.class);
        }
        if (result.isEmpty()) {
            return null;
        }
        return new TypeArgumentContext(result, this.typeReferences, this.typesFactory, this.rawTypeHelper, this.primitives);
    }

    protected ITypeArgumentContext getParameterContext(JvmExecutable executable, List<JvmTypeReference> argumentTypes) {
        Map<JvmTypeParameter, JvmTypeReference> normalized;
        JvmTypeReference parameterType;
        Multimap<JvmTypeParameter, ResolveInfo> result = this.createTemporaryMultimap();
        EList<JvmFormalParameter> parameters = executable.getParameters();
        int paramCount = parameters.size();
        if (executable.isVarArgs()) {
            --paramCount;
        }
        int i = 0;
        while (i < paramCount && i < argumentTypes.size()) {
            parameterType = ((JvmFormalParameter)parameters.get(i)).getParameterType();
            JvmTypeReference argumentType = argumentTypes.get(i);
            if (argumentType != null && parameterType != null && !this.typeReferences.is(argumentType, Void.TYPE)) {
                this.resolveAgainstActualType(parameterType, argumentType, result, true, i);
            }
            ++i;
        }
        i = argumentTypes.size();
        while (i < paramCount) {
            parameterType = ((JvmFormalParameter)parameters.get(i)).getParameterType();
            if (parameterType != null) {
                this.resolveAgainstActualType(parameterType, null, result, true, i);
            }
            ++i;
        }
        if (executable.isVarArgs() && argumentTypes.size() > paramCount) {
            JvmTypeReference varArgParameterType = ((JvmFormalParameter)parameters.get(paramCount)).getParameterType();
            if (!(varArgParameterType instanceof JvmGenericArrayTypeReference)) {
                throw new IllegalStateException("VarArg methods expect last paramter to be an array type");
            }
            JvmTypeReference varArgComponentType = ((JvmGenericArrayTypeReference)varArgParameterType).getComponentType();
            if (argumentTypes.size() == paramCount + 1) {
                JvmTypeReference lastArgumentType = argumentTypes.get(paramCount);
                if (lastArgumentType != null) {
                    if (lastArgumentType instanceof JvmGenericArrayTypeReference && ((JvmGenericArrayTypeReference)lastArgumentType).getDimensions() == ((JvmGenericArrayTypeReference)varArgParameterType).getDimensions()) {
                        this.resolveAgainstActualType(varArgParameterType, lastArgumentType, result, true, paramCount);
                        Map<JvmTypeParameter, JvmTypeReference> normalized2 = this.normalizedCopy(result);
                        return new TypeArgumentContext(normalized2, this.typeReferences, this.typesFactory, this.rawTypeHelper, this.primitives);
                    }
                    this.resolveAgainstActualType(varArgComponentType, lastArgumentType, result, true, paramCount);
                }
            } else {
                ArrayList<JvmTypeReference> actualVarArgTypes = Lists.newArrayList(Iterables.filter(argumentTypes.subList(paramCount, argumentTypes.size()), Predicates.notNull()));
                if (!actualVarArgTypes.isEmpty()) {
                    if (!this.primitives.isPrimitive(varArgComponentType)) {
                        ArrayList<JvmTypeReference> wrappedVarArgTypes = Lists.newArrayListWithCapacity(actualVarArgTypes.size());
                        for (JvmTypeReference varArgType : actualVarArgTypes) {
                            wrappedVarArgTypes.add(this.primitives.asWrapperTypeIfPrimitive(varArgType));
                        }
                        actualVarArgTypes = wrappedVarArgTypes;
                    }
                    JvmTypeReference commonVarArgType = this.getConformanceComputer().getCommonSuperType(actualVarArgTypes);
                    this.resolveAgainstActualType(varArgComponentType, commonVarArgType, result, true, paramCount);
                }
            }
        }
        if ((normalized = this.normalizedCopy(result)).isEmpty()) {
            return null;
        }
        return new TypeArgumentContext(normalized, this.typeReferences, this.typesFactory, this.rawTypeHelper, this.primitives);
    }

    protected TypeConformanceComputer getConformanceComputer() {
        return this.conformanceComputer;
    }

    protected void resolveAgainstActualType(JvmTypeReference declaredType, JvmTypeReference actualType, final Multimap<JvmTypeParameter, ResolveInfo> result, final boolean allowWildcardResolutions, int hint) {
        AbstractTypeReferenceVisitorWithParameter.InheritanceAware<ResolveInfo, Void> implementation = new AbstractTypeReferenceVisitorWithParameter.InheritanceAware<ResolveInfo, Void>(){

            @Override
            public Void doVisitCompoundTypeReference(JvmCompoundTypeReference reference, ResolveInfo param) {
                for (JvmTypeReference component : reference.getReferences()) {
                    this.visit(component, param);
                }
                return null;
            }

            @Override
            protected Void handleNullReference(ResolveInfo parameter) {
                return null;
            }

            @Override
            public Void doVisitTypeReference(JvmTypeReference reference, ResolveInfo param) {
                return null;
            }

            @Override
            public Void doVisitParameterizedTypeReference(final JvmParameterizedTypeReference declaredReference, final ResolveInfo param) {
                return (Void)new AbstractTypeReferenceVisitor.InheritanceAware<Void>(){

                    @Override
                    public Void doVisitCompoundTypeReference(JvmCompoundTypeReference reference) {
                        for (JvmTypeReference component : reference.getReferences()) {
                            this.visit(component);
                        }
                        return null;
                    }

                    @Override
                    protected Void handleNullReference() {
                        JvmType type = declaredReference.getType();
                        if (type instanceof JvmTypeParameter) {
                            for (JvmTypeConstraint constraint : ((JvmTypeParameter)type).getConstraints()) {
                                if (!(constraint instanceof JvmUpperBound) || constraint.getTypeReference() == null) continue;
                                result.put((JvmTypeParameter)type, new ResolveInfo(constraint.getTypeReference(), param.kind, param.hint));
                            }
                        }
                        return null;
                    }

                    @Override
                    public Void doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                        TypeArgumentContext actualContext;
                        JvmType type = declaredReference.getType();
                        if (type instanceof JvmTypeParameter) {
                            result.put((JvmTypeParameter)type, param);
                        } else if (type instanceof JvmTypeParameterDeclarator && !((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters().isEmpty() && (actualContext = TypeArgumentContextProvider.this.getReceiverContext(reference)) != null) {
                            TypeArgumentContext declaredContext = TypeArgumentContextProvider.this.getReceiverContext(declaredReference);
                            if (declaredContext == null) {
                                declaredContext = new TypeArgumentContext(Collections.<JvmTypeParameter, JvmTypeReference>emptyMap(), TypeArgumentContextProvider.this.typeReferences, TypeArgumentContextProvider.this.typesFactory, TypeArgumentContextProvider.this.rawTypeHelper, TypeArgumentContextProvider.this.primitives);
                            }
                            Collection<JvmTypeParameter> receiverBoundParameters = actualContext.getBoundParameters();
                            for (JvmTypeParameter receiverBound : receiverBoundParameters) {
                                JvmTypeReference declared = declaredContext.getBoundArgument(receiverBound);
                                JvmTypeReference actual = actualContext.getBoundArgument(receiverBound);
                                this.outerVisit(declared, new ResolveInfo(actual, ResolveInfoKind.EXACT, param.hint));
                            }
                            for (JvmTypeParameter declaredBoundParameter : declaredContext.getBoundParameters()) {
                                if (result.containsKey(declaredBoundParameter)) continue;
                                result.put(declaredBoundParameter, new ResolveInfo(declaredContext.internalGetBoundArgument(declaredBoundParameter), param.kind, param.hint));
                            }
                        }
                        return null;
                    }

                    @Override
                    public Void doVisitWildcardTypeReference(JvmWildcardTypeReference reference) {
                        boolean lowerBoundFound = false;
                        for (JvmTypeConstraint constraint : reference.getConstraints()) {
                            if (!(constraint instanceof JvmLowerBound)) continue;
                            lowerBoundFound = true;
                            this.outerVisit(declaredReference, new ResolveInfo(constraint.getTypeReference(), allowWildcardResolutions ? ResolveInfoKind.WC_LOWER : ResolveInfoKind.LOWER, param.hint));
                        }
                        if (!lowerBoundFound) {
                            for (JvmTypeConstraint constraint : reference.getConstraints()) {
                                if (!(constraint instanceof JvmUpperBound)) continue;
                                this.outerVisit(declaredReference, new ResolveInfo(constraint.getTypeReference(), allowWildcardResolutions ? ResolveInfoKind.WC_UPPER : ResolveInfoKind.UPPER, param.hint));
                            }
                        }
                        return null;
                    }

                    @Override
                    public Void doVisitTypeReference(JvmTypeReference reference) {
                        return null;
                    }
                }.visit(param.reference);
            }

            @Override
            public Void doVisitWildcardTypeReference(final JvmWildcardTypeReference declaredReference, final ResolveInfo param) {
                return (Void)new AbstractTypeReferenceVisitor.InheritanceAware<Void>(){

                    @Override
                    protected Void handleNullReference() {
                        return null;
                    }

                    @Override
                    public Void doVisitCompoundTypeReference(JvmCompoundTypeReference reference) {
                        return this.doVisitTypeReference(reference);
                    }

                    @Override
                    public Void doVisitWildcardTypeReference(JvmWildcardTypeReference reference) {
                        for (JvmTypeConstraint declaredConstraint : declaredReference.getConstraints()) {
                            if (declaredConstraint instanceof JvmUpperBound) {
                                for (JvmTypeConstraint actualConstraint : reference.getConstraints()) {
                                    if (!(actualConstraint instanceof JvmUpperBound)) continue;
                                    this.outerVisit(declaredConstraint.getTypeReference(), new ResolveInfo(actualConstraint.getTypeReference(), allowWildcardResolutions ? ResolveInfoKind.WC_UPPER : ResolveInfoKind.UPPER, param.hint));
                                }
                                continue;
                            }
                            for (JvmTypeConstraint actualConstraint : reference.getConstraints()) {
                                if (!(actualConstraint instanceof JvmLowerBound)) continue;
                                this.outerVisit(declaredConstraint.getTypeReference(), new ResolveInfo(actualConstraint.getTypeReference(), ResolveInfoKind.LOWER, param.hint));
                            }
                        }
                        return null;
                    }

                    @Override
                    public Void doVisitTypeReference(JvmTypeReference reference) {
                        boolean lowerBoundFound = false;
                        for (JvmTypeConstraint declaredConstraint : declaredReference.getConstraints()) {
                            if (!(declaredConstraint instanceof JvmLowerBound)) continue;
                            lowerBoundFound = true;
                            this.outerVisit(declaredConstraint.getTypeReference(), new ResolveInfo(reference, ResolveInfoKind.LOWER, param.hint));
                        }
                        if (!lowerBoundFound) {
                            for (JvmTypeConstraint declaredConstraint : declaredReference.getConstraints()) {
                                if (!(declaredConstraint instanceof JvmUpperBound)) continue;
                                this.outerVisit(declaredConstraint.getTypeReference(), new ResolveInfo(reference, ResolveInfoKind.UPPER, param.hint));
                            }
                        }
                        return null;
                    }
                }.visit(param.reference);
            }

            @Override
            public Void doVisitGenericArrayTypeReference(final JvmGenericArrayTypeReference declaredReference, final ResolveInfo param) {
                return (Void)new AbstractTypeReferenceVisitor.InheritanceAware<Void>(){

                    @Override
                    public Void doVisitCompoundTypeReference(JvmCompoundTypeReference reference) {
                        for (JvmTypeReference component : reference.getReferences()) {
                            this.visit(component);
                        }
                        return null;
                    }

                    @Override
                    public Void doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
                        return this.outerVisit(declaredReference.getComponentType(), new ResolveInfo(reference.getComponentType(), param.kind, param.hint));
                    }

                    @Override
                    public Void doVisitTypeReference(JvmTypeReference reference) {
                        return null;
                    }

                    @Override
                    protected Void handleNullReference() {
                        return null;
                    }
                }.visit(param.reference);
            }

            public Void outerVisit(JvmTypeReference reference, ResolveInfo parameter) {
                return (Void)this.visit(reference, parameter);
            }
        };
        implementation.visit(declaredType, new ResolveInfo(actualType, ResolveInfoKind.UPPER, hint));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractRequest
    implements Request {
        @Override
        public JvmTypeReference getReceiverType() {
            return null;
        }

        @Override
        public JvmFeature getFeature() {
            return null;
        }

        @Override
        public JvmTypeParameterDeclarator getNearestDeclarator() {
            return null;
        }

        @Override
        public List<JvmTypeReference> getArgumentTypes() {
            return null;
        }

        @Override
        public List<JvmTypeReference> getExplicitTypeArgument() {
            return null;
        }

        @Override
        public JvmTypeReference getExpectedType() {
            return null;
        }

        @Override
        public JvmTypeReference getDeclaredType() {
            return null;
        }
    }

    public static interface IInitializableTypeArgumentContext
    extends ITypeArgumentContext {
        public void initialize(Request var1, TypeArgumentContextProvider var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PrimitiveAwareMap
    extends ForwardingMap<JvmTypeParameter, JvmTypeReference> {
        private final Map<JvmTypeParameter, JvmTypeReference> delegate = Maps.newLinkedHashMap();
        private final Joiner.MapJoiner toStringHelper = Joiner.on("\n\t").withKeyValueSeparator("=");

        protected PrimitiveAwareMap() {
        }

        @Override
        protected Map<JvmTypeParameter, JvmTypeReference> delegate() {
            return this.delegate;
        }

        @Override
        public JvmTypeReference put(JvmTypeParameter key, JvmTypeReference value) {
            return super.put(key, TypeArgumentContextProvider.this.primitives.asWrapperTypeIfPrimitive(value));
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return super.toString();
            }
            return "(" + this.size() + " elements: {\n\t" + this.toStringHelper.join(this.delegate) + "\n}";
        }
    }

    public static class ReceiverRequest
    extends AbstractRequest {
        private final JvmTypeReference receiver;

        public ReceiverRequest(JvmTypeReference receiver) {
            this.receiver = receiver;
        }

        public JvmTypeReference getReceiverType() {
            return this.receiver;
        }

        public String toString() {
            return "ReceiverRequest [receiver=" + this.receiver + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Request {
        public JvmTypeReference getReceiverType();

        public JvmFeature getFeature();

        public JvmTypeParameterDeclarator getNearestDeclarator();

        public List<JvmTypeReference> getArgumentTypes();

        public List<JvmTypeReference> getExplicitTypeArgument();

        public JvmTypeReference getExpectedType();

        public JvmTypeReference getDeclaredType();

        public String toString();
    }

    protected static class ResolveInfo {
        protected final ResolveInfoKind kind;
        protected final JvmTypeReference reference;
        protected final int hint;

        protected ResolveInfo(JvmTypeReference reference, ResolveInfoKind kind, int hint) {
            this.reference = reference;
            this.kind = kind;
            this.hint = hint;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hint;
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResolveInfo other = (ResolveInfo)obj;
            if (this.hint != other.hint) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
        }

        public String toString() {
            return "ResolveInfo [kind=" + (Object)((Object)this.kind) + ", reference=" + this.reference + ", hint=" + this.hint + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ResolveInfoKind {
        EXACT,
        UPPER,
        WC_UPPER,
        LOWER,
        WC_LOWER;

    }
}

