/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtext.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedResourceMarkers
implements IDerivedResourceMarkers {
    public static final String MARKER_ID = "org.eclipse.xtext.builder.derivedresource";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_GENERATOR = "generator";
    @Inject
    private GeneratorIdProvider generatorIdProvider;

    public List<IMarker> findGeneratorMarkers(IContainer container) throws CoreException {
        return this.findGeneratorMarkers(container, this.generatorIdProvider.getGeneratorIdentifier());
    }

    public List<IMarker> findGeneratorMarkers(IContainer container, String generator) throws CoreException {
        IMarker[] markers;
        ArrayList<IMarker> result = Lists.newArrayList();
        if (!container.exists()) {
            return result;
        }
        IMarker[] iMarkerArray = markers = container.findMarkers(MARKER_ID, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (generator.equals(marker.getAttribute(ATTR_GENERATOR))) {
                result.add(marker);
            }
            ++n2;
        }
        return result;
    }

    public List<IFile> findDerivedResources(List<IMarker> generatorMarkers, String source) throws CoreException {
        ArrayList<IFile> result = Lists.newArrayList();
        for (IMarker marker : generatorMarkers) {
            if (!marker.exists() || source != null && !source.equals(marker.getAttribute(ATTR_SOURCE))) continue;
            result.add((IFile)marker.getResource());
        }
        return result;
    }

    @Override
    public List<IFile> findDerivedResources(IContainer container, String source) throws CoreException {
        return this.findDerivedResources(container, this.generatorIdProvider.getGeneratorIdentifier(), source);
    }

    public List<IFile> findDerivedResources(IContainer container, String generator, String source) throws CoreException {
        IMarker[] markers;
        ArrayList<IFile> result = Lists.newArrayList();
        if (!container.exists()) {
            return result;
        }
        IMarker[] iMarkerArray = markers = container.findMarkers(MARKER_ID, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            if (generator.equals(iMarker.getAttribute(ATTR_GENERATOR)) && (source == null || source.equals(iMarker.getAttribute(ATTR_SOURCE)))) {
                result.add((IFile)iMarker.getResource());
            }
            ++n2;
        }
        return result;
    }

    @Deprecated
    public IMarker[] findDerivedResourceMarkers(IFile file) throws CoreException {
        return this.findDerivedResourceMarkers((IResource)file);
    }

    @Override
    public IMarker[] findDerivedResourceMarkers(IResource file) throws CoreException {
        if (!file.isAccessible()) {
            return new IMarker[0];
        }
        return file.findMarkers(MARKER_ID, true, 2);
    }

    @Override
    public Iterable<IMarker> findDerivedResourceMarkers(IResource file, final String generatorId) throws CoreException {
        Iterable<IMarker> filtered = Iterables.filter(Arrays.asList(this.findDerivedResourceMarkers(file)), new Predicate<IMarker>(){

            @Override
            public boolean apply(IMarker input) {
                if (input.exists()) {
                    try {
                        if (generatorId != null && generatorId.equals(input.getAttribute(DerivedResourceMarkers.ATTR_GENERATOR))) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        return (Boolean)Exceptions.throwUncheckedException(e);
                    }
                }
                return false;
            }
        });
        return Lists.newArrayList(filtered);
    }

    @Override
    public IMarker findDerivedResourceMarker(IFile file, String source) throws CoreException {
        return this.findDerivedResourceMarker(file, this.generatorIdProvider.getGeneratorIdentifier(), source);
    }

    public IMarker findDerivedResourceMarker(IFile file, String generator, String source) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = this.findDerivedResourceMarkers(file);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            if (generator.equals(iMarker.getAttribute(ATTR_GENERATOR)) && source.equals(iMarker.getAttribute(ATTR_SOURCE))) {
                return iMarker;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getSource(IMarker marker) {
        try {
            Object result = marker.getAttribute(ATTR_SOURCE);
            if (result instanceof String) {
                return (String)result;
            }
            return null;
        }
        catch (CoreException e) {
            return null;
        }
    }

    @Override
    public boolean installMarker(IFile file, String source) throws CoreException {
        return this.installMarker(file, this.generatorIdProvider.getGeneratorIdentifier(), source);
    }

    public boolean installMarker(IFile file, String generator, String source) throws CoreException {
        IMarker marker;
        IMarker[] markers;
        if (!file.exists()) {
            return false;
        }
        IMarker[] iMarkerArray = markers = file.findMarkers(MARKER_ID, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            if (generator.equals(marker.getAttribute(ATTR_GENERATOR)) && source.equals(marker.getAttribute(ATTR_SOURCE))) {
                return true;
            }
            ++n2;
        }
        marker = file.createMarker(MARKER_ID);
        marker.setAttribute(ATTR_GENERATOR, generator);
        marker.setAttribute(ATTR_SOURCE, source);
        return true;
    }

    public static class GeneratorIdProvider {
        @Inject(optional=true)
        @Named(value="languageName")
        private String languageName = "no-language";

        public String getGeneratorIdentifier() {
            return this.languageName;
        }
    }
}

