/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.type.baseimpl.PolymorphicResolver;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Callable;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.StaticProperty;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeImpl
implements Type {
    private static final Log log = LogFactory.getLog(AbstractTypeImpl.class);
    private final TypeSystem typeSystem;
    private final String _name;
    private Set<Callable> allFeatures = null;
    private final Cache<String, Property> propertyCache = new Cache<String, Property>(){

        @Override
        protected Property createNew(String name) {
            return PolymorphicResolver.getProperty(AbstractTypeImpl.this.getAllFeatures(), name, AbstractTypeImpl.this);
        }
    };
    private final Cache<Signature, Operation> operationsCache = new Cache<Signature, Operation>(){

        @Override
        protected Operation createNew(Signature signature) {
            return PolymorphicResolver.getOperation(AbstractTypeImpl.this.getAllFeatures(), signature.name, AbstractTypeImpl.this, Arrays.asList(signature.parameterTypes));
        }
    };
    private Set<? extends Type> superTypes = null;

    public AbstractTypeImpl(TypeSystem typeSystem, String name) {
        this.typeSystem = typeSystem;
        this._name = name;
    }

    @Override
    public final TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    public abstract Feature[] getContributedFeatures();

    public final Set<Callable> getAllFeatures() {
        if (this.allFeatures == null) {
            this.allFeatures = new HashSet<Feature>(Arrays.asList(this.getContributedFeatures()));
            for (Type type : this.getSuperTypes()) {
                if (type != null) {
                    this.allFeatures.addAll(type.getAllFeatures());
                    continue;
                }
                log.error("A supertype of " + this.getName() + " is null!");
            }
        }
        return this.allFeatures;
    }

    @Override
    public StaticProperty getStaticProperty(String name) {
        return PolymorphicResolver.getStaticProperty(this.getAllFeatures(), name, this);
    }

    @Override
    public Property getProperty(String name) {
        return this.propertyCache.get(name);
    }

    @Override
    public Callable getFeature(String name, Type[] parameterTypes) {
        Property property = null;
        if (parameterTypes == null || parameterTypes.length == 0) {
            property = this.getProperty(name);
        }
        Operation operation = this.getOperation(name, parameterTypes);
        if (property != null && operation != null) {
            if (property.getOwner().equals(operation.getOwner())) {
                throw new RuntimeException();
            }
            if (property.getOwner().isAssignableFrom(operation.getOwner())) {
                return operation;
            }
            return property;
        }
        if (property != null) {
            return property;
        }
        return operation;
    }

    @Override
    public Operation getOperation(String name, Type[] parameterTypes) {
        return this.operationsCache.get(new Signature(name, parameterTypes));
    }

    @Override
    public Set<? extends StaticProperty> getAllStaticProperties() {
        return PolymorphicResolver.select(this.getAllFeatures(), StaticProperty.class);
    }

    @Override
    public Set<? extends Property> getAllProperties() {
        return PolymorphicResolver.select(this.getAllFeatures(), Property.class);
    }

    @Override
    public Set<? extends Operation> getAllOperations() {
        return PolymorphicResolver.select(this.getAllFeatures(), Operation.class);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Type) {
            return this.getName().equals(((Type)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public final boolean isAssignableFrom(Type t) {
        if (t == null) {
            return false;
        }
        if (this.equals(t)) {
            return true;
        }
        if (t.equals(this.getTypeSystem().getVoidType())) {
            return true;
        }
        return this.internalIsAssignableFrom(t);
    }

    protected boolean internalIsAssignableFrom(Type t) {
        for (Type type : t.getSuperTypes()) {
            if (!this.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object convert(Object src, Class<?> targetType) {
        if (src == null) {
            return null;
        }
        if (targetType.isInstance(src)) {
            return src;
        }
        throw new IllegalArgumentException(String.valueOf(this.getName()) + " is not responsible for java type " + targetType.getName());
    }

    @Override
    public String getDocumentation() {
        return "";
    }

    @Override
    public Set<? extends Type> getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = this.internalGetSuperTypes();
        }
        return this.superTypes;
    }

    protected Set<? extends Type> internalGetSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getObjectType());
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    private static class Signature {
        private static final Type[] EMPTY = new Type[0];
        protected final String name;
        protected final Type[] parameterTypes;

        Signature(String name, Type[] parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes == null ? EMPTY : parameterTypes;
        }

        public int hashCode() {
            int result = this.name == null ? 0 : this.name.hashCode();
            Type[] typeArray = this.parameterTypes;
            int n = this.parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                result *= 31;
                if (type != null) {
                    result += type.hashCode();
                }
                ++n2;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Signature)) {
                return false;
            }
            Signature signature = (Signature)obj;
            String otherName = signature.name;
            if (this.name != otherName && this.name != null && !this.name.equals(otherName)) {
                return false;
            }
            int length = this.parameterTypes.length;
            Type[] otherParameterTypes = signature.parameterTypes;
            if (length != otherParameterTypes.length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                Type type = this.parameterTypes[i];
                Type otherType = otherParameterTypes[i];
                if (type != otherType && type != null && !type.equals(otherType)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

