/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.PrefUtil;

public class HelpSearchAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public HelpSearchAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public HelpSearchAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.help.helpSearch");
        String overrideText = PrefUtil.getAPIPreferenceStore().getString("helpSearchActionText");
        if ("".equals(overrideText)) {
            this.setText(WorkbenchMessages.HelpSearchAction_text);
            this.setToolTipText(WorkbenchMessages.HelpSearchAction_toolTip);
        } else {
            this.setText(overrideText);
            this.setToolTipText(Action.removeMnemonics(overrideText));
        }
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_HELP_SEARCH"));
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.help_search_action_context");
    }

    @Override
    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        BusyIndicator.showWhile(null, new Runnable(){

            @Override
            public void run() {
                HelpSearchAction.this.workbenchWindow.getWorkbench().getHelpSystem().displaySearch();
            }
        });
    }

    @Override
    public void dispose() {
        this.workbenchWindow = null;
    }
}

