/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class SplitHandler
extends AbstractHandler {
    private EModelService modelService;
    private IWorkbenchWindow window;

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor(event);
        if (activeEditor == null) {
            return null;
        }
        MPart editorPart = (MPart)activeEditor.getSite().getService(MPart.class);
        if (editorPart == null) {
            return null;
        }
        this.window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        this.modelService = (EModelService)editorPart.getContext().get(EModelService.class);
        MPartStack stack = this.getStackFor(editorPart);
        if (stack == null) {
            return null;
        }
        this.window.getShell().setRedraw(false);
        try {
            MStackElement stackSelElement = (MStackElement)stack.getSelectedElement();
            MPart taggedEditor = editorPart;
            if (stackSelElement instanceof MCompositePart) {
                List innerElements = this.modelService.findElements((MUIElement)stackSelElement, null, MPart.class, null);
                taggedEditor = (MPart)innerElements.get(1);
            }
            if ("false".equals(event.getParameter("Splitter.isHorizontal"))) {
                if (taggedEditor.getTags().contains("Split Vertical")) {
                    taggedEditor.getTags().remove("Split Vertical");
                } else {
                    editorPart.getTags().remove("Split Horizontal");
                    editorPart.getTags().add("Split Vertical");
                }
            } else if (taggedEditor.getTags().contains("Split Horizontal")) {
                taggedEditor.getTags().remove("Split Horizontal");
            } else {
                editorPart.getTags().remove("Split Vertical");
                editorPart.getTags().add("Split Horizontal");
            }
        }
        finally {
            this.window.getShell().setRedraw(true);
        }
        return null;
    }

    private MPartStack getStackFor(MPart part) {
        MPart presentationElement = part.getCurSharedRef() == null ? part : part.getCurSharedRef();
        MElementContainer parent = presentationElement.getParent();
        while (parent != null && !(parent instanceof MPartStack)) {
            parent = parent.getParent();
        }
        return (MPartStack)parent;
    }
}

