/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ErrorStatement;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.FileStatement;
import org.eclipse.internal.xpand2.ast.ForEachStatement;
import org.eclipse.internal.xpand2.ast.IfStatement;
import org.eclipse.internal.xpand2.ast.LetStatement;
import org.eclipse.internal.xpand2.ast.ProtectStatement;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.model.AdvicedDefinition;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.ISyntaxElement;
import org.eclipse.internal.xtend.expression.debug.BaseSpecialTreatment;
import org.eclipse.internal.xtend.expression.debug.ExpressionModelPresentation;
import org.eclipse.xtend.expression.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandModelPresentation
extends ExpressionModelPresentation {
    public static Map<Class<? extends ISyntaxElement>, ElementRepresentation> eReps = new HashMap<Class<? extends ISyntaxElement>, ElementRepresentation>();

    public XpandModelPresentation(Set<BaseSpecialTreatment> specials) {
        super(specials);
        eReps.put(FileStatement.class, new ElementRepresentation("FILE", "ENDFILE"));
        eReps.put(ExpandStatement.class, new ElementRepresentation("EXPAND", "ENDDEFINE"));
        eReps.put(Definition.class, new ElementRepresentation("DEFINE", "ENDDEFINE"));
        eReps.put(AdvicedDefinition.class, new ElementRepresentation("AROUND", "ENDAROUND"));
        eReps.put(ForEachStatement.class, new ElementRepresentation("FOREACH", "ENDFOREACH"));
        eReps.put(IfStatement.class, new ElementRepresentation("IF", "ENDIF"));
        eReps.put(LetStatement.class, new ElementRepresentation("LET", "ENDLET"));
        eReps.put(ProtectStatement.class, new ElementRepresentation("PROTECT", "ENDPROTECT"));
        eReps.put(ErrorStatement.class, new ElementRepresentation("ERROR", ""));
    }

    @Override
    public SyntaxElement getStartPresentation(ISyntaxElement stmt, ExecutionContext context) {
        SyntaxElement to = new SyntaxElement();
        to.containerName = this.getContainerName(stmt);
        to.elementName = this.getStartingElementName(stmt, context);
        to.resource = this.getResource(stmt);
        to.start = stmt.getStart();
        to.end = this.getStartingEndPosition(stmt);
        to.line = stmt.getLine();
        return to;
    }

    @Override
    public SyntaxElement getEndPresentation(ISyntaxElement element, ExecutionContext context) {
        SyntaxElement to = new SyntaxElement();
        ISyntaxElement se = this.getEndSyntaxElement(element);
        to.containerName = this.getContainerName(se);
        to.elementName = this.getEndElementName(se);
        to.resource = this.getResource(se);
        to.start = this.getEndStartPosition(se);
        to.end = se.getEnd();
        to.line = se.getLine();
        return to;
    }

    @Override
    protected String getContainerName(ISyntaxElement se) {
        XpandDefinition def = se instanceof XpandDefinition ? (XpandDefinition)se : ((Statement)se).getContainingDefinition();
        if (def != null) {
            return String.valueOf(this.getTemplateName(se)) + "::" + this.getDefinitionName(def);
        }
        return "";
    }

    private String getDefinitionName(XpandDefinition def) {
        return String.valueOf(def.getName()) + def.getParamString(true) + " FOR " + def.getTargetType();
    }

    private String getStartingElementName(ISyntaxElement se, ExecutionContext context) {
        return se.getNameString(context);
    }

    private String getEndElementName(ISyntaxElement se) {
        ElementRepresentation rep = eReps.get(se.getClass());
        return rep != null ? rep.endName : ((Statement)se).getContainingDefinition().toString();
    }

    private int getEndStartPosition(ISyntaxElement se) {
        ElementRepresentation rep = eReps.get(se.getClass());
        return rep != null ? se.getEnd() - rep.endName.length() : se.getStart();
    }

    @Override
    public int getStartingEndPosition(ISyntaxElement stmt) {
        ElementRepresentation rep = eReps.get(stmt.getClass());
        int startLength = rep != null ? rep.startName.length() : 0;
        for (BaseSpecialTreatment special : this.specials) {
            int length = special.getElementNameLength(stmt);
            if (length == -1) continue;
            startLength = length;
            break;
        }
        return rep != null && startLength > 0 ? stmt.getStart() + startLength : stmt.getEnd();
    }

    private ISyntaxElement getEndSyntaxElement(ISyntaxElement stmt) {
        for (BaseSpecialTreatment special : this.specials) {
            ISyntaxElement se = special.getSpecialEndSyntaxElement(stmt);
            if (se == null) continue;
            return se;
        }
        return stmt;
    }

    public class ElementRepresentation {
        String startName;
        String endName;

        public ElementRepresentation(String startName, String endName) {
            this.startName = startName;
            this.endName = endName;
        }
    }
}

