/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.gwt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GWTBuilder
extends IncrementalProjectBuilder {
    protected static IPath[] CONTAINER_PATHS = new IPath[]{new Path("org.eclipse.pde.core.requiredPlugins"), new Path("com.google.appengine.eclipse.core.GAE_CONTAINER"), new Path("com.google.gwt.eclipse.core.GWT_CONTAINER")};

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        HashSet<IProject> result = new HashSet<IProject>();
        final IProject project = this.getProject();
        if (project.exists()) {
            IClasspathContainer pdeClasspathContainer;
            IClasspathContainer gwtClasspathContainer;
            int n;
            IWorkspaceRoot root = project.getWorkspace().getRoot();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathContainer gaeClasspathContainer = JavaCore.getClasspathContainer((IPath)new Path("com.google.appengine.eclipse.core.GAE_CONTAINER"), (IJavaProject)javaProject);
            if (gaeClasspathContainer != null) {
                IClasspathEntry[] iClasspathEntryArray = gaeClasspathContainer.getClasspathEntries();
                n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path;
                    int segmentCount;
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                    if (classpathEntry.getEntryKind() == 1 && classpathEntry.getContentKind() == 2 && (segmentCount = (path = classpathEntry.getPath()).segmentCount()) >= 4 && (path.segment(segmentCount - 2).equals("user") || path.segment(segmentCount - 3).equals("user"))) {
                        this.copy(URI.createFileURI(path.toOSString()), URI.createPlatformResourceURI(String.valueOf(project.getName()) + "/war/WEB-INF/lib/" + path.lastSegment(), true));
                    }
                    ++n2;
                }
            }
            if ((gwtClasspathContainer = JavaCore.getClasspathContainer((IPath)new Path("com.google.gwt.eclipse.core.GWT_CONTAINER"), (IJavaProject)javaProject)) != null) {
                IClasspathEntry[] iClasspathEntryArray = gwtClasspathContainer.getClasspathEntries();
                int n3 = iClasspathEntryArray.length;
                n = 0;
                while (n < n3) {
                    URI fileURI;
                    IPath path;
                    int segmentCount;
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n];
                    if (classpathEntry.getEntryKind() == 1 && classpathEntry.getContentKind() == 2 && (segmentCount = (path = classpathEntry.getPath()).segmentCount()) >= 2 && URIConverter.INSTANCE.exists(fileURI = URI.createFileURI((path = path.removeLastSegments(1).append("gwt-servlet.jar")).toOSString()), null)) {
                        this.copy(fileURI, URI.createPlatformResourceURI(String.valueOf(project.getName()) + "/war/WEB-INF/lib/" + path.lastSegment(), true));
                    }
                    ++n;
                }
            }
            if ((pdeClasspathContainer = JavaCore.getClasspathContainer((IPath)new Path("org.eclipse.pde.core.requiredPlugins"), (IJavaProject)javaProject)) != null) {
                IClasspathEntry[] iClasspathEntryArray = pdeClasspathContainer.getClasspathEntries();
                int n4 = iClasspathEntryArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n5];
                    if (classpathEntry.getEntryKind() == 2) {
                        IProject requiredProject = root.getProject(classpathEntry.getPath().segment(0));
                        IJavaProject requiredJavaProject = JavaCore.create((IProject)requiredProject);
                        IPath outputLocation = requiredJavaProject.getOutputLocation();
                        final int depth = outputLocation.segmentCount();
                        IFolder folder = root.getFolder(outputLocation);
                        folder.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource.getType() == 1) {
                                    IPath fullPath = resource.getFullPath();
                                    GWTBuilder.this.copy(URI.createPlatformResourceURI(fullPath.toString(), true), URI.createPlatformResourceURI(String.valueOf(project.getName()) + "/war/WEB-INF/classes/" + fullPath.removeFirstSegments(depth), true));
                                }
                                return true;
                            }
                        }, 2, 0);
                        result.add(requiredProject);
                    } else if (classpathEntry.getEntryKind() == 1 && classpathEntry.getContentKind() == 2) {
                        IPath path = classpathEntry.getPath();
                        this.copy(URI.createFileURI(path.toOSString()), URI.createPlatformResourceURI(String.valueOf(project.getName()) + "/war/WEB-INF/lib/" + path.lastSegment(), true));
                    }
                    ++n5;
                }
            }
        }
        return result.toArray(new IProject[result.size()]);
    }

    protected void copy(URI sourceURI, URI targetURI) {
        HashMap<String, Set<String>> options = new HashMap<String, Set<String>>();
        options.put("requestedAttributes", Collections.singleton("timeStamp"));
        Long sourceTimeStamp = (Long)URIConverter.INSTANCE.getAttributes(sourceURI, options).get("timeStamp");
        Long targetTimeStamp = (Long)URIConverter.INSTANCE.getAttributes(targetURI, options).get("timeStamp");
        if (targetTimeStamp == null || targetTimeStamp.compareTo(sourceTimeStamp) < 0) {
            try {
                OutputStream out = URIConverter.INSTANCE.createOutputStream(targetURI);
                InputStream in = URIConverter.INSTANCE.createInputStream(sourceURI);
                byte[] bytes = new byte[4048];
                int length = in.read(bytes);
                while (length > 0) {
                    out.write(bytes, 0, length);
                    length = in.read(bytes);
                }
                in.close();
                out.close();
            }
            catch (IOException exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(targetURI.toPlatformString(true)));
            if (file.exists() && !file.isDerived()) {
                this.setDerived(file);
            }
        }
        catch (CoreException exception) {
            CodeGenEcorePlugin.INSTANCE.log(exception);
        }
    }

    private void setDerived(IFile file) throws CoreException {
        file.setDerived(false);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        IProject project = this.getProject();
        if (project.exists() && (folder = project.getFolder(new Path("/war/WEB-INF/lib/"))).exists()) {
            final ArrayList filesToDelete = new ArrayList();
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1 && resource.isDerived()) {
                        filesToDelete.add((IFile)resource);
                        return false;
                    }
                    return true;
                }
            });
            monitor.beginTask("", filesToDelete.size());
            for (IFile file : filesToDelete) {
                file.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        super.clean(monitor);
    }
}

