/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.danieldietrich.protectedregions.core.DefaultDocument;
import net.danieldietrich.protectedregions.core.IDocument;
import net.danieldietrich.protectedregions.core.IRegionOracle;
import net.danieldietrich.protectedregions.core.IRegionParser;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultRegionParser
implements IRegionParser {
    private static final String[] END_OF_LINE_FLAVORS = new String[]{"\r\n", "\n", "\r"};
    private final String name;
    private final List<IRegionParser.ICommentType> commentTypes;
    private final List<IRegionParser.ICDataType> cdataTypes;
    private final IRegionOracle oracle;
    private final boolean inverse;

    DefaultRegionParser(String name, List<IRegionParser.ICommentType> commentTypes, List<IRegionParser.ICDataType> cdataTypes, IRegionOracle oracle, boolean inverse) {
        this.name = name;
        this.commentTypes = commentTypes;
        this.cdataTypes = cdataTypes;
        this.oracle = oracle;
        this.inverse = inverse;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public IDocument parse(InputStream in) throws IOException {
        return this.parse(IOUtils.toString(in));
    }

    @Override
    public IDocument parse(CharSequence in) {
        DefaultDocument result = new DefaultDocument();
        Input input = new Input(in.toString());
        while (!input.endOfDocumentReached()) {
            IDocument.IRegion region = this.getNextRegion(input);
            if (region.getText().length() <= 0) continue;
            result.addRegion(region);
        }
        if (input.hasRemaining()) {
            result.addRegion(this.remainingRegion(input));
        }
        return result;
    }

    @Override
    public boolean isInverse() {
        return this.inverse;
    }

    @Override
    public Iterable<IRegionParser.ICommentType> getCommentTypes() {
        return Collections.unmodifiableCollection(this.commentTypes);
    }

    @Override
    public Iterable<IRegionParser.ICDataType> getCDataTypes() {
        return Collections.unmodifiableCollection(this.cdataTypes);
    }

    private IDocument.IRegion getNextRegion(Input input) {
        String id;
        String comment;
        boolean isMarkedRegionEnd;
        boolean isMarkedRegionStart;
        boolean stateChanged;
        do {
            IRegionParser.ICommentType commentType;
            if ((commentType = this.getNextCommentType(input)) == null) {
                return this.remainingRegion(input);
            }
            if (commentType.isMultiline()) {
                comment = commentType.isNestable() ? this.getMultilineNestableComment(input, commentType) : this.getMultilineComment(input, commentType);
            } else if (!commentType.isNestable()) {
                comment = this.getSinglelineComment(input, commentType);
            } else {
                throw new IllegalStateException("Nestable singleline comments do not exist!");
            }
            isMarkedRegionStart = this.oracle.isMarkedRegionStart(comment);
            isMarkedRegionEnd = this.oracle.isMarkedRegionEnd(comment);
            if (input.isMarkedRegion() || !isMarkedRegionEnd) continue;
            Input.Between between = input.getPosition();
            throw new IllegalStateException("Detected marked region end without corresponding marked region start " + between + ", near [" + comment + "].");
        } while (!(stateChanged = !input.isMarkedRegion() && isMarkedRegionStart || input.isMarkedRegion() && isMarkedRegionEnd));
        if (!stateChanged) {
            return this.remainingRegion(input);
        }
        if (isMarkedRegionStart) {
            id = this.oracle.getId(comment);
            boolean enabled = this.oracle.isEnabled(comment);
            String text = input.enterMarkedRegion(id, enabled);
            return new Region(text);
        }
        if (isMarkedRegionEnd) {
            id = input.getMarkedRegionId();
            boolean enabled = input.isMarkedRegionEnabled();
            String text = input.leaveMarkedRegion();
            return new Region(id, text, enabled);
        }
        throw new IllegalStateException("tertium non datur");
    }

    private IDocument.IRegion remainingRegion(Input input) {
        if (input.isMarkedRegion()) {
            throw new IllegalStateException("Marked region does not end properly. ID: " + input.getMarkedRegionId());
        }
        return new Region(input.remaining());
    }

    private IRegionParser.ICommentType getNextCommentType(Input input) {
        while (true) {
            IndexOfObject<IRegionParser.ICDataType> firstCData = this.findLowestIndex(input, new InnerIterator<IRegionParser.ICDataType, String>(this.cdataTypes.iterator()){

                @Override
                protected String getInner(IRegionParser.ICDataType outer) {
                    return outer.getStart();
                }
            });
            IndexOfObject<IRegionParser.ICommentType> firstComment = this.findLowestIndex(input, new InnerIterator<IRegionParser.ICommentType, String>(this.commentTypes.iterator()){

                @Override
                protected String getInner(IRegionParser.ICommentType outer) {
                    return outer.getStart();
                }
            });
            if (firstCData.object == null) {
                return this.extractComment(input, (IRegionParser.ICommentType)firstComment.object, firstComment.index);
            }
            if (firstComment.index < firstCData.index) {
                return this.extractComment(input, (IRegionParser.ICommentType)firstComment.object, firstComment.index);
            }
            this.findEndOfCharacterData(input, firstCData);
        }
    }

    private void findEndOfCharacterData(Input input, IndexOfObject<IRegionParser.ICDataType> cdata) {
        input.update(cdata.index, ((IRegionParser.ICDataType)cdata.object).getStart().length());
        String end = ((IRegionParser.ICDataType)cdata.object).getEnd();
        String escapeString = ((IRegionParser.ICDataType)cdata.object).getEscapeString();
        while (true) {
            int indexOfEscapeString = escapeString != null ? input.indexOf(escapeString) : -1;
            int indexOfCDataEnd = input.indexOf(end);
            if (indexOfEscapeString == -1) {
                if (indexOfCDataEnd == -1) {
                    Input.Between between = input.getPosition();
                    throw new IllegalStateException("Character data end '" + end + "' not found " + between);
                }
                input.update(indexOfCDataEnd, end.length());
                break;
            }
            if (indexOfCDataEnd != -1 && indexOfCDataEnd < indexOfEscapeString) {
                input.update(indexOfCDataEnd, end.length());
                break;
            }
            input.update(indexOfEscapeString, 2);
        }
    }

    private IRegionParser.ICommentType extractComment(Input input, IRegionParser.ICommentType commentType, int index) {
        if (commentType == null) {
            input.noCommentFound();
            return null;
        }
        input.setCommentStart(index);
        input.update(index, commentType.getStart().length());
        return commentType;
    }

    private <T> IndexOfObject<T> findLowestIndex(Input input, InnerIterator<T, String> strings) {
        Object object = null;
        int lowestIndex = Integer.MAX_VALUE;
        for (String string : strings) {
            int i = input.indexOf(string);
            if (i == -1 || i >= lowestIndex) continue;
            lowestIndex = i;
            object = strings.currentOuter();
        }
        return new IndexOfObject<Object>(lowestIndex, object);
    }

    private String getMultilineComment(Input input, IRegionParser.ICommentType type) {
        int i = input.indexOf(type.getEnd());
        if (i == -1) {
            throw new IllegalArgumentException("Comment does not end properly: " + input.getStringAtCursor());
        }
        return input.consume(i, type.getEnd().length());
    }

    private String getMultilineNestableComment(Input input, IRegionParser.ICommentType type) {
        StringBuilder result = new StringBuilder();
        int depth = 1;
        do {
            String part;
            int startIndex = input.indexOf(type.getStart());
            int endIndex = input.indexOf(type.getEnd());
            if (startIndex != -1 && startIndex < endIndex) {
                ++depth;
                part = input.consume(startIndex + type.getStart().length(), 0);
                result.append(part);
                continue;
            }
            if (endIndex != -1) {
                part = --depth == 0 ? input.consume(endIndex, type.getEnd().length()) : input.consume(endIndex + type.getEnd().length(), 0);
                result.append(part);
                continue;
            }
            throw new IllegalArgumentException("Comment does not end properly: " + input.getStringAtCursor());
        } while (depth > 0);
        return result.toString();
    }

    private String getSinglelineComment(Input input, IRegionParser.ICommentType type) {
        String eol = null;
        int lowestIndex = Integer.MAX_VALUE;
        String[] stringArray = END_OF_LINE_FLAVORS;
        int n = END_OF_LINE_FLAVORS.length;
        int n2 = 0;
        while (n2 < n) {
            String currentEol = stringArray[n2];
            int i = input.indexOf(currentEol);
            if (i != -1 && i < lowestIndex) {
                lowestIndex = i;
                eol = currentEol;
            }
            ++n2;
        }
        if (eol == null) {
            return input.getStringAtCursor();
        }
        return input.consume(lowestIndex, eol.length());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexOfObject<T> {
        final int index;
        final T object;

        IndexOfObject(int index, T object) {
            this.index = index;
            this.object = object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class InnerIterator<O, I>
    implements Iterable<I>,
    Iterator<I> {
        private final Iterator<O> outerIterator;
        private O currentOuter;

        InnerIterator(Iterator<O> outerIterator) {
            this.outerIterator = outerIterator;
        }

        @Override
        public Iterator<I> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.outerIterator.hasNext();
        }

        @Override
        public I next() {
            this.currentOuter = this.outerIterator.next();
            return this.getInner(this.currentOuter);
        }

        @Override
        public void remove() {
        }

        public O currentOuter() {
            return this.currentOuter;
        }

        protected abstract I getInner(O var1);
    }

    private static class Input {
        final String document;
        String markedRegionId;
        boolean markedRegionEnabled;
        int marker = 0;
        int index = 0;
        int lastIndex = 0;
        int commentStart;
        private static final Pattern EOL = Pattern.compile("(\\r\\n|\\n|\\r)");

        Input(String document) {
            this.document = document;
        }

        boolean endOfDocumentReached() {
            return this.index >= this.document.length();
        }

        boolean hasRemaining() {
            return this.marker < this.document.length();
        }

        String remaining() {
            String result = this.document.substring(this.marker);
            this.index = this.marker = this.document.length();
            return result;
        }

        String getStringAtCursor() {
            return this.document.substring(this.index);
        }

        String consume(int endIndex, int additionalChars) {
            String result = this.document.substring(this.index, endIndex);
            this.lastIndex = this.index;
            this.index = endIndex + additionalChars;
            return result;
        }

        void update(int endIndex, int additionalChars) {
            if (this.index > endIndex + additionalChars) {
                throw new IllegalStateException("cannot step back - bug in the parser!");
            }
            this.index = endIndex + additionalChars;
        }

        int indexOf(String substring) {
            return this.document.indexOf(substring, this.index);
        }

        String enterMarkedRegion(String id, boolean enabled) {
            this.markedRegionId = id;
            this.markedRegionEnabled = enabled;
            String result = this.document.substring(this.marker, this.commentStart);
            this.marker = this.commentStart;
            return result;
        }

        String leaveMarkedRegion() {
            this.markedRegionId = null;
            this.markedRegionEnabled = false;
            String result = this.document.substring(this.marker, this.index);
            this.marker = this.index;
            return result;
        }

        boolean isMarkedRegion() {
            return this.markedRegionId != null;
        }

        String getMarkedRegionId() {
            return this.markedRegionId;
        }

        boolean isMarkedRegionEnabled() {
            return this.markedRegionEnabled;
        }

        void setCommentStart(int index) {
            this.commentStart = index;
        }

        void noCommentFound() {
            this.commentStart = -1;
        }

        Between getPosition() {
            return new Between(this.internal_getCursor(this.lastIndex), this.internal_getCursor(this.index));
        }

        private Cursor internal_getCursor(int idx) {
            String documentToCursor = this.document.substring(0, idx);
            Matcher matcher = EOL.matcher(documentToCursor);
            int line = 1;
            while (matcher.find()) {
                ++line;
            }
            int eol = Math.max(documentToCursor.lastIndexOf("\r"), documentToCursor.lastIndexOf("\n"));
            int len = documentToCursor.length();
            int column = len == 0 ? 1 : len - (eol == -1 ? 0 : eol);
            return new Cursor(line, column);
        }

        static class Between {
            final Cursor start;
            final Cursor end;

            Between(Cursor start, Cursor end) {
                this.start = start;
                this.end = end;
            }

            public String toString() {
                return "between " + this.start.toString() + " and " + this.end.toString();
            }
        }

        static class Cursor {
            final int line;
            final int column;

            Cursor(int line, int column) {
                this.line = line;
                this.column = column;
            }

            public String toString() {
                return "(" + this.line + "," + this.column + ")";
            }
        }
    }

    private static class Region
    implements IDocument.IRegion {
        final Boolean enabled;
        final String id;
        final String text;

        Region(String text) {
            this.enabled = null;
            this.id = null;
            this.text = text;
        }

        Region(String id, String text, Boolean enabled) {
            if (id == null) {
                throw new IllegalArgumentException("Id of region cannot be null.");
            }
            if (enabled == null) {
                throw new IllegalArgumentException("Region has to be enabled or disabled.");
            }
            this.enabled = enabled;
            this.id = id;
            this.text = text;
        }

        public String toString() {
            return this.id;
        }

        public boolean isMarkedRegion() {
            return this.id != null;
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }
    }
}

