/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Attributes;
import fr.esrf.tango.pogo.generator.cpp.utils.Commands;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppTypeDefinitions;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Pipes;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PropType;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.Type;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class DeviceInclude {
    @Inject
    @Extension
    private CppStringUtils _cppStringUtils;
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private Commands _commands;
    @Inject
    @Extension
    private Attributes _attributes;
    @Inject
    @Extension
    private Pipes _pipes;
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;

    public CharSequence generateDeviceIncludeFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _fileHeader = this.fileHeader(cls);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*  ");
        String _name = cls.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" class description:");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*    ");
        ClassDescription _description = cls.getDescription();
        String _description_1 = _description.getDescription();
        String _comments = StringUtils.comments(_description_1, "*    ");
        _builder.append((Object)_comments, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("_ns");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        String _buildEnums = this._cppStringUtils.buildEnums(cls);
        _builder.append((Object)_buildEnums, "");
        _builder.newLineIfNotEmpty();
        String _protectedArea = this._protectedArea.protectedArea(cls, "Additional Class Declarations", "Additional Class Declarations", true);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append(" : public ");
        String _inheritedClassNameForDevice = this._inheritanceUtils.inheritedClassNameForDevice(cls);
        _builder.append((Object)_inheritedClassNameForDevice, "");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.newLine();
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "Data Members", "Add your own data members", true);
        _builder.append((Object)_protectedArea_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _declareDevicePropertyDataMembers = this.declareDevicePropertyDataMembers(cls);
        _builder.append((Object)_declareDevicePropertyDataMembers, "");
        _builder.newLineIfNotEmpty();
        CharSequence _declareAttributeDataMembers = this.declareAttributeDataMembers(cls);
        _builder.append((Object)_declareAttributeDataMembers, "");
        _builder.newLineIfNotEmpty();
        CharSequence _declareConstructors = this.declareConstructors(cls);
        _builder.append((Object)_declareConstructors, "");
        _builder.newLineIfNotEmpty();
        CharSequence _declareGlobals = this.declareGlobals(cls);
        _builder.append((Object)_declareGlobals, "");
        _builder.newLineIfNotEmpty();
        CharSequence _declareAttributes = this.declareAttributes(cls);
        _builder.append((Object)_declareAttributes, "");
        _builder.newLineIfNotEmpty();
        CharSequence _declarePipes = this.declarePipes(cls);
        _builder.append((Object)_declarePipes, "");
        _builder.newLineIfNotEmpty();
        CharSequence _declareCommands = this.declareCommands(cls);
        _builder.append((Object)_declareCommands, "");
        _builder.newLineIfNotEmpty();
        String _protectedArea_2 = this._protectedArea.protectedArea(cls, "Additional Method prototypes", "Additional Method prototypes", true);
        _builder.append((Object)_protectedArea_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        String _protectedArea_3 = this._protectedArea.protectedArea(cls, "Additional Classes Definitions", "Additional Classes Definitions", true);
        _builder.append((Object)_protectedArea_3, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}\t//\tEnd of namespace");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif   //\t");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("_H");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence fileHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _deviceIncludeFileHeader = this._headers.deviceIncludeFileHeader(cls);
        String _plus = String.valueOf(_deviceIncludeFileHeader) + "\n\n";
        String _plus_1 = String.valueOf(_plus) + "#ifndef ";
        String _name = cls.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        String _plus_3 = String.valueOf(_plus_2) + "_H\n";
        String _plus_4 = String.valueOf(_plus_3) + "#define ";
        String _name_1 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_1;
        String _plus_6 = String.valueOf(_plus_5) + "_H\n\n";
        String _plus_7 = String.valueOf(_plus_6) + "#include <tango.h>\n";
        String _inheritanceIncludeList = this._inheritanceUtils.inheritanceIncludeList(cls, false);
        String _plus_8 = String.valueOf(_plus_7) + _inheritanceIncludeList;
        String _protectedArea = this._protectedArea.protectedArea(cls, ".h", _plus_8, false);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence declareDevicePropertyDataMembers(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        int _size = _deviceProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("//\tDevice property data members");
            _builder.newLine();
            _builder.append("public:");
            _builder.newLine();
            EList<Property> _deviceProperties_1 = cls.getDeviceProperties();
            for (Property property : _deviceProperties_1) {
                boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(property);
                if (!_isConcreteHere) continue;
                _builder.append("\t");
                _builder.append("//\t");
                String _name = property.getName();
                _builder.append((Object)_name, "\t");
                _builder.append(":\t");
                String _description = property.getDescription();
                String _comments = StringUtils.comments(_description, "//  ");
                _builder.append((Object)_comments, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                PropType _type = property.getType();
                String _cppPropType = CppTypeDefinitions.cppPropType(_type);
                _builder.append((Object)_cppPropType, "\t");
                _builder.append("\t");
                String _name_1 = property.getName();
                String _dataMemberName = this._cppStringUtils.dataMemberName(_name_1);
                _builder.append((Object)_dataMemberName, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            EList<Property> _deviceProperties_2 = cls.getDeviceProperties();
            boolean _hasMandatoryProperty = this._cppStringUtils.hasMandatoryProperty(_deviceProperties_2);
            if (_hasMandatoryProperty) {
                _builder.newLine();
                _builder.append("\t");
                _builder.append("bool\tmandatoryNotDefined;");
                _builder.newLine();
            }
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence declareAttributeDataMembers(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _attributes = cls.getAttributes();
        int _size = _attributes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("//\tAttribute data members");
            _builder.newLine();
            _builder.append("public:");
            _builder.newLine();
            EList<Attribute> _attributes_1 = cls.getAttributes();
            for (Attribute attr : _attributes_1) {
                boolean _isRead;
                boolean _and = false;
                InheritanceStatus _status = attr.getStatus();
                String _concreteHere = _status.getConcreteHere();
                boolean _isTrue = StringUtils.isTrue(_concreteHere);
                _and = !_isTrue ? false : (_isRead = StringUtils.isRead(attr));
                if (!_and) continue;
                Type _dataType = attr.getDataType();
                String _cppType = CppTypeDefinitions.cppType(_dataType);
                boolean _contains = _cppType.contains("Enum");
                if (_contains) {
                    _builder.append("\t");
                    String _name = attr.getName();
                    _builder.append((Object)_name, "\t");
                    _builder.append("Enum\t*attr_");
                    String _name_1 = attr.getName();
                    _builder.append((Object)_name_1, "\t");
                    _builder.append("_read;");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                Type _dataType_1 = attr.getDataType();
                String _cppType_1 = CppTypeDefinitions.cppType(_dataType_1);
                _builder.append((Object)_cppType_1, "\t");
                _builder.append("\t*attr_");
                String _name_2 = attr.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append("_read;");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence declareConstructors(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//\tConstructors and destructors");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Constructs a newly device object.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\t@param cl\tClass.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\t@param s \tDevice Name");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        String _name = cls.getName();
        _builder.append((Object)_name, "\t");
        _builder.append("(Tango::DeviceClass *cl,string &s);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Constructs a newly device object.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\t@param cl\tClass.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\t@param s \tDevice Name");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("(Tango::DeviceClass *cl,const char *s);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Constructs a newly device object.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\t@param cl\tClass.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\t@param s \tDevice name");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\t@param d\tDevice description.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("(Tango::DeviceClass *cl,const char *s,const char *d);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The device object destructor.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("~");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append("() {delete_device();};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence declareGlobals(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//\tMiscellaneous methods");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\twill be called at device destruction or at init command.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void delete_device();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\tInitialize the device");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void init_device();");
        _builder.newLine();
        boolean _and = false;
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        int _size = _deviceProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (!_greaterThan) {
            _and = false;
        } else {
            boolean _isTrue;
            ClassDescription _description = cls.getDescription();
            String _hasConcreteProperty = _description.getHasConcreteProperty();
            _and = _isTrue = StringUtils.isTrue(_hasConcreteProperty);
        }
        if (_and) {
            _builder.append("\t");
            _builder.append("/*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*\tRead the device properties from database");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("void get_device_property();");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*\tAlways executed method before execution command method.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void always_executed_hook();");
        _builder.newLine();
        _builder.newLine();
        EList<Property> _deviceProperties_1 = cls.getDeviceProperties();
        boolean _hasMandatoryProperty = this._cppStringUtils.hasMandatoryProperty(_deviceProperties_1);
        if (_hasMandatoryProperty) {
            _builder.append("\t");
            _builder.append("/*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*\tCheck if mandatory property has been set");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("void check_mandatory_property(Tango::DbDatum &class_prop, Tango::DbDatum &dev_prop);");
            _builder.newLine();
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence declareAttributes(PogoDeviceClass cls) {
        boolean _greaterThan_1;
        EList<Attribute> _attributes;
        int _size;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//\tAttribute methods");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _simpleMethodHeader1 = this._headers.simpleMethodHeader1(cls, "read_attr_hardware", "Hardware acquisition for attributes.");
        _builder.append((Object)_simpleMethodHeader1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual void read_attr_hardware(vector<long> &attr_list);");
        _builder.newLine();
        boolean _hasWritableAttribute = CppStringUtils.hasWritableAttribute(cls);
        if (_hasWritableAttribute) {
            _builder.append("\t");
            String _simpleMethodHeader1_1 = this._headers.simpleMethodHeader1(cls, "write_attr_hardware", "Hardware writing for attributes.");
            _builder.append((Object)_simpleMethodHeader1_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("virtual void write_attr_hardware(vector<long> &attr_list);");
            _builder.newLine();
        }
        boolean bl = _greaterThan = (_size = (_attributes = cls.getAttributes()).size()) > 0;
        if (_greaterThan) {
            _builder.newLine();
            EList<Attribute> _attributes_1 = cls.getAttributes();
            for (Attribute attr : _attributes_1) {
                boolean _isWrite;
                boolean _equals;
                boolean _alreadyOverloaded = this._inheritanceUtils.alreadyOverloaded(attr);
                boolean bl2 = _equals = !_alreadyOverloaded;
                if (!_equals) continue;
                String _attributePrototypeMethodHeader = this._headers.attributePrototypeMethodHeader(attr);
                _builder.append((Object)_attributePrototypeMethodHeader, "");
                _builder.newLineIfNotEmpty();
                boolean _isRead = StringUtils.isRead(attr);
                if (_isRead) {
                    _builder.append("\t");
                    _builder.append("virtual void ");
                    String _readAttrubuteMethod = this._attributes.readAttrubuteMethod(attr);
                    _builder.append((Object)_readAttrubuteMethod, "\t");
                    _builder.append("(Tango::Attribute &attr)");
                    String _checkAbstractForProto = this._inheritanceUtils.checkAbstractForProto(attr);
                    _builder.append((Object)_checkAbstractForProto, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                if (_isWrite = StringUtils.isWrite(attr)) {
                    _builder.append("\t");
                    _builder.append("virtual void ");
                    String _writeAttrubuteMethod = this._attributes.writeAttrubuteMethod(attr);
                    _builder.append((Object)_writeAttrubuteMethod, "\t");
                    _builder.append("(Tango::WAttribute &attr)");
                    String _checkAbstractForProto_1 = this._inheritanceUtils.checkAbstractForProto(attr);
                    _builder.append((Object)_checkAbstractForProto_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("virtual bool is_");
                String _name = attr.getName();
                _builder.append((Object)_name, "\t");
                _builder.append("_allowed(Tango::AttReqType type);");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        int _size_1 = _dynamicAttributes.size();
        boolean bl3 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append("//\tDynamic attribute methods");
            _builder.newLine();
            _builder.append("public:");
            _builder.newLine();
            EList<Attribute> _dynamicAttributes_1 = cls.getDynamicAttributes();
            for (Attribute attr_1 : _dynamicAttributes_1) {
                boolean _isWrite_1;
                _builder.newLine();
                _builder.append("\t");
                String _attributePrototypeMethodHeader_1 = this._headers.attributePrototypeMethodHeader(attr_1);
                _builder.append((Object)_attributePrototypeMethodHeader_1, "\t");
                _builder.newLineIfNotEmpty();
                boolean _isRead_1 = StringUtils.isRead(attr_1);
                if (_isRead_1) {
                    _builder.append("\t");
                    _builder.append("virtual void ");
                    String _readAttrubuteMethod_1 = this._attributes.readAttrubuteMethod(attr_1);
                    _builder.append((Object)_readAttrubuteMethod_1, "\t");
                    _builder.append("(Tango::Attribute &attr);");
                    _builder.newLineIfNotEmpty();
                }
                if (_isWrite_1 = StringUtils.isWrite(attr_1)) {
                    _builder.append("\t");
                    _builder.append("virtual void ");
                    String _writeAttrubuteMethod_1 = this._attributes.writeAttrubuteMethod(attr_1);
                    _builder.append((Object)_writeAttrubuteMethod_1, "\t");
                    _builder.append("(Tango::WAttribute &attr);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("virtual bool is_");
                String _name_1 = attr_1.getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append("_allowed(Tango::AttReqType type);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _addDynamicAttributeSignature = this._cppStringUtils.addDynamicAttributeSignature(cls, attr_1, true);
                _builder.append((Object)_addDynamicAttributeSignature, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _removeDynamicAttributeSignature = this._cppStringUtils.removeDynamicAttributeSignature(cls, attr_1, true);
                _builder.append((Object)_removeDynamicAttributeSignature, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                Type _dataType = attr_1.getDataType();
                String _cppType = CppTypeDefinitions.cppType(_dataType);
                _builder.append((Object)_cppType, "\t");
                _builder.append(" *get_");
                String _name_2 = attr_1.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append("_data_ptr(string &name);");
                _builder.newLineIfNotEmpty();
                boolean _isScalar = this._cppStringUtils.isScalar(attr_1);
                if (_isScalar) {
                    _builder.append("\t");
                    _builder.append("map<string,");
                    Type _dataType_1 = attr_1.getDataType();
                    String _cppType_1 = CppTypeDefinitions.cppType(_dataType_1);
                    _builder.append((Object)_cppType_1, "\t");
                    _builder.append(">\t   ");
                    String _name_3 = attr_1.getName();
                    _builder.append((Object)_name_3, "\t");
                    _builder.append("_data;");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("map<string,");
                Type _dataType_2 = attr_1.getDataType();
                String _cppType_2 = CppTypeDefinitions.cppType(_dataType_2);
                _builder.append((Object)_cppType_2, "\t");
                _builder.append(" *>\t   ");
                String _name_4 = attr_1.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append("_data;");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, "add_dynamic_attributes", "Add dynamic attributes if any.");
        _builder.append((Object)_simpleMethodHeader, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void add_dynamic_attributes();");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence declarePipes(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Pipe> _pipes = cls.getPipes();
        int _size = _pipes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("//\tpipe related methods");
            _builder.newLine();
            _builder.append("public:");
            _builder.newLine();
            EList<Pipe> _pipes_1 = cls.getPipes();
            for (Pipe pipe : _pipes_1) {
                _builder.append("\t");
                CharSequence _declareMethods = this._pipes.declareMethods(pipe);
                _builder.append((Object)_declareMethods, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence declareCommands(PogoDeviceClass cls) {
        boolean _greaterThan_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Command> _commands = cls.getCommands();
        int _size = _commands.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("//\tCommand related methods");
            _builder.newLine();
            _builder.append("public:");
            _builder.newLine();
            EList<Command> _commands_1 = cls.getCommands();
            for (Command command : _commands_1) {
                String _name_1;
                boolean _equals_2;
                boolean _equals_3;
                boolean _equals_1;
                boolean _isConcreteHere;
                boolean _or = false;
                boolean _isAbstract = this._inheritanceUtils.isAbstract(command);
                _or = _isAbstract ? true : (_isConcreteHere = this._inheritanceUtils.isConcreteHere(command));
                if (!_or) continue;
                _builder.append("\t");
                String _commandExecutionMethodHeader = this._headers.commandExecutionMethodHeader(command);
                _builder.append((Object)_commandExecutionMethodHeader, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _commandExecutionMethodSignature = this._commands.commandExecutionMethodSignature(cls, command, true);
                _builder.append((Object)_commandExecutionMethodSignature, "\t");
                _builder.newLineIfNotEmpty();
                boolean _and = false;
                String _name = command.getName();
                boolean _equals = _name.equals("State");
                boolean bl2 = _equals_1 = !_equals;
                _and = !_equals_1 ? false : (_equals_3 = !(_equals_2 = (_name_1 = command.getName()).equals("Status")));
                if (!_and) continue;
                _builder.append("\t");
                _builder.append("virtual bool is_");
                String _name_2 = command.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append("_allowed(const CORBA::Any &any);");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        EList<Command> _dynamicCommands = cls.getDynamicCommands();
        int _size_1 = _dynamicCommands.size();
        boolean bl3 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append("//\tDynamic commands methods");
            _builder.newLine();
            _builder.append("public:");
            _builder.newLine();
            EList<Command> _dynamicCommands_1 = cls.getDynamicCommands();
            for (Command command_1 : _dynamicCommands_1) {
                _builder.append("\t");
                String _commandExecutionMethodHeader_1 = this._headers.commandExecutionMethodHeader(command_1);
                _builder.append((Object)_commandExecutionMethodHeader_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _commandExecutionMethodSignature_1 = this._commands.commandExecutionMethodSignature(cls, command_1, true);
                _builder.append((Object)_commandExecutionMethodSignature_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("virtual bool is_");
                String _name_3 = command_1.getName();
                _builder.append((Object)_name_3, "\t");
                _builder.append("_allowed(const CORBA::Any &any);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _addDynamicCommandSignature = this._cppStringUtils.addDynamicCommandSignature(cls, command_1, true);
                _builder.append((Object)_addDynamicCommandSignature, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _removeDynamicCommandSignature = this._cppStringUtils.removeDynamicCommandSignature(cls, command_1, true);
                _builder.append((Object)_removeDynamicCommandSignature, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, "add_dynamic_commands", "Add dynamic commands if any.");
        _builder.append((Object)_simpleMethodHeader, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void add_dynamic_commands();");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

