/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import java.util.Vector;
import pogo.class2www.Module;
import pogo.class2www.Repositories;
import pogo.class2www.Utils;
import pogo.gene.PogoUtil;

public class CheckNewClasses {
    private Repositories repositories;
    private String log_filename;
    private String mail_filename;
    private String send_mail;
    private static final String relative_filename = "/log/class_list.txt";
    private static final String rel_mail_filename = "/log/mail.html";
    private static final String rel_send_mail = "/log/send_mail";

    public CheckNewClasses(String dirname, Repositories repositories) {
        this.repositories = repositories;
        this.log_filename = dirname + relative_filename;
        this.mail_filename = dirname + rel_mail_filename;
        this.send_mail = dirname + rel_send_mail;
    }

    private String[] readPreviousClassList() {
        String[] list = new String[]{};
        try {
            String code = PogoUtil.readFile(this.log_filename);
            list = PogoUtil.string2array(code);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return list;
    }

    public Vector readTestFile() {
        String[] list = new String[]{};
        try {
            String test_filename = this.log_filename.substring(0, this.log_filename.lastIndexOf(46)) + ".sav";
            String code = PogoUtil.readFile(test_filename);
            list = PogoUtil.string2array(code);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(-1);
        }
        Vector<String> v = new Vector<String>();
        for (String s : list) {
            v.add(s);
        }
        return v;
    }

    public void check() {
        String[] previous_classes = this.readPreviousClassList();
        Vector classes = new Vector();
        for (int i = 0; i < this.repositories.size(); ++i) {
            Vector v1 = this.repositories.getRepository(i).getClassList();
            for (Object o : v1) {
                classes.add(o);
            }
        }
        Vector v = new Vector();
        for (Object o : classes) {
            String name = ((Module)o).server.class_name;
            boolean found = false;
            for (int i = 0; !found && i < previous_classes.length; ++i) {
                found = previous_classes[i].equals(name);
            }
            if (found) continue;
            v.add(o);
        }
        if (v.size() > 0) {
            Module[] modules = new Module[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                modules[i] = (Module)v.get(i);
            }
            this.sendMail(modules);
        }
        this.saveNewClassList(classes);
    }

    private void sendMail(Module[] modules) {
        System.out.println(modules.length + "  new classes");
        for (Module module : modules) {
            System.out.println(module.server.class_name);
        }
        try {
            String header = Utils.readTemplateFile("header.html");
            StringBuffer sb = new StringBuffer(header);
            String str = "<Center><h1><u>Tango Device Server Classes</u></h1></Center><Br /><Br />\n<Br /><Br /><HR WIDTH=\"100%\" />\n<b>$NB_CLASSES new class has been found during TANGO repositories scan.</b>\n";
            str = PogoUtil.strReplace(str, "$NB_CLASSES", "" + modules.length);
            sb.append(str);
            for (Module module : modules) {
                sb.append(module.getSummary());
            }
            PogoUtil.writeFile(this.mail_filename, sb.toString());
            String mail_list = System.getProperty("_MAIL_LIST_");
            if (mail_list == null || mail_list.length() == 0) {
                throw new Exception("No mail list specified !");
            }
            String cmd = this.send_mail + " " + this.mail_filename + " " + mail_list;
            System.out.println(cmd);
            String resp = PogoUtil.executeShellCmd(cmd);
            System.out.println("execution returns:\n" + resp);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void saveNewClassList(Vector classes) {
        Vector<String> classnames = new Vector<String>();
        for (Object o : classes) {
            classnames.add(((Module)o).server.class_name);
        }
        try {
            String code = PogoUtil.array2string(classnames);
            PogoUtil.writeFile(this.log_filename, code);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void main(String[] args) {
        Repositories rep = new Repositories();
        CheckNewClasses cnc = new CheckNewClasses("/segfs/tango/backup", rep);
        cnc.check();
    }
}

