/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;

public class StateMachineDialog
extends JDialog
implements PogoConst {
    private PogoDeviceClass pogoClass;
    private int retVal = 0;
    private Buttons buttons = new Buttons();
    private static final int COMMAND = 0;
    private static final int READ_ATTRIBUTE = 1;
    private static final int WRITE_ATTRIBUTE = 2;
    private static final int READ_PIPE = 3;
    private static final int WRITE_PIPE = 4;
    private JPanel mainPanel;
    private JScrollPane panelScrollPane;
    private JLabel titleLabel;

    public StateMachineDialog(JFrame jFrame, PogoDeviceClass pogoDeviceClass) {
        super((Frame)jFrame, true);
        this.pogoClass = pogoDeviceClass;
        this.initComponents();
        this.createOwnComponents();
        this.titleLabel.setText(pogoDeviceClass.getName() + " State Machine");
        this.pack();
        this.checkSize();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void checkSize() {
        boolean bl = false;
        int n = this.panelScrollPane.getWidth();
        int n2 = this.panelScrollPane.getHeight();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if ((double)n > 0.7 * dimension.getWidth()) {
            bl = true;
            n = (int)(0.7 * dimension.getWidth());
        }
        if ((double)n2 > 0.7 * dimension.getHeight()) {
            bl = true;
            n2 = (int)(0.7 * dimension.getHeight());
        }
        if (bl) {
            this.panelScrollPane.setPreferredSize(new Dimension(n += 20, n2 += 20));
            this.pack();
        }
    }

    private void addColumnHeader(int n, String string, String string2, EList<State> eList) {
        Font font = new Font("Dialog", 1, 16);
        int n2 = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        gridBagConstraints.insets = new Insets(15, 20, 0, 20);
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n++;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(string2);
        jLabel.setFont(font);
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        gridBagConstraints.gridx = n2++;
        gridBagConstraints.gridy = n;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        if (eList != null) {
            for (State state : eList) {
                jLabel = new JLabel(state.getName());
                jLabel.setFont(font);
                gridBagConstraints.insets = new Insets(0, 20, 0, 20);
                gridBagConstraints.gridx = n2++;
                gridBagConstraints.gridy = n;
                this.mainPanel.add((Component)jLabel, gridBagConstraints);
            }
        }
    }

    private void addLineHeader(int n, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
    }

    private AllowedBtn addAllowedButton(int n, int n2, State state, EList<String> eList) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AllowedBtn allowedBtn = new AllowedBtn("", state.getName());
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        allowedBtn.setSelected(true);
        allowedBtn.setFont(new Font("Dialog", 0, 10));
        this.mainPanel.add((Component)allowedBtn, gridBagConstraints);
        for (String string : eList) {
            if (!state.getName().equals(string)) continue;
            allowedBtn.setSelected(false);
        }
        return allowedBtn;
    }

    private void createOwnComponents() {
        Iterator iterator;
        Object object;
        Object object2;
        EList<State> eList = this.pogoClass.getStates();
        int n = 0;
        EList<Command> eList2 = this.pogoClass.getCommands();
        if (eList2.size() > 2) {
            this.addColumnHeader(n, "Select Allowed", "Commands", eList);
            n += 2;
            object2 = eList2.iterator();
            while (object2.hasNext()) {
                object = (Command)object2.next();
                if (object.getName().equals("State") || object.getName().equals("Status")) continue;
                this.addCommandLine(n++, (Command)object, eList);
            }
        }
        if (!(object2 = this.pogoClass.getAttributes()).isEmpty()) {
            this.addColumnHeader(n, "Select Allowed", "Attributes", eList);
            n += 2;
            object = object2.iterator();
            while (object.hasNext()) {
                iterator = (Attribute)object.next();
                this.addAttributeLine(n++, (Attribute)((Object)iterator), 1, eList);
                if (iterator.getRwType().equals(AttrRWtypeArray[0])) continue;
                this.addAttributeLine(n++, (Attribute)((Object)iterator), 2, eList);
            }
        }
        if (!(object = this.pogoClass.getPipes()).isEmpty()) {
            this.addColumnHeader(n, "Select Allowed", "Pipes", eList);
            n += 2;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Pipe pipe = (Pipe)iterator.next();
                this.addPipeLine(n++, pipe, 3, eList);
                if (pipe.getRwType().equals(AttrRWtypeArray[0])) continue;
                this.addPipeLine(n++, pipe, 4, eList);
            }
        }
        iterator = new GridBagConstraints();
        ((GridBagConstraints)((Object)iterator)).insets = new Insets(20, 0, 0, 0);
        ((GridBagConstraints)((Object)iterator)).gridx = 0;
        ((GridBagConstraints)((Object)iterator)).gridy = n;
        this.mainPanel.add((Component)new JLabel("  "), iterator);
    }

    private void addCommandLine(int n, Command command, EList<State> eList) {
        this.addLineHeader(n, "  " + command.getName());
        BtnLine btnLine = new BtnLine(command.getName(), 0);
        EList<String> eList2 = command.getExcludedStates();
        int n2 = 1;
        for (State state : eList) {
            btnLine.add(this.addAllowedButton(n2++, n, state, eList2));
        }
        this.buttons.add(btnLine);
    }

    private void addAttributeLine(int n, Attribute attribute, int n2, EList<State> eList) {
        EList<String> eList2;
        String string;
        if (n2 == 1) {
            string = " (Read)";
            eList2 = attribute.getReadExcludedStates();
        } else {
            string = " (Write)";
            eList2 = attribute.getWriteExcludedStates();
        }
        this.addLineHeader(n, "  " + attribute.getName() + string);
        BtnLine btnLine = new BtnLine(attribute.getName(), n2);
        int n3 = 1;
        for (State state : eList) {
            btnLine.add(this.addAllowedButton(n3++, n, state, eList2));
        }
        this.buttons.add(btnLine);
    }

    private void addPipeLine(int n, Pipe pipe, int n2, EList<State> eList) {
        EList<String> eList2;
        String string;
        if (n2 == 3) {
            string = " (Read)";
            eList2 = pipe.getReadExcludedStates();
        } else {
            string = " (Write)";
            eList2 = pipe.getWriteExcludedStates();
        }
        this.addLineHeader(n, "  " + pipe.getName() + string);
        BtnLine btnLine = new BtnLine(pipe.getName(), n2);
        int n3 = 1;
        for (State state : eList) {
            btnLine.add(this.addAllowedButton(n3++, n, state, eList2));
        }
        this.buttons.add(btnLine);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.panelScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StateMachineDialog.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateMachineDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateMachineDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("State Machine");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.mainPanel.setLayout(new GridBagLayout());
        this.panelScrollPane.setViewportView(this.mainPanel);
        this.getContentPane().add((Component)this.panelScrollPane, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public PogoDeviceClass getPogoClass() {
        Object object;
        List<String> list;
        Object object22;
        Object object3;
        EList<Command> eList = this.pogoClass.getCommands();
        for (Command object42 : eList) {
            object3 = this.buttons.getLine(object42.getName(), 0);
            if (object3 == null) continue;
            object22 = object42.getExcludedStates();
            object22.clear();
            list = ((ArrayList)object3).iterator();
            while (list.hasNext()) {
                object = (AllowedBtn)list.next();
                if (((AbstractButton)object).getSelectedObjects() != null) continue;
                object22.add(((AllowedBtn)object).name);
            }
        }
        EList<Attribute> eList2 = this.pogoClass.getAttributes();
        Iterator iterator = eList2.iterator();
        while (iterator.hasNext()) {
            Object object4;
            object3 = (Attribute)iterator.next();
            object22 = this.buttons.getLine(object3.getName(), 1);
            if (object22 != null) {
                list = object3.getReadExcludedStates();
                list.clear();
                object = ((ArrayList)object22).iterator();
                while (object.hasNext()) {
                    object4 = (AllowedBtn)object.next();
                    if (((AbstractButton)object4).getSelectedObjects() != null) continue;
                    list.add(((AllowedBtn)object4).name);
                }
            }
            if (object3.getRwType().equals(AttrRWtypeArray[0]) || (object22 = this.buttons.getLine(object3.getName(), 2)) == null) continue;
            list = object3.getWriteExcludedStates();
            list.clear();
            object = ((ArrayList)object22).iterator();
            while (object.hasNext()) {
                object4 = (AllowedBtn)object.next();
                if (((AbstractButton)object4).getSelectedObjects() != null) continue;
                list.add(((AllowedBtn)object4).name);
            }
        }
        EList<Pipe> eList3 = this.pogoClass.getPipes();
        for (Object object22 : eList3) {
            list = this.buttons.getLine(object22.getName(), 3);
            if (list != null) {
                object = object22.getReadExcludedStates();
                object.clear();
                for (AllowedBtn allowedBtn : list) {
                    if (allowedBtn.getSelectedObjects() != null) continue;
                    object.add((String)allowedBtn.name);
                }
            }
            if (!object22.getRwType().contains("WRITE") || (list = this.buttons.getLine(object22.getName(), 4)) == null) continue;
            object = object22.getWriteExcludedStates();
            object.clear();
            for (AllowedBtn allowedBtn : list) {
                if (allowedBtn.getSelectedObjects() != null) continue;
                object.add((String)allowedBtn.name);
            }
        }
        return this.pogoClass;
    }

    private class AllowedBtn
    extends JRadioButton {
        String name;

        private AllowedBtn(String string, String string2) {
            this.setText(string);
            this.name = string2;
        }
    }

    private class BtnLine
    extends ArrayList<AllowedBtn> {
        String name;
        int type;

        private BtnLine(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }

    private class Buttons
    extends ArrayList<BtnLine> {
        private Buttons() {
        }

        private BtnLine getLine(String string, int n) {
            for (BtnLine btnLine : this) {
                if (!btnLine.name.equals(string) || btnLine.type != n) continue;
                return btnLine;
            }
            return null;
        }
    }
}

