/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Type;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.EnumDialog;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class AttributeDialog
extends JDialog
implements PogoConst {
    private int retVal = 0;
    private PogoGUI pogo_gui;
    private InheritanceStatus orig_status = null;
    private boolean isDynamic = false;
    private int poll_period = 0;
    private Attribute attribute;
    private String[] enumLabels = null;
    private static final String defaultDataType = AttrDataArray[9];
    private static final int EMPTY_FIELD = -1;
    private static final int NEGATIVE_FIELD = -2;
    private static final int INVALID_FIELD = -3;
    private JRadioButton abstractBtn;
    private JRadioButton allocateBtn;
    private JRadioButton archiveEvtChecked;
    private JRadioButton archiveEvtCode;
    private JLabel assAttrLBL;
    private JTextField assAttrTF;
    private JTextField attrPropDeltaTime;
    private JTextField attrPropDeltaValue;
    private JTextArea attrPropDescription;
    private JTextField attrPropDispUnit;
    private JTextField attrPropFormat;
    private JTextField attrPropLabel;
    private JTextField attrPropMaxAlarm;
    private JTextField attrPropMaxValue;
    private JTextField attrPropMaxWarning;
    private JTextField attrPropMinAlarm;
    private JTextField attrPropMinValue;
    private JTextField attrPropMinWarning;
    private JTextField attrPropStdUnit;
    private JTextField attrPropUnit;
    private JComboBox<String> attrTypeCB;
    private JRadioButton changeEvtChecked;
    private JRadioButton changeEvtCode;
    private JRadioButton dataReadyEvtCode;
    private JComboBox<String> dataTypeCB;
    private JPanel definitionPanel;
    private JLabel dynamicLbl;
    private JButton enumDefinitionBtn;
    private JTextField evAbsChangeTxt;
    private JTextField evArchAbsChangeTxt;
    private JTextField evArchPeriodTxt;
    private JTextField evArchRelChangeTxt;
    private JTextField evPeriodTxt;
    private JTextField evRelChangeTxt;
    private JLabel evTitleLbl;
    private JTextField nameText;
    private JRadioButton overloadBtn;
    private JComboBox<String> rwTypeCB;
    private JLabel xDataLBL;
    private JTextField xDataTF;
    private JLabel yDataLBL;
    private JTextField yDataTF;
    private JRadioButton levelBtn;
    private JRadioButton polledBtn;
    private JRadioButton memorizedBtn;
    private JRadioButton memorizedInitBtn;
    private JLabel periodLabel;
    private JLabel periodUnitLabel;
    private JTextField periodText;
    private static int[] columnSize = new int[]{140, 70, 130, 40, 40, 40, 80, 40, 40, 400};
    private static String[] columnTitle = new String[]{"Name", "Type", "DataType", "Writable", "Memorized", "Size", "Level", "Inherited", "Abstract", "Description"};

    public AttributeDialog(PogoGUI pogoGUI, int n, boolean bl) {
        this(pogoGUI, null);
        this.isDynamic = bl;
        this.attrTypeCB.setSelectedIndex(n);
        this.updateWindow();
        this.dynamicLbl.setVisible(bl);
    }

    public AttributeDialog(PogoGUI pogoGUI, Attribute attribute) {
        super((Frame)pogoGUI, true);
        this.pogo_gui = pogoGUI;
        this.attribute = attribute;
        if (attribute != null) {
            this.orig_status = attribute.getStatus();
            this.isDynamic = Utils.isTrue(attribute.getIsDynamic());
        }
        this.initComponents();
        this.initOwnComponents();
        this.initializeWindow();
        this.manageInheritanceStatus(attribute);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initOwnComponents() {
        for (String string : AttrDataArray) {
            this.dataTypeCB.addItem(string);
        }
        this.dataTypeCB.setSelectedItem(defaultDataType);
        for (String string : AttrTypeArray) {
            this.attrTypeCB.addItem(string);
        }
        for (String string : AttrRWtypeArray) {
            this.rwTypeCB.addItem(string);
        }
        int n = 14;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Controlled by : ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.fill = 2;
        this.definitionPanel.add((Component)jLabel, gridBagConstraints);
        this.levelBtn = new JRadioButton();
        this.levelBtn.setToolTipText(Utils.buildToolTip("Display Level", "Expert or Operator"));
        this.levelBtn.setText(" Expert Only  ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        this.definitionPanel.add((Component)this.levelBtn, gridBagConstraints);
        this.polledBtn = new JRadioButton();
        this.polledBtn.setToolTipText(Utils.buildToolTip("Attribute polled"));
        this.polledBtn.setText("Polled");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.definitionPanel.add((Component)this.polledBtn, gridBagConstraints);
        this.polledBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.polledBtnActionPerformed(actionEvent);
            }
        });
        this.periodLabel = new JLabel("  Polling Period :");
        this.periodLabel.setHorizontalAlignment(4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.definitionPanel.add((Component)this.periodLabel, gridBagConstraints);
        this.periodText = new JTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        this.definitionPanel.add((Component)this.periodText, gridBagConstraints);
        this.periodText.setRequestFocusEnabled(true);
        this.periodUnitLabel = new JLabel(" ms  ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        this.definitionPanel.add((Component)this.periodUnitLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        this.definitionPanel.add((Component)new JLabel(" "), gridBagConstraints);
        this.setPeriodEnabled(false);
        this.memorizedBtn = new JRadioButton();
        this.memorizedBtn.setToolTipText(Utils.buildToolTip("Attribute memorized", "The write attribute value will be stored in database\nAnd at next startup, the write attribute value will\nbe set to this stored value."));
        this.memorizedBtn.setText(" Memorized  ");
        this.memorizedBtn.setVisible(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        this.definitionPanel.add((Component)this.memorizedBtn, gridBagConstraints);
        this.memorizedBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.memorizedBtnActionPerformed(actionEvent);
            }
        });
        this.memorizedInitBtn = new JRadioButton();
        this.memorizedInitBtn.setToolTipText(Utils.buildToolTip("Write at init", "At each device initialization\nthe write attribute method will be called\nwith the value stored in database at previous write."));
        this.memorizedInitBtn.setText(" Write hardware at init ");
        this.memorizedInitBtn.setVisible(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        this.definitionPanel.add((Component)this.memorizedInitBtn, gridBagConstraints);
        this.enumDefinitionBtn.setVisible(false);
    }

    private void setPeriodEnabled(boolean bl) {
        this.periodLabel.setVisible(bl);
        this.periodText.setVisible(bl);
        this.periodUnitLabel.setVisible(bl);
        if (bl) {
            String string = this.poll_period == 0 ? "3000" : "" + this.poll_period;
            this.periodText.setText(string);
            this.pack();
        }
    }

    private void manageAbstractOverloadButtons() {
        this.abstractBtn.setSelected(Utils.isTrue(this.orig_status.getAbstract()));
        if (this.isDynamic) {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setVisible(false);
            this.setEditable(true);
        } else if (Utils.isTrue(this.orig_status.getInherited())) {
            this.abstractBtn.setVisible(false);
            this.overloadBtn.setVisible(true);
            boolean bl = Utils.isTrue(this.orig_status.getConcreteHere());
            this.overloadBtn.setSelected(bl);
            this.setEditable(false);
        } else {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setVisible(true);
            this.abstractBtn.setSelected(Utils.isTrue(this.orig_status.getAbstract()));
            this.setEditable(true);
        }
    }

    private void manageInheritanceStatus(Attribute attribute) {
        if (attribute != null) {
            this.manageAbstractOverloadButtons();
        } else {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setSelected(false);
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
            this.setEditable(true);
        }
    }

    private void setNotEditable(JComboBox<String> jComboBox) {
        String string = (String)jComboBox.getSelectedItem();
        if (string != null) {
            jComboBox.removeAllItems();
            jComboBox.addItem(string);
        }
    }

    private void setEditable(boolean bl) {
        this.nameText.setEditable(bl);
        if (!bl) {
            this.setNotEditable(this.attrTypeCB);
            this.setNotEditable(this.dataTypeCB);
            this.setNotEditable(this.rwTypeCB);
        }
        this.levelBtn.setEnabled(bl);
        this.changeEvtCode.setEnabled(bl);
        this.changeEvtChecked.setEnabled(bl);
        this.archiveEvtCode.setEnabled(bl);
        this.archiveEvtChecked.setEnabled(bl);
        this.evPeriodTxt.setEnabled(bl);
        this.evRelChangeTxt.setEnabled(bl);
        this.evAbsChangeTxt.setEnabled(bl);
        this.evArchPeriodTxt.setEnabled(bl);
        this.evArchRelChangeTxt.setEnabled(bl);
        this.evArchAbsChangeTxt.setEnabled(bl);
        this.dataReadyEvtCode.setEnabled(bl);
        this.memorizedBtn.setEnabled(bl);
        this.attrPropDeltaTime.setEditable(bl);
        this.attrPropDeltaValue.setEditable(bl);
        this.attrPropDescription.setEditable(bl);
        this.attrPropDispUnit.setEditable(bl);
        this.attrPropFormat.setEditable(bl);
        this.attrPropLabel.setEditable(bl);
        this.attrPropMaxAlarm.setEditable(bl);
        this.attrPropMaxValue.setEditable(bl);
        this.attrPropMaxWarning.setEditable(bl);
        this.attrPropMinAlarm.setEditable(bl);
        this.attrPropMinValue.setEditable(bl);
        this.attrPropMinWarning.setEditable(bl);
        this.attrPropStdUnit.setEditable(bl);
        this.attrPropUnit.setEditable(bl);
    }

    private void memorizedBtnActionPerformed(ActionEvent actionEvent) {
        this.memorizedInitBtn.setVisible(this.memorizedBtn.getSelectedObjects() != null);
    }

    private void polledBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.polledBtn.getSelectedObjects() != null;
        this.setPeriodEnabled(bl);
        if (bl) {
            this.periodText.selectAll();
            this.periodText.requestFocus();
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.definitionPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.attrTypeCB = new JComboBox();
        JLabel jLabel2 = new JLabel();
        this.nameText = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.dataTypeCB = new JComboBox();
        this.xDataLBL = new JLabel();
        this.yDataLBL = new JLabel();
        this.xDataTF = new JTextField();
        this.yDataTF = new JTextField();
        this.rwTypeCB = new JComboBox();
        this.assAttrLBL = new JLabel();
        this.assAttrTF = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.abstractBtn = new JRadioButton();
        this.overloadBtn = new JRadioButton();
        JLabel jLabel5 = new JLabel();
        this.allocateBtn = new JRadioButton();
        this.dynamicLbl = new JLabel();
        this.enumDefinitionBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.attrPropLabel = new JTextField();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.attrPropUnit = new JTextField();
        this.attrPropStdUnit = new JTextField();
        this.attrPropDispUnit = new JTextField();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        JLabel jLabel13 = new JLabel();
        JLabel jLabel14 = new JLabel();
        JLabel jLabel15 = new JLabel();
        this.attrPropFormat = new JTextField();
        this.attrPropMaxValue = new JTextField();
        this.attrPropMinValue = new JTextField();
        this.attrPropMaxAlarm = new JTextField();
        this.attrPropMinAlarm = new JTextField();
        JLabel jLabel16 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.attrPropDescription = new JTextArea();
        JLabel jLabel17 = new JLabel();
        JLabel jLabel18 = new JLabel();
        this.attrPropDeltaTime = new JTextField();
        this.attrPropDeltaValue = new JTextField();
        JLabel jLabel19 = new JLabel();
        JLabel jLabel20 = new JLabel();
        this.attrPropMaxWarning = new JTextField();
        this.attrPropMinWarning = new JTextField();
        JPanel jPanel3 = new JPanel();
        this.evTitleLbl = new JLabel();
        JLabel jLabel21 = new JLabel();
        JLabel jLabel22 = new JLabel();
        JLabel jLabel23 = new JLabel();
        JLabel jLabel24 = new JLabel();
        JLabel jLabel25 = new JLabel();
        JLabel jLabel26 = new JLabel();
        JLabel jLabel27 = new JLabel();
        JLabel jLabel28 = new JLabel();
        JLabel jLabel29 = new JLabel();
        JLabel jLabel30 = new JLabel();
        this.evPeriodTxt = new JTextField();
        this.evRelChangeTxt = new JTextField();
        this.evAbsChangeTxt = new JTextField();
        this.evArchPeriodTxt = new JTextField();
        this.evArchRelChangeTxt = new JTextField();
        this.evArchAbsChangeTxt = new JTextField();
        JLabel jLabel31 = new JLabel();
        JLabel jLabel32 = new JLabel();
        this.changeEvtCode = new JRadioButton();
        this.changeEvtChecked = new JRadioButton();
        this.archiveEvtCode = new JRadioButton();
        this.archiveEvtChecked = new JRadioButton();
        this.dataReadyEvtCode = new JRadioButton();
        JLabel jLabel33 = new JLabel();
        JLabel jLabel34 = new JLabel();
        JLabel jLabel35 = new JLabel();
        JLabel jLabel36 = new JLabel();
        this.setTitle("Edit Attribute Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AttributeDialog.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new FlowLayout(2));
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        jTabbedPane.setToolTipText("");
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AttributeDialog.this.tabbedPaneStateChanged(changeEvent);
            }
        });
        this.definitionPanel.setLayout(new GridBagLayout());
        jLabel.setFont(new Font("Arial", 1, 18));
        jLabel.setText("Attribute name: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)jLabel, gridBagConstraints);
        this.attrTypeCB.setFont(new Font("Arial", 1, 12));
        this.attrTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.attrTypeCBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add(this.attrTypeCB, gridBagConstraints);
        jLabel2.setFont(new Font("Arial", 1, 12));
        jLabel2.setText("Attribute Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)jLabel2, gridBagConstraints);
        this.nameText.setColumns(15);
        this.nameText.setFont(new Font("Arial", 1, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.definitionPanel.add((Component)this.nameText, gridBagConstraints);
        jLabel3.setFont(new Font("Arial", 1, 12));
        jLabel3.setText("Data Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)jLabel3, gridBagConstraints);
        this.dataTypeCB.setFont(new Font("Arial", 1, 12));
        this.dataTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.dataTypeCBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add(this.dataTypeCB, gridBagConstraints);
        this.xDataLBL.setFont(new Font("Arial", 1, 12));
        this.xDataLBL.setText("Maximum X data size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)this.xDataLBL, gridBagConstraints);
        this.yDataLBL.setFont(new Font("Arial", 1, 12));
        this.yDataLBL.setText("Maximum Y data size: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)this.yDataLBL, gridBagConstraints);
        this.xDataTF.setFont(new Font("Arial", 1, 12));
        this.xDataTF.setMinimumSize(new Dimension(100, 20));
        this.xDataTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add((Component)this.xDataTF, gridBagConstraints);
        this.yDataTF.setFont(new Font("Arial", 1, 12));
        this.yDataTF.setMinimumSize(new Dimension(100, 20));
        this.yDataTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add((Component)this.yDataTF, gridBagConstraints);
        this.rwTypeCB.setFont(new Font("Arial", 1, 12));
        this.rwTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.rwTypeCBActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add(this.rwTypeCB, gridBagConstraints);
        this.assAttrLBL.setFont(new Font("Arial", 1, 12));
        this.assAttrLBL.setText("Associated Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 0);
        this.definitionPanel.add((Component)this.assAttrLBL, gridBagConstraints);
        this.assAttrTF.setFont(new Font("Arial", 1, 12));
        this.assAttrTF.setMinimumSize(new Dimension(100, 20));
        this.assAttrTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 3);
        this.definitionPanel.add((Component)this.assAttrTF, gridBagConstraints);
        jLabel4.setFont(new Font("Arial", 1, 12));
        jLabel4.setText("Read/Write Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)jLabel4, gridBagConstraints);
        this.abstractBtn.setFont(new Font("Arial", 1, 12));
        this.abstractBtn.setText("Abstract Attribute");
        this.abstractBtn.setHorizontalAlignment(2);
        this.abstractBtn.setHorizontalTextPosition(2);
        this.abstractBtn.setMargin(new Insets(2, 12, 2, 12));
        this.abstractBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.abstractBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 0);
        this.definitionPanel.add((Component)this.abstractBtn, gridBagConstraints);
        this.overloadBtn.setFont(new Font("Arial", 1, 12));
        this.overloadBtn.setText("Overload Attribute");
        this.overloadBtn.setHorizontalAlignment(2);
        this.overloadBtn.setHorizontalTextPosition(2);
        this.overloadBtn.setMargin(new Insets(2, 12, 2, 12));
        this.overloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.overloadBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 0);
        this.definitionPanel.add((Component)this.overloadBtn, gridBagConstraints);
        jLabel5.setFont(new Font("Arial", 1, 12));
        jLabel5.setText("Allocate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 10);
        this.definitionPanel.add((Component)jLabel5, gridBagConstraints);
        this.allocateBtn.setFont(new Font("Arial", 1, 12));
        this.allocateBtn.setSelected(true);
        this.allocateBtn.setText("Read data member");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 3);
        this.definitionPanel.add((Component)this.allocateBtn, gridBagConstraints);
        this.dynamicLbl.setFont(new Font("Arial", 1, 12));
        this.dynamicLbl.setText("Dynamic Attribute (Add/Remove attribute will be done by code)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.definitionPanel.add((Component)this.dynamicLbl, gridBagConstraints);
        this.enumDefinitionBtn.setText("Enum Labels");
        this.enumDefinitionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.enumDefinitionBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        this.definitionPanel.add((Component)this.enumDefinitionBtn, gridBagConstraints);
        jTabbedPane.addTab("Definition", null, this.definitionPanel, "Attribute definition.");
        jPanel2.setLayout(new GridBagLayout());
        jLabel6.setFont(new Font("Dialog", 0, 12));
        jLabel6.setText("Default Attribute Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        jLabel7.setFont(new Font("Dialog", 0, 12));
        jLabel7.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropLabel, gridBagConstraints);
        jLabel8.setFont(new Font("Dialog", 0, 12));
        jLabel8.setText("Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel8, gridBagConstraints);
        jLabel9.setFont(new Font("Dialog", 0, 12));
        jLabel9.setText("Standard Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel9, gridBagConstraints);
        jLabel10.setFont(new Font("Dialog", 0, 12));
        jLabel10.setText("Display Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropStdUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropDispUnit, gridBagConstraints);
        jLabel11.setFont(new Font("Dialog", 0, 12));
        jLabel11.setText("Display Format       ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel11, gridBagConstraints);
        jLabel12.setFont(new Font("Dialog", 0, 12));
        jLabel12.setText("Max. Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel12, gridBagConstraints);
        jLabel13.setFont(new Font("Dialog", 0, 12));
        jLabel13.setText("Min. Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel13, gridBagConstraints);
        jLabel14.setFont(new Font("Dialog", 0, 12));
        jLabel14.setText("Max. Alarm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel14, gridBagConstraints);
        jLabel15.setFont(new Font("Dialog", 0, 12));
        jLabel15.setText("Min. Alarm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropMaxValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropMinValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropMaxAlarm, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropMinAlarm, gridBagConstraints);
        jLabel16.setFont(new Font("Dialog", 0, 12));
        jLabel16.setText("Description :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel16, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(350, 100));
        this.attrPropDescription.setColumns(80);
        this.attrPropDescription.setRows(20);
        jScrollPane.setViewportView(this.attrPropDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        jLabel17.setFont(new Font("Dialog", 0, 12));
        jLabel17.setText("Delta time");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel17, gridBagConstraints);
        jLabel18.setFont(new Font("Dialog", 0, 12));
        jLabel18.setText("Delta value   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel18, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropDeltaTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropDeltaValue, gridBagConstraints);
        jLabel19.setFont(new Font("Dialog", 0, 12));
        jLabel19.setText("Max Warning");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel19, gridBagConstraints);
        jLabel20.setFont(new Font("Dialog", 0, 12));
        jLabel20.setText("Min Warning");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel20, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropMaxWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.attrPropMinWarning, gridBagConstraints);
        jTabbedPane.addTab("Properties", null, jPanel2, "Attribute Properties");
        jPanel3.setLayout(new GridBagLayout());
        this.evTitleLbl.setFont(new Font("Dialog", 1, 18));
        this.evTitleLbl.setText("Attribute");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 20, 10);
        jPanel3.add((Component)this.evTitleLbl, gridBagConstraints);
        jLabel21.setFont(new Font("Dialog", 1, 18));
        jLabel21.setText("Default events:");
        jLabel21.setToolTipText("Events managed by TANGO library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)jLabel21, gridBagConstraints);
        jLabel22.setText("Periodic Event:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel3.add((Component)jLabel22, gridBagConstraints);
        jLabel23.setText("Change Event:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel3.add((Component)jLabel23, gridBagConstraints);
        jLabel24.setText("Archive Event:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel3.add((Component)jLabel24, gridBagConstraints);
        jLabel25.setText("Period:");
        jLabel25.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 10, 0);
        jPanel3.add((Component)jLabel25, gridBagConstraints);
        jLabel26.setText("Absolute:");
        jLabel26.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 10, 0);
        jPanel3.add((Component)jLabel26, gridBagConstraints);
        jLabel27.setText("Relative:");
        jLabel27.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)jLabel27, gridBagConstraints);
        jLabel28.setText("Period:");
        jLabel28.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)jLabel28, gridBagConstraints);
        jLabel29.setText("Relative:");
        jLabel29.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)jLabel29, gridBagConstraints);
        jLabel30.setText("Absolute:");
        jLabel30.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 10, 0);
        jPanel3.add((Component)jLabel30, gridBagConstraints);
        this.evPeriodTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        jPanel3.add((Component)this.evPeriodTxt, gridBagConstraints);
        this.evRelChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)this.evRelChangeTxt, gridBagConstraints);
        this.evAbsChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        jPanel3.add((Component)this.evAbsChangeTxt, gridBagConstraints);
        this.evArchPeriodTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)this.evArchPeriodTxt, gridBagConstraints);
        this.evArchRelChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)this.evArchRelChangeTxt, gridBagConstraints);
        this.evArchAbsChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        jPanel3.add((Component)this.evArchAbsChangeTxt, gridBagConstraints);
        jLabel31.setFont(new Font("Dialog", 1, 18));
        jLabel31.setText("           ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jLabel31, gridBagConstraints);
        jLabel32.setFont(new Font("Dialog", 1, 18));
        jLabel32.setText("Pushed events by user code:");
        jLabel32.setToolTipText("Events pushed by user code.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel3.add((Component)jLabel32, gridBagConstraints);
        this.changeEvtCode.setText("Change Event");
        this.changeEvtCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.changeEvtCodeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.changeEvtCode, gridBagConstraints);
        this.changeEvtChecked.setText("Criteria managed by library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        jPanel3.add((Component)this.changeEvtChecked, gridBagConstraints);
        this.archiveEvtCode.setText("Archive Event");
        this.archiveEvtCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeDialog.this.archiveEvtCodeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.archiveEvtCode, gridBagConstraints);
        this.archiveEvtChecked.setText("Criteria managed by library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        jPanel3.add((Component)this.archiveEvtChecked, gridBagConstraints);
        this.dataReadyEvtCode.setText("Data Ready Event");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.dataReadyEvtCode, gridBagConstraints);
        jLabel33.setText(" ms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel3.add((Component)jLabel33, gridBagConstraints);
        jLabel34.setText(" ms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 21;
        jPanel3.add((Component)jLabel34, gridBagConstraints);
        jLabel35.setText(" %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 22;
        jPanel3.add((Component)jLabel35, gridBagConstraints);
        jLabel36.setText(" %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        jPanel3.add((Component)jLabel36, gridBagConstraints);
        jTabbedPane.addTab("Events", null, jPanel3, "Event parameters");
        jPanel3.getAccessibleContext().setAccessibleDescription("Event parameters");
        this.getContentPane().add((Component)jTabbedPane, "Center");
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        String string;
        int n;
        String string2 = null;
        String string3 = this.nameText.getText();
        try {
            n = this.overloadBtn.getSelectedObjects() != null ? 1 : 0;
            string3 = Utils.checkNameSyntax(string3, "name", false);
            if (this.pogo_gui.itemAlreadyExists(string3, 3)) {
                throw new PogoException("Attribute \"" + string3 + "\" Already Exists !");
            }
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
            return;
        }
        this.nameText.setText(string3);
        n = this.attrTypeCB.getSelectedIndex();
        block2 : switch (n) {
            case 0: {
                if (!this.rwTypeCB.getSelectedItem().equals("READ_WITH_WRITE") || (string = this.assAttrTF.getText()).length() != 0) break;
                string2 = "READ_WITH_WRITE  attribute must have an associated attribute";
                break;
            }
            case 1: {
                switch (this.checkIntField(this.xDataTF.getText())) {
                    case -1: {
                        string2 = "Spectrum Attribute needs an X length of data";
                        break;
                    }
                    case -2: {
                        string2 = "Spectrum Attribute needs a POSITIVE X length of data";
                        break;
                    }
                    case -3: {
                        string2 = "Cannot parse an integer value for X length !";
                    }
                }
                break;
            }
            case 2: {
                switch (this.checkIntField(this.xDataTF.getText())) {
                    case -1: {
                        string2 = "Image Attribute needs an X length of data";
                        break;
                    }
                    case -2: {
                        string2 = "Image Attribute needs a POSITIVE X length of data";
                        break;
                    }
                    case -3: {
                        string2 = "Cannot parse an integer value for X length !";
                    }
                }
                switch (this.checkIntField(this.yDataTF.getText())) {
                    case -1: {
                        string2 = "Image Attribute needs an Y length of data";
                        break block2;
                    }
                    case -2: {
                        string2 = "Image Attribute needs a POSITIVE Y length of data";
                        break block2;
                    }
                    case -3: {
                        string2 = "Cannot parse an integer value for Y length !";
                    }
                }
            }
        }
        if (this.polledBtn.getSelectedObjects() != null) {
            string = this.periodText.getText();
            try {
                this.poll_period = Integer.parseInt(string);
                if (this.poll_period < 20 && this.poll_period != 0) {
                    string2 = "The polling period minimum value is  20 ms";
                }
            }
            catch (NumberFormatException numberFormatException) {
                string2 = numberFormatException.toString() + "\n\nBad Value in Polling period field !";
            }
        }
        if (string2 != null) {
            JOptionPane.showMessageDialog(this, string2, "Error Window", 0);
        } else {
            this.doClose(0);
        }
    }

    private void rwTypeCBActionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.updateWindow();
        }
    }

    private void dataTypeCBActionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.updateWindow();
        }
    }

    private void attrTypeCBActionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.updateWindow();
        }
        if (this.rwTypeCB.getItemCount() == 0) {
            return;
        }
        String string = "Tango::" + AttrRWtypeArray[AttrRWtypeArray.length - 1];
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                if (this.rwTypeCB.getItemCount() >= AttrRWtypeArray.length) break;
                this.rwTypeCB.addItem(string);
                break;
            }
            default: {
                if (this.rwTypeCB.getItemCount() < AttrRWtypeArray.length) break;
                this.rwTypeCB.removeItem(string);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose(2);
    }

    private int checkIntField(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        try {
            if (string.length() == 0) {
                return -1;
            }
            int n2 = Integer.parseInt(string);
            if (n2 < 0) {
                return -2;
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return -3;
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(2);
    }

    private void abstractBtnActionPerformed(ActionEvent actionEvent) {
    }

    private void overloadBtnActionPerformed(ActionEvent actionEvent) {
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        int n = jTabbedPane.getSelectedIndex();
        if (n == 2) {
            boolean bl;
            String string = this.nameText.getText();
            this.evTitleLbl.setText("Attribute " + string);
            boolean bl2 = bl = this.attribute != null && this.attribute.getStatus() != null && Utils.isTrue(this.attribute.getStatus().getInherited());
            if (!bl) {
                String string2 = (String)this.dataTypeCB.getSelectedItem();
                boolean bl3 = !string2.contains("String") && !string2.contains("Boolean") && !string2.contains("State");
                this.evRelChangeTxt.setEnabled(bl3);
                this.evAbsChangeTxt.setEnabled(bl3);
                this.evArchRelChangeTxt.setEnabled(bl3);
                this.evArchAbsChangeTxt.setEnabled(bl3);
                if (!bl3) {
                    this.evRelChangeTxt.setText("");
                    this.evAbsChangeTxt.setText("");
                    this.evArchRelChangeTxt.setText("");
                    this.evArchAbsChangeTxt.setText("");
                }
            }
        }
    }

    private void changeEvtCodeActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = (String)this.dataTypeCB.getSelectedItem();
        boolean bl2 = bl = !string.contains("String") && !string.contains("Boolean") && !string.contains("State");
        if (bl) {
            this.changeEvtChecked.setVisible(this.changeEvtCode.getSelectedObjects() != null);
            this.pack();
        } else {
            this.changeEvtChecked.setSelected(false);
        }
    }

    private void archiveEvtCodeActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = (String)this.dataTypeCB.getSelectedItem();
        boolean bl2 = bl = !string.contains("String") && !string.contains("Boolean") && !string.contains("State");
        if (bl) {
            this.archiveEvtChecked.setVisible(this.archiveEvtCode.getSelectedObjects() != null);
            this.pack();
        } else {
            this.archiveEvtChecked.setSelected(false);
        }
    }

    public static String[] list2stringArray(EList<String> eList) {
        String[] stringArray = new String[eList.size()];
        for (int i = 0; i < eList.size(); ++i) {
            stringArray[i] = (String)eList.get(i);
        }
        return stringArray;
    }

    private void enumDefinitionBtnActionPerformed(ActionEvent actionEvent) {
        EnumDialog enumDialog;
        if (this.attribute != null && this.enumLabels == null) {
            this.enumLabels = AttributeDialog.list2stringArray(this.attribute.getEnumLabels());
        }
        if ((enumDialog = new EnumDialog(this, this.nameText.getText() + " enum attribute labels", this.enumLabels)).showDialog() == 0) {
            this.enumLabels = enumDialog.getEnumLabels();
            this.updateEnumLabelToolTip();
        }
    }

    private void doClose(int n) {
        this.retVal = n;
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    private void setDescriptionText(String string) {
        String string2 = Utils.strReplace(string, "\\n", "\n");
        string2 = Utils.strReplaceSpecialCharToDisplay(string2);
        this.attrPropDescription.setText(string2);
    }

    private void initializeWindow() {
        FireEvents fireEvents;
        FireEvents fireEvents2;
        FireEvents fireEvents3;
        EventCriteria eventCriteria;
        EventCriteria eventCriteria2;
        String string;
        String string2;
        if (this.attribute == null) {
            return;
        }
        this.nameText.setText(this.attribute.getName());
        this.xDataTF.setText(this.attribute.getMaxX());
        this.yDataTF.setText(this.attribute.getMaxY());
        this.assAttrTF.setText(this.attribute.getAssociatedAttr());
        this.attrTypeCB.setSelectedItem(this.attribute.getAttType());
        this.rwTypeCB.setSelectedItem(this.attribute.getRwType());
        this.allocateBtn.setVisible(this.rwTypeCB.getSelectedIndex() != 1);
        this.allocateBtn.setSelected(Utils.isTrue(this.attribute.getAllocReadMember()));
        String string3 = OAWutils.pogo2tangoType(this.attribute.getDataType().toString());
        if (string3.equals("State")) {
            string3 = "DevState";
        }
        for (int i = 0; i < this.dataTypeCB.getItemCount(); ++i) {
            string2 = this.dataTypeCB.getItemAt(i);
            if (!string2.equals(string3)) continue;
            this.dataTypeCB.setSelectedIndex(i);
        }
        AttrProperties attrProperties = this.attribute.getProperties();
        if (attrProperties != null) {
            string2 = Utils.strReplaceSpecialCharToCode(attrProperties.getDescription());
            this.setDescriptionText(string2);
            this.attrPropLabel.setText(attrProperties.getLabel());
            this.attrPropUnit.setText(attrProperties.getUnit());
            this.attrPropStdUnit.setText(attrProperties.getStandardUnit());
            this.attrPropDispUnit.setText(attrProperties.getDisplayUnit());
            this.attrPropFormat.setText(attrProperties.getFormat());
            this.attrPropMaxValue.setText(attrProperties.getMaxValue());
            this.attrPropMinValue.setText(attrProperties.getMinValue());
            this.attrPropMaxAlarm.setText(attrProperties.getMaxAlarm());
            this.attrPropMinAlarm.setText(attrProperties.getMinAlarm());
            this.attrPropMaxWarning.setText(attrProperties.getMaxWarning());
            this.attrPropMinWarning.setText(attrProperties.getMinWarning());
            this.attrPropDeltaTime.setText(attrProperties.getDeltaTime());
            this.attrPropDeltaValue.setText(attrProperties.getDeltaValue());
        }
        this.updateWindow();
        if (this.attribute.getDisplayLevel() != null && this.attribute.getDisplayLevel().equals(PogoConst.strLevel[1])) {
            this.levelBtn.setSelected(true);
        }
        this.setPeriodEnabled(false);
        string2 = this.attribute.getPolledPeriod();
        if (string2 != null && string2.length() > 0) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.polledBtn.setSelected(true);
                    this.poll_period = n;
                    this.setPeriodEnabled(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
            }
        }
        if ((this.attribute.getRwType().equals(AttrRWtypeArray[2]) || this.attribute.getRwType().equals(AttrRWtypeArray[1])) && (string = this.attribute.getMemorized()) != null && string.equals("true")) {
            this.memorizedBtn.setSelected(true);
            this.memorizedInitBtn.setVisible(true);
            string = this.attribute.getMemorizedAtInit();
            if (string != null && string.equals("true")) {
                this.memorizedInitBtn.setSelected(true);
            }
        }
        if ((eventCriteria2 = this.attribute.getEventCriteria()) != null) {
            if (eventCriteria2.getPeriod() != null) {
                this.evPeriodTxt.setText(eventCriteria2.getPeriod());
            }
            if (eventCriteria2.getRelChange() != null) {
                this.evRelChangeTxt.setText(eventCriteria2.getRelChange());
            }
            if (eventCriteria2.getAbsChange() != null) {
                this.evAbsChangeTxt.setText(eventCriteria2.getAbsChange());
            }
        }
        if ((eventCriteria = this.attribute.getEvArchiveCriteria()) != null) {
            if (eventCriteria.getPeriod() != null) {
                this.evArchPeriodTxt.setText(eventCriteria.getPeriod());
            }
            if (eventCriteria.getRelChange() != null) {
                this.evArchRelChangeTxt.setText(eventCriteria.getRelChange());
            }
            if (eventCriteria.getAbsChange() != null) {
                this.evArchAbsChangeTxt.setText(eventCriteria.getAbsChange());
            }
        }
        if ((fireEvents3 = this.attribute.getChangeEvent()) != null) {
            this.changeEvtCode.setSelected(Utils.isTrue(fireEvents3.getFire()));
            this.changeEvtChecked.setVisible(Utils.isTrue(fireEvents3.getFire()));
            this.changeEvtChecked.setSelected(Utils.isTrue(fireEvents3.getLibCheckCriteria()));
        }
        if ((fireEvents2 = this.attribute.getArchiveEvent()) != null) {
            this.archiveEvtCode.setSelected(Utils.isTrue(fireEvents2.getFire()));
            this.archiveEvtChecked.setVisible(Utils.isTrue(fireEvents2.getFire()));
            this.archiveEvtChecked.setSelected(Utils.isTrue(fireEvents2.getLibCheckCriteria()));
        }
        if ((fireEvents = this.attribute.getDataReadyEvent()) != null) {
            this.dataReadyEvtCode.setSelected(Utils.isTrue(fireEvents.getFire()));
        }
        if (this.isDynamic) {
            this.abstractBtn.setVisible(false);
            this.overloadBtn.setVisible(false);
        }
        this.dynamicLbl.setVisible(this.isDynamic);
    }

    public Attribute getAttribute() {
        Object object;
        Attribute attribute = OAWutils.factory.createAttribute();
        attribute.setName(this.nameText.getText().trim());
        String string = (String)this.attrTypeCB.getSelectedItem();
        attribute.setAttType(string);
        attribute.setRwType((String)this.rwTypeCB.getSelectedItem());
        if (this.rwTypeCB.getSelectedItem().equals("READ_WITH_WRITE")) {
            attribute.setAssociatedAttr(this.assAttrTF.getText().trim());
        }
        String string2 = (String)this.dataTypeCB.getSelectedItem();
        Type type = OAWutils.tango2pogoType(string2);
        attribute.setDataType(type);
        if (string2.toLowerCase().contains("enum") && this.enumLabels != null && this.enumLabels.length > 0) {
            object = attribute.getEnumLabels();
            Collections.addAll(object, this.enumLabels);
        }
        attribute.setMaxX(this.xDataTF.getText().trim());
        attribute.setMaxY(this.yDataTF.getText().trim());
        object = OAWutils.factory.createAttrProperties();
        object.setDescription(this.attrPropDescription.getText());
        object.setLabel(this.attrPropLabel.getText().trim());
        object.setUnit(this.attrPropUnit.getText().trim());
        object.setStandardUnit(this.attrPropStdUnit.getText().trim());
        object.setDisplayUnit(this.attrPropDispUnit.getText().trim());
        object.setFormat(this.attrPropFormat.getText().trim());
        object.setMaxValue(this.attrPropMaxValue.getText().trim());
        object.setMinValue(this.attrPropMinValue.getText().trim());
        object.setMaxAlarm(this.attrPropMaxAlarm.getText().trim());
        object.setMinAlarm(this.attrPropMinAlarm.getText().trim());
        object.setMaxWarning(this.attrPropMaxWarning.getText().trim());
        object.setMinWarning(this.attrPropMinWarning.getText().trim());
        object.setDeltaTime(this.attrPropDeltaTime.getText().trim());
        object.setDeltaValue(this.attrPropDeltaValue.getText().trim());
        attribute.setProperties((AttrProperties)object);
        if (this.polledBtn.getSelectedObjects() != null) {
            attribute.setPolledPeriod(this.periodText.getText().trim());
        } else {
            attribute.setPolledPeriod("0");
        }
        if (this.levelBtn.getSelectedObjects() != null) {
            attribute.setDisplayLevel(PogoConst.strLevel[1]);
        }
        if (string.toLowerCase().equals("scalar") && (attribute.getRwType().equals(AttrRWtypeArray[2]) || attribute.getRwType().equals(AttrRWtypeArray[1])) && this.memorizedBtn.getSelectedObjects() != null) {
            attribute.setMemorized("true");
            if (this.memorizedInitBtn.getSelectedObjects() != null) {
                attribute.setMemorizedAtInit("true");
            }
        }
        if (this.isDynamic) {
            attribute.setIsDynamic("true");
        } else {
            attribute.setIsDynamic("false");
            if (Utils.isTrue(this.orig_status.getInherited())) {
                if (this.overloadBtn.getSelectedObjects() != null) {
                    this.orig_status.setConcreteHere("true");
                } else {
                    this.orig_status.setConcreteHere("false");
                }
            } else if (this.abstractBtn.getSelectedObjects() != null) {
                this.orig_status.setAbstract("true");
                this.orig_status.setConcrete("false");
                this.orig_status.setConcreteHere("false");
            } else {
                this.orig_status.setAbstract("false");
                this.orig_status.setConcrete("true");
                this.orig_status.setConcreteHere("true");
            }
        }
        attribute.setStatus(this.orig_status);
        if (this.allocateBtn.getSelectedObjects() != null) {
            if (attribute.getRwType().equals(AttrRWtypeArray[1])) {
                attribute.setAllocReadMember("false");
            } else {
                attribute.setAllocReadMember("true");
            }
        } else {
            attribute.setAllocReadMember("false");
        }
        EventCriteria eventCriteria = OAWutils.factory.createEventCriteria();
        eventCriteria.setPeriod(this.evPeriodTxt.getText());
        eventCriteria.setRelChange(this.evRelChangeTxt.getText());
        eventCriteria.setAbsChange(this.evAbsChangeTxt.getText());
        attribute.setEventCriteria(eventCriteria);
        EventCriteria eventCriteria2 = OAWutils.factory.createEventCriteria();
        eventCriteria2.setPeriod(this.evArchPeriodTxt.getText());
        eventCriteria2.setRelChange(this.evArchRelChangeTxt.getText());
        eventCriteria2.setAbsChange(this.evArchAbsChangeTxt.getText());
        attribute.setEvArchiveCriteria(eventCriteria2);
        FireEvents fireEvents = OAWutils.factory.createFireEvents();
        fireEvents.setFire(Utils.strBoolean(this.changeEvtCode.getSelectedObjects() != null));
        fireEvents.setLibCheckCriteria(Utils.strBoolean(this.changeEvtChecked.getSelectedObjects() != null));
        attribute.setChangeEvent(fireEvents);
        FireEvents fireEvents2 = OAWutils.factory.createFireEvents();
        fireEvents2.setFire(Utils.strBoolean(this.archiveEvtCode.getSelectedObjects() != null));
        fireEvents2.setLibCheckCriteria(Utils.strBoolean(this.archiveEvtChecked.getSelectedObjects() != null));
        attribute.setArchiveEvent(fireEvents2);
        FireEvents fireEvents3 = OAWutils.factory.createFireEvents();
        fireEvents3.setFire(Utils.strBoolean(this.dataReadyEvtCode.getSelectedObjects() != null));
        fireEvents3.setLibCheckCriteria("true");
        attribute.setDataReadyEvent(fireEvents3);
        if (this.attribute != null) {
            EList<String> eList = this.attribute.getReadExcludedStates();
            EList<String> eList2 = attribute.getReadExcludedStates();
            for (String object22 : eList) {
                eList2.add(object22);
            }
            EList<String> eList3 = this.attribute.getWriteExcludedStates();
            EList<String> eList4 = attribute.getWriteExcludedStates();
            Iterator iterator = eList3.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                eList4.add(string3);
            }
        }
        return attribute;
    }

    private void updateEnumLabelToolTip() {
        if (this.enumLabels == null || this.enumLabels.length == 0) {
            this.enumDefinitionBtn.setToolTipText(Utils.buildToolTip("Labels not defined."));
        } else {
            this.enumDefinitionBtn.setToolTipText(EnumDialog.enum2toolTip(this.enumLabels));
        }
    }

    public static Attribute cloneAttribute(Attribute attribute) {
        Attribute attribute2 = OAWutils.cloneAttribute(attribute);
        InheritanceStatus inheritanceStatus = attribute2.getStatus();
        if (!Utils.isTrue(inheritanceStatus.getAbstract())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        if (Utils.isTrue(inheritanceStatus.getInherited())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        attribute2.setStatus(inheritanceStatus);
        return attribute2;
    }

    private void updateWindow() {
        this.xDataTF.setVisible(false);
        this.yDataTF.setVisible(false);
        this.xDataLBL.setVisible(false);
        this.yDataLBL.setVisible(false);
        this.assAttrTF.setVisible(false);
        this.assAttrLBL.setVisible(false);
        this.memorizedBtn.setVisible(false);
        this.memorizedInitBtn.setVisible(false);
        String string = this.dataTypeCB.getSelectedItem().toString();
        if (string.equals("DevEncoded")) {
            this.attrTypeCB.setSelectedIndex(0);
        } else if (string.equals("DevEnum")) {
            this.attrTypeCB.setSelectedIndex(0);
            if (this.attribute != null && this.enumLabels == null) {
                this.enumLabels = AttributeDialog.list2stringArray(this.attribute.getEnumLabels());
            }
            this.updateEnumLabelToolTip();
        }
        this.enumDefinitionBtn.setVisible(string.equals("DevEnum"));
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                switch (this.rwTypeCB.getSelectedIndex()) {
                    case 3: {
                        this.assAttrTF.setVisible(true);
                        this.assAttrLBL.setVisible(true);
                        this.assAttrTF.setText(this.attribute.getAssociatedAttr());
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.memorizedBtn == null) break;
                        this.memorizedBtn.setVisible(true);
                        this.memorizedInitBtn.setVisible(false);
                    }
                }
                break;
            }
            case 1: {
                this.xDataTF.setVisible(true);
                this.xDataLBL.setVisible(true);
                break;
            }
            case 2: {
                this.xDataTF.setVisible(true);
                this.yDataTF.setVisible(true);
                this.xDataLBL.setVisible(true);
                this.yDataLBL.setVisible(true);
            }
        }
        if (string.equals("Tango::DEV_ENCODED")) {
            this.memorizedBtn.setSelected(false);
            this.memorizedBtn.setVisible(false);
            this.memorizedInitBtn.setVisible(false);
        }
        this.allocateBtn.setVisible(this.rwTypeCB.getSelectedIndex() != 1);
        this.pack();
    }

    public static void popupSummary(JFrame jFrame, ArrayList<Attribute> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = AttributeDialog.buildSummary(arrayList);
        String string = Integer.toString(arrayList.size()) + "  Attributes";
        PopupTable popupTable = new PopupTable(jFrame, string, columnTitle, arrayList2);
        int n = arrayList.size();
        if (n > 35) {
            n = 35;
        }
        popupTable.setPreferredSize(columnSize, n);
        popupTable.setVisible(true);
    }

    private static ArrayList<ArrayList<String>> buildSummary(ArrayList<Attribute> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        for (Attribute attribute : arrayList) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(attribute.getName());
            arrayList3.add(attribute.getAttType());
            arrayList3.add(OAWutils.pogo2tangoType(attribute.getDataType().toString()));
            String string = attribute.getRwType();
            boolean bl = string != null && string.toLowerCase().contains("write");
            arrayList3.add(Boolean.toString(bl));
            arrayList3.add(Boolean.toString(Utils.isTrue(attribute.getMemorized())));
            if (attribute.getAttType().equals("Scalar")) {
                arrayList3.add("1");
            } else if (attribute.getAttType().equals("Spectrum")) {
                arrayList3.add(attribute.getMaxX());
            } else if (attribute.getAttType().equals("Image")) {
                arrayList3.add(attribute.getMaxX() + " x " + attribute.getMaxY());
            }
            String string2 = attribute.getDisplayLevel();
            if (string2 == null || string2.length() == 0) {
                string2 = "OPERATOR";
            }
            arrayList3.add(string2);
            InheritanceStatus inheritanceStatus = attribute.getStatus();
            arrayList3.add(Utils.strBoolean(inheritanceStatus.getInherited()));
            boolean bl2 = Utils.isTrue(inheritanceStatus.getConcrete()) || Utils.isTrue(inheritanceStatus.getConcreteHere());
            arrayList3.add("" + !bl2);
            AttrProperties attrProperties = attribute.getProperties();
            arrayList3.add(Utils.strReplace(attrProperties.getDescription(), "\\n", "\n"));
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }
}

