/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeParameter;
import org.eclipse.xtext.common.types.access.binary.asm.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinarySignature {
    protected final String chars;
    protected final int offset;
    protected final int length;
    private int hashCode;

    AbstractBinarySignature(String chars) {
        this(chars, 0, chars.length());
    }

    AbstractBinarySignature(String chars, int offset, int length) {
        this.chars = chars;
        this.offset = offset;
        this.length = length;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            return this.hashCode;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractBinarySignature other = (AbstractBinarySignature)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.chars.regionMatches(this.offset, other.chars, other.offset, this.length);
    }

    public List<BinaryTypeParameter> getTypeParameters() {
        return Collections.emptyList();
    }

    /*
     * Unable to fully structure code
     */
    protected List<BinaryTypeParameter> doGetTypeParameters() {
        try {
            length = this.length;
            if (length == 0) {
                return Collections.emptyList();
            }
            if (this.chars.charAt(this.offset) != '<') {
                return Collections.emptyList();
            }
            result = Lists.newArrayListWithCapacity(2);
            paramStart = this.offset + 1;
            i = this.offset + 1;
            while (i < length) {
                if (this.chars.charAt(i) == '>') {
                    return result;
                }
                if ((i = this.chars.indexOf(58, i)) >= 0 && i < length) ** GOTO lbl27
                throw new IllegalArgumentException();
lbl-1000:
                // 1 sources

                {
                    switch (this.chars.charAt(++i)) {
                        case ':': {
                            break;
                        }
                        case '>': {
                            break;
                        }
                        case 'L': 
                        case 'T': 
                        case '[': {
                            try {
                                i = SignatureUtil.scanTypeSignature(this.chars, i);
                                ++i;
                                break;
                            }
                            catch (IllegalArgumentException var5_6) {
                                // empty catch block
                            }
                        }
                    }
lbl27:
                    // 6 sources

                    ** while (this.chars.charAt((int)i) == ':')
                }
lbl28:
                // 1 sources

                result.add(new BinaryTypeParameter(this.chars, paramStart, i - paramStart));
                paramStart = i;
            }
        }
        catch (ArrayIndexOutOfBoundsException var1_2) {
            // empty catch block
        }
        throw new IllegalArgumentException();
    }

    private int computeHashCode() {
        int result = 1;
        int i = this.offset;
        int max = this.offset + this.length;
        while (i < max) {
            result = 31 * result + this.chars.charAt(i);
            ++i;
        }
        return result;
    }

    public String toString() {
        return String.format("%s: %s", this.getClass().getSimpleName(), this.chars.substring(this.offset, this.offset + this.length));
    }

    public int getLength() {
        return this.length;
    }

    public char getChar(int offset) {
        return this.chars.charAt(offset + this.offset);
    }
}

