/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary;

import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.impl.AbstractClassMirror;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryClassMirror
extends AbstractClassMirror {
    private final BinaryClass binaryClass;
    private final ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory;

    public static BinaryClassMirror createClassMirror(BinaryClass binaryClass, ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory) {
        if (binaryClass.isPrimitive() || binaryClass.isArray()) {
            throw new IllegalArgumentException("Cannot create class mirror for " + binaryClass.getName());
        }
        return new BinaryClassMirror(binaryClass, typeFactory);
    }

    protected BinaryClassMirror(BinaryClass binaryClass, ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory) {
        this.binaryClass = binaryClass;
        this.typeFactory = typeFactory;
    }

    @Override
    protected String getTypeName() {
        return this.binaryClass.getName();
    }

    @Override
    public void initialize(TypeResource typeResource) {
        typeResource.getContents().add(this.typeFactory.createType(this.binaryClass));
    }

    public BinaryClass getMirroredBinaryClass() {
        return this.binaryClass;
    }

    public Class<?> getMirroredClass() {
        try {
            return Class.forName(this.binaryClass.getName(), false, this.binaryClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isSealed() {
        return true;
    }
}

