/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class FileCopy
extends AbstractWorkflowComponent {
    private String sourceFile = null;
    private String targetFile = null;

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public void checkConfiguration(Issues issues) {
        if (this.sourceFile == null) {
            issues.addError("No sourceFile set.");
        }
        if (this.targetFile == null) {
            issues.addError("No targetFile set.");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        try {
            File source = new File(this.sourceFile);
            File target = new File(this.targetFile);
            if (!source.exists()) {
                issues.addWarning(this, "Source file " + this.sourceFile + " does not exist. Skipping.");
                return;
            }
            if (!target.exists()) {
                target.createNewFile();
            }
            FileChannel sourceChannel = null;
            AbstractInterruptibleChannel destinationChannel = null;
            try {
                sourceChannel = new FileInputStream(source).getChannel();
                destinationChannel = new FileOutputStream(target).getChannel();
                ((FileChannel)destinationChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
            finally {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (destinationChannel != null) {
                    destinationChannel.close();
                }
            }
        }
        catch (IOException x) {
            issues.addError(this, "Cannot perform I/O.", x);
        }
    }
}

