/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLIManager {
    public static final char ALTERNATE_POM_FILE = 'f';
    public static final char BATCH_MODE = 'B';
    public static final char SET_SYSTEM_PROPERTY = 'D';
    public static final char OFFLINE = 'o';
    public static final char QUIET = 'q';
    public static final char DEBUG = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char SHOW_VERSION = 'V';
    public static final char NON_RECURSIVE = 'N';
    public static final char UPDATE_SNAPSHOTS = 'U';
    public static final char ACTIVATE_PROFILES = 'P';
    public static final String SUPRESS_SNAPSHOT_UPDATES = "nsu";
    public static final char CHECKSUM_FAILURE_POLICY = 'C';
    public static final char CHECKSUM_WARNING_POLICY = 'c';
    public static final char ALTERNATE_USER_SETTINGS = 's';
    public static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
    public static final char ALTERNATE_USER_TOOLCHAINS = 't';
    public static final String FAIL_FAST = "ff";
    public static final String FAIL_AT_END = "fae";
    public static final String FAIL_NEVER = "fn";
    public static final String RESUME_FROM = "rf";
    public static final String PROJECT_LIST = "pl";
    public static final String ALSO_MAKE = "am";
    public static final String ALSO_MAKE_DEPENDENTS = "amd";
    public static final String LOG_FILE = "l";
    public static final String ENCRYPT_MASTER_PASSWORD = "emp";
    public static final String ENCRYPT_PASSWORD = "ep";
    public static final String THREADS = "T";
    public static final String LEGACY_LOCAL_REPOSITORY = "llr";
    public static final String BUILDER = "b";
    protected Options options = new Options();

    public CLIManager() {
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Display help information");
        this.options.addOption(OptionBuilder.create('h'));
        OptionBuilder.withLongOpt("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Force the use of an alternate POM file (or directory with pom.xml).");
        this.options.addOption(OptionBuilder.create('f'));
        OptionBuilder.withLongOpt("define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Define a system property");
        this.options.addOption(OptionBuilder.create('D'));
        OptionBuilder.withLongOpt("offline");
        OptionBuilder.withDescription("Work offline");
        this.options.addOption(OptionBuilder.create('o'));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Display version information");
        this.options.addOption(OptionBuilder.create('v'));
        OptionBuilder.withLongOpt("quiet");
        OptionBuilder.withDescription("Quiet output - only show errors");
        this.options.addOption(OptionBuilder.create('q'));
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("Produce execution debug output");
        this.options.addOption(OptionBuilder.create('X'));
        OptionBuilder.withLongOpt("errors");
        OptionBuilder.withDescription("Produce execution error messages");
        this.options.addOption(OptionBuilder.create('e'));
        OptionBuilder.withLongOpt("non-recursive");
        OptionBuilder.withDescription("Do not recurse into sub-projects");
        this.options.addOption(OptionBuilder.create('N'));
        OptionBuilder.withLongOpt("update-snapshots");
        OptionBuilder.withDescription("Forces a check for missing releases and updated snapshots on remote repositories");
        this.options.addOption(OptionBuilder.create('U'));
        OptionBuilder.withLongOpt("activate-profiles");
        OptionBuilder.withDescription("Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create('P'));
        OptionBuilder.withLongOpt("batch-mode");
        OptionBuilder.withDescription("Run in non-interactive (batch) mode");
        this.options.addOption(OptionBuilder.create('B'));
        OptionBuilder.withLongOpt("no-snapshot-updates");
        OptionBuilder.withDescription("Suppress SNAPSHOT updates");
        this.options.addOption(OptionBuilder.create(SUPRESS_SNAPSHOT_UPDATES));
        OptionBuilder.withLongOpt("strict-checksums");
        OptionBuilder.withDescription("Fail the build if checksums don't match");
        this.options.addOption(OptionBuilder.create('C'));
        OptionBuilder.withLongOpt("lax-checksums");
        OptionBuilder.withDescription("Warn if checksums don't match");
        this.options.addOption(OptionBuilder.create('c'));
        OptionBuilder.withLongOpt("settings");
        OptionBuilder.withDescription("Alternate path for the user settings file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create('s'));
        OptionBuilder.withLongOpt("global-settings");
        OptionBuilder.withDescription("Alternate path for the global settings file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create(ALTERNATE_GLOBAL_SETTINGS));
        OptionBuilder.withLongOpt("toolchains");
        OptionBuilder.withDescription("Alternate path for the user toolchains file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create('t'));
        OptionBuilder.withLongOpt("fail-fast");
        OptionBuilder.withDescription("Stop at first failure in reactorized builds");
        this.options.addOption(OptionBuilder.create(FAIL_FAST));
        OptionBuilder.withLongOpt("fail-at-end");
        OptionBuilder.withDescription("Only fail the build afterwards; allow all non-impacted builds to continue");
        this.options.addOption(OptionBuilder.create(FAIL_AT_END));
        OptionBuilder.withLongOpt("fail-never");
        OptionBuilder.withDescription("NEVER fail the build, regardless of project result");
        this.options.addOption(OptionBuilder.create(FAIL_NEVER));
        OptionBuilder.withLongOpt("resume-from");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Resume reactor from specified project");
        this.options.addOption(OptionBuilder.create(RESUME_FROM));
        OptionBuilder.withLongOpt("projects");
        OptionBuilder.withDescription("Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create(PROJECT_LIST));
        OptionBuilder.withLongOpt("also-make");
        OptionBuilder.withDescription("If project list is specified, also build projects required by the list");
        this.options.addOption(OptionBuilder.create(ALSO_MAKE));
        OptionBuilder.withLongOpt("also-make-dependents");
        OptionBuilder.withDescription("If project list is specified, also build projects that depend on projects on the list");
        this.options.addOption(OptionBuilder.create(ALSO_MAKE_DEPENDENTS));
        OptionBuilder.withLongOpt("log-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Log file to where all build output will go.");
        this.options.addOption(OptionBuilder.create(LOG_FILE));
        OptionBuilder.withLongOpt("show-version");
        OptionBuilder.withDescription("Display version information WITHOUT stopping build");
        this.options.addOption(OptionBuilder.create('V'));
        OptionBuilder.withLongOpt("encrypt-master-password");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Encrypt master security password");
        this.options.addOption(OptionBuilder.create(ENCRYPT_MASTER_PASSWORD));
        OptionBuilder.withLongOpt("encrypt-password");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Encrypt server password");
        this.options.addOption(OptionBuilder.create(ENCRYPT_PASSWORD));
        OptionBuilder.withLongOpt("threads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Thread count, for instance 2.0C where C is core multiplied");
        this.options.addOption(OptionBuilder.create(THREADS));
        OptionBuilder.withLongOpt("legacy-local-repository");
        OptionBuilder.withDescription("Use Maven 2 Legacy Local Repository behaviour, ie no use of _remote.repositories. Can also be activated by using -Dmaven.legacyLocalRepo=true");
        this.options.addOption(OptionBuilder.create(LEGACY_LOCAL_REPOSITORY));
        OptionBuilder.withLongOpt("builder");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The id of the build strategy to use.");
        this.options.addOption(OptionBuilder.create(BUILDER));
        OptionBuilder.withLongOpt("no-plugin-registry");
        OptionBuilder.withDescription("Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create("npr"));
        OptionBuilder.withLongOpt("check-plugin-updates");
        OptionBuilder.withDescription("Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create("cpu"));
        OptionBuilder.withLongOpt("update-plugins");
        OptionBuilder.withDescription("Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create("up"));
        OptionBuilder.withLongOpt("no-plugin-updates");
        OptionBuilder.withDescription("Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create("npu"));
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = this.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.options, cleanArgs);
    }

    private String[] cleanArgs(String[] args) {
        int cleanedSz;
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuilder currentArg = null;
        for (String arg : args) {
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuilder(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
                continue;
            }
            if (addedToBuffer) continue;
            if (currentArg != null) {
                currentArg.append(' ').append(arg);
                continue;
            }
            cleaned.add(arg);
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        String[] cleanArgs = (cleanedSz = cleaned.size()) == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    public void displayHelp(PrintStream stdout) {
        stdout.println();
        PrintWriter pw = new PrintWriter(stdout);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 74, "mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, 1, 3, "\n", false);
        pw.flush();
    }
}

