/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.core;

import net.danieldietrich.protectedregions.core.IRegionOracle;
import net.danieldietrich.protectedregions.core.IRegionParser;
import net.danieldietrich.protectedregions.core.RegionParserBuilder;

public class RegionParserFactory {
    private RegionParserFactory() {
    }

    public static IRegionParser createClojureParser() {
        return RegionParserFactory.createClojureParser(null, false);
    }

    public static IRegionParser createClojureParser(boolean inverse) {
        return RegionParserFactory.createClojureParser(null, inverse);
    }

    public static IRegionParser createClojureParser(IRegionOracle oracle, boolean inverse) {
        return new RegionParserBuilder().name("clojure").addComment(";").ignoreCData('\"', '\\').setInverse(inverse).useOracle(oracle).build();
    }

    public static IRegionParser createCssParser() {
        return RegionParserFactory.createCssParser(null, false);
    }

    public static IRegionParser createCssParser(boolean inverse) {
        return RegionParserFactory.createCssParser(null, inverse);
    }

    public static IRegionParser createCssParser(IRegionOracle oracle, boolean inverse) {
        return new RegionParserBuilder().name("css").addComment("/*", "*/").ignoreCData('\"', '\\').setInverse(inverse).useOracle(oracle).build();
    }

    public static IRegionParser createHtmlParser() {
        return RegionParserFactory.createHtmlParser(null, false);
    }

    public static IRegionParser createHtmlParser(boolean inverse) {
        return RegionParserFactory.createHtmlParser(null, inverse);
    }

    public static IRegionParser createHtmlParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("html").addComment("<!--", "-->").ignoreCData("<![CDATA[", "]]>").ignoreCData('\"').ignoreCData('\'').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createJavaParser() {
        return RegionParserFactory.createJavaParser(null, false);
    }

    public static IRegionParser createJavaParser(boolean inverse) {
        return RegionParserFactory.createJavaParser(null, inverse);
    }

    public static IRegionParser createJavaParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("java").addComment("/*", "*/").addComment("//").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createJavaScriptParser() {
        return RegionParserFactory.createJavaScriptParser(null, false);
    }

    public static IRegionParser createJavaScriptParser(boolean inverse) {
        return RegionParserFactory.createJavaScriptParser(null, inverse);
    }

    public static IRegionParser createJavaScriptParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("js").addComment("/*", "*/").addComment("//").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createPhpParser() {
        return RegionParserFactory.createPhpParser(null, false);
    }

    public static IRegionParser createPhpParser(boolean inverse) {
        return RegionParserFactory.createPhpParser(null, inverse);
    }

    public static IRegionParser createPhpParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("php").addComment("/*", "*/").addComment("//").addComment("#").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createRubyParser() {
        return RegionParserFactory.createClojureParser(null, false);
    }

    public static IRegionParser createRubyParser(boolean inverse) {
        return RegionParserFactory.createRubyParser(null, inverse);
    }

    public static IRegionParser createRubyParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("ruby").addComment("#").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createScalaParser() {
        return RegionParserFactory.createScalaParser(null, false);
    }

    public static IRegionParser createScalaParser(boolean inverse) {
        return RegionParserFactory.createScalaParser(null, inverse);
    }

    public static IRegionParser createScalaParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("scala").addNestableComment("/*", "*/").addComment("//").ignoreCData("\"\"\"", "\"\"\"").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createXmlParser() {
        return RegionParserFactory.createXmlParser(null, false);
    }

    public static IRegionParser createXmlParser(boolean inverse) {
        return RegionParserFactory.createXmlParser(null, inverse);
    }

    public static IRegionParser createXmlParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("xml").addComment("<!--", "-->").ignoreCData("<![CDATA[", "]]>").ignoreCData('\"').ignoreCData('\'').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createXtend2Parser() {
        return RegionParserFactory.createJavaParser(null, false);
    }

    public static IRegionParser createXtend2Parser(boolean inverse) {
        return RegionParserFactory.createXtend2Parser(null, inverse);
    }

    public static IRegionParser createXtend2Parser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("xtend2").addComment("/*", "*/").addComment("//").ignoreCData("'''", "'''").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(mergeStyle).useOracle(oracle).build();
    }

    public static IRegionParser createXtextParser() {
        return RegionParserFactory.createJavaParser(null, false);
    }

    public static IRegionParser createXtextParser(boolean inverse) {
        return RegionParserFactory.createXtextParser(null, inverse);
    }

    public static IRegionParser createXtextParser(IRegionOracle oracle, boolean mergeStyle) {
        return new RegionParserBuilder().name("xtext").addComment("/*", "*/").addComment("//").ignoreCData('\"', '\\').ignoreCData('\'', '\\').setInverse(mergeStyle).useOracle(oracle).build();
    }
}

