/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.utils;

import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import org.eclipse.emf.common.util.EList;

public class InheritanceUtils {
    public boolean isConcreteClass(PogoDeviceClass cls) {
        return CppStringUtils.isFalse(cls.getDescription().getHasAbstractAttribute()) && CppStringUtils.isFalse(cls.getDescription().getHasAbstractCommand());
    }

    public String inheritedClassName(PogoDeviceClass cls) {
        EList<Inheritance> inheritances = cls.getDescription().getInheritances();
        if (inheritances == null || inheritances.size() == 0) {
            return CppStringUtils.DeviceImpl();
        }
        int last = inheritances.size() - 1;
        String className = ((Inheritance)inheritances.get(last)).getClassname();
        if (this.isDefaultDeviceImpl(className)) {
            return CppStringUtils.DeviceImpl();
        }
        return className;
    }

    public String inheritedClassNameForDevice(PogoDeviceClass cls) {
        EList<Inheritance> inheritances = cls.getDescription().getInheritances();
        if (inheritances == null || inheritances.size() == 0) {
            return CppStringUtils.DeviceImpl();
        }
        int last = inheritances.size() - 1;
        String className = ((Inheritance)inheritances.get(last)).getClassname();
        if (this.isDefaultDeviceImpl(className)) {
            return CppStringUtils.DeviceImpl();
        }
        return String.valueOf(className) + "_ns::" + className;
    }

    public String inheritedClassNameForDeviceClass(PogoDeviceClass cls) {
        EList<Inheritance> inheritances = cls.getDescription().getInheritances();
        if (inheritances == null || inheritances.size() == 0) {
            return "Tango::DeviceClass";
        }
        int last = inheritances.size() - 1;
        String className = ((Inheritance)inheritances.get(last)).getClassname();
        if (this.isDefaultDeviceImpl(className)) {
            return "Tango::DeviceClass";
        }
        return String.valueOf(className) + "_ns::" + className + "Class";
    }

    private boolean isDefaultDeviceImpl(String className) {
        return className.startsWith("Device_") && className.endsWith("Impl");
    }

    public boolean isDefaultDeviceImpl(Inheritance inheritance) {
        return this.isDefaultDeviceImpl(inheritance.getClassname());
    }

    public boolean isInheritanceClass(Inheritance inheritance) {
        if (CppStringUtils.isSet(inheritance.getClassname())) {
            return !this.isDefaultDeviceImpl(inheritance.getClassname());
        }
        return false;
    }

    public boolean hasInheritanceClass(PogoDeviceClass cls) {
        int inherSize = cls.getDescription().getInheritances().size();
        return inherSize > 0 && this.isInheritanceClass((Inheritance)cls.getDescription().getInheritances().get(inherSize - 1));
    }

    public boolean hasInheritanceClass(OneClassSimpleDef cls) {
        int inherSize = cls.getInheritances().size();
        return inherSize > 0 && this.isInheritanceClass((Inheritance)cls.getInheritances().get(inherSize - 1));
    }

    public boolean isInherited(Property property) {
        return property.getStatus() != null && property.getStatus().getInherited() != null && property.getStatus().getInherited().equals("true");
    }

    public boolean isInherited(Attribute attribute) {
        return attribute.getStatus() != null && attribute.getStatus().getInherited() != null && attribute.getStatus().getInherited().equals("true");
    }

    public boolean isInherited(Command command) {
        return command.getStatus() != null && command.getStatus().getInherited() != null && command.getStatus().getInherited().equals("true");
    }

    public boolean isConcreteHere(Property property) {
        return property.getStatus() != null && property.getStatus().getConcreteHere() != null && property.getStatus().getConcreteHere().equals("true");
    }

    public boolean isConcreteHere(Attribute attribute) {
        return attribute.getStatus() != null && attribute.getStatus().getConcreteHere() != null && attribute.getStatus().getConcreteHere().equals("true");
    }

    public boolean isConcreteHere(Command command) {
        return command.getStatus() != null && command.getStatus().getConcreteHere() != null && command.getStatus().getConcreteHere().equals("true");
    }

    public boolean isAbstract(Attribute attribute) {
        return CppStringUtils.isTrue(attribute.getStatus().getAbstract()) && !CppStringUtils.isTrue(attribute.getStatus().getInherited()) && !CppStringUtils.isTrue(attribute.getStatus().getConcreteHere());
    }

    public boolean alreadyOverloaded(Attribute attribute) {
        return CppStringUtils.isTrue(attribute.getStatus().getConcrete()) && !CppStringUtils.isTrue(attribute.getStatus().getConcreteHere());
    }

    public boolean isAbstract(Command command) {
        return CppStringUtils.isTrue(command.getStatus().getAbstract()) && !CppStringUtils.isTrue(command.getStatus().getInherited()) && !CppStringUtils.isTrue(command.getStatus().getConcreteHere());
    }

    public boolean overrides(Command command) {
        return CppStringUtils.isTrue(command.getStatus().getConcrete()) && !CppStringUtils.isTrue(command.getStatus().getConcreteHere());
    }

    public String checkAbstractForProto(Attribute attribute) {
        if (this.isAbstract(attribute)) {
            return " = 0";
        }
        return "";
    }

    public String checkAbstractForProto(Command command) {
        if (this.isAbstract(command)) {
            return " = 0";
        }
        return "";
    }

    public String inheritanceIncludeList(PogoDeviceClass cls, boolean devClass) {
        StringBuffer sb = new StringBuffer();
        for (Inheritance inheritance : cls.getDescription().getInheritances()) {
            if (this.isDefaultDeviceImpl(inheritance)) continue;
            sb.append("#include <").append(inheritance.getClassname());
            if (devClass) {
                sb.append("Class.h>\n");
                continue;
            }
            sb.append(".h>\n");
        }
        return sb.toString();
    }

    public String inheritanceNameForMakefile(Inheritance inheritance) {
        return inheritance.getClassname().toUpperCase();
    }

    public String addInheritanceObjectFiles(PogoDeviceClass cls) {
        StringBuffer sb = new StringBuffer();
        sb.append("SVC_INHERITANCE_OBJ =  \\\n");
        for (Inheritance inheritance : cls.getDescription().getInheritances()) {
            if (this.isDefaultDeviceImpl(inheritance)) continue;
            sb.append("        ").append("$(SVC_").append(inheritance.getClassname().toUpperCase()).append("_OBJ) \\\n");
        }
        sb.append("\n");
        for (Inheritance inheritance : cls.getDescription().getInheritances()) {
            if (this.isDefaultDeviceImpl(inheritance)) continue;
            sb.append("#------------  Object files for GenericPS class  ------------\n");
            sb.append("SVC_").append(inheritance.getClassname().toUpperCase()).append("_OBJ = \\\n");
            sb.append("        $(OBJDIR)/").append(inheritance.getClassname()).append(".o \\\n");
            sb.append("        $(OBJDIR)/").append(inheritance.getClassname()).append("Class.o \\\n");
            sb.append("        $(OBJDIR)/").append(inheritance.getClassname()).append("StateMachine.o \\\n\n");
        }
        return sb.toString();
    }
}

