/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.utils;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppTypeDefinitions;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tango.pogo.pogoDsl.Type;
import org.eclipse.xtext.xbase.lib.Extension;

public class Headers
extends fr.esrf.tango.pogo.generator.common.Headers {
    @Inject
    @Extension
    private CppStringUtils _cppStringUtils;

    public String deviceIncludeFileName(PogoDeviceClass cls) {
        String _name = cls.getName();
        return String.valueOf(_name) + ".h";
    }

    public String deviceIncludeFileHeader(PogoDeviceClass cls) {
        String _deviceIncludeFileName = this.deviceIncludeFileName(cls);
        String _name = cls.getName();
        String _plus = "Include file for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " class";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader(_deviceIncludeFileName, _plus_1, _title, _license, _copyright);
    }

    public String deviceClassIncludeFileName(PogoDeviceClass cls) {
        String _name = cls.getName();
        return String.valueOf(_name) + "Class.h";
    }

    public String deviceClassIncludeFileHeader(PogoDeviceClass cls) {
        String _deviceClassIncludeFileName = this.deviceClassIncludeFileName(cls);
        String _name = cls.getName();
        String _plus = "Include for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " root class.\n";
        String _plus_2 = String.valueOf(_plus_1) + "This class is the singleton class for\n";
        String _plus_3 = String.valueOf(_plus_2) + " the ";
        String _name_1 = cls.getName();
        String _plus_4 = String.valueOf(_plus_3) + _name_1;
        String _plus_5 = String.valueOf(_plus_4) + " device class.\n";
        String _plus_6 = String.valueOf(_plus_5) + "It contains all properties and methods which the \n";
        String _name_2 = cls.getName();
        String _plus_7 = String.valueOf(_plus_6) + _name_2;
        String _plus_8 = String.valueOf(_plus_7) + " requires only once e.g. the commands.";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader(_deviceClassIncludeFileName, _plus_8, _title, _license, _copyright);
    }

    public String deviceSourceFileName(PogoDeviceClass cls) {
        String _name = cls.getName();
        return String.valueOf(_name) + ".cpp";
    }

    public String deviceSourceFileHeader(PogoDeviceClass cls) {
        String _deviceSourceFileName = this.deviceSourceFileName(cls);
        String _name = cls.getName();
        String _plus = "C++ source for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " class and its commands.\n";
        String _plus_2 = String.valueOf(_plus_1) + "The class is derived from Device. It represents the\n";
        String _plus_3 = String.valueOf(_plus_2) + "CORBA servant object which will be accessed from the\n";
        String _plus_4 = String.valueOf(_plus_3) + "network. All commands which can be executed on the\n";
        String _name_1 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_1;
        String _plus_6 = String.valueOf(_plus_5) + " are implemented in this file.";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader(_deviceSourceFileName, _plus_6, _title, _license, _copyright);
    }

    public String deviceClassSourceFileName(PogoDeviceClass cls) {
        String _name = cls.getName();
        return String.valueOf(_name) + "Class.cpp";
    }

    public String deviceClassSourceFileHeader(PogoDeviceClass cls) {
        String _deviceClassSourceFileName = this.deviceClassSourceFileName(cls);
        String _name = cls.getName();
        String _plus = "C++ source for the " + _name;
        String _plus_1 = String.valueOf(_plus) + "Class.\n";
        String _plus_2 = String.valueOf(_plus_1) + "A singleton class derived from DeviceClass.\n";
        String _plus_3 = String.valueOf(_plus_2) + "It implements the command and attribute list\n";
        String _plus_4 = String.valueOf(_plus_3) + "and all properties and methods required\n";
        String _plus_5 = String.valueOf(_plus_4) + "by the ";
        String _name_1 = cls.getName();
        String _plus_6 = String.valueOf(_plus_5) + _name_1;
        String _plus_7 = String.valueOf(_plus_6) + " once per process.";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader(_deviceClassSourceFileName, _plus_7, _title, _license, _copyright);
    }

    public String stateMachineFileName(PogoDeviceClass cls) {
        String _name = cls.getName();
        return String.valueOf(_name) + "StateMachine.cpp";
    }

    public String stateMachineFileHeader(PogoDeviceClass cls) {
        String _stateMachineFileName = this.stateMachineFileName(cls);
        String _name = cls.getName();
        String _plus = "State machine file for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " class";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader(_stateMachineFileName, _plus_1, _title, _license, _copyright);
    }

    public String dynamicAttrUtilsFileName(PogoDeviceClass cls) {
        String _name = cls.getName();
        return String.valueOf(_name) + "DynAttrUtils.cpp";
    }

    public String dynamicAttrUtilsFileHeader(PogoDeviceClass cls) {
        String _dynamicAttrUtilsFileName = this.dynamicAttrUtilsFileName(cls);
        String _name = cls.getName();
        String _plus = "Dynamic attributes utilities file for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " class";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader(_dynamicAttrUtilsFileName, _plus_1, _title, _license, _copyright);
    }

    public String ClassFactoryFileHeader(PogoDeviceClass cls) {
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader("ClassFactory.cpp", "C++ source for the class_factory method of the DServer\ndevice class. This method is responsible for the creation of\nall class singleton for a device server. It is called\nat device server startup.", _title, _license, _copyright);
    }

    public String ClassFactoryFileHeader(PogoMultiClasses multi) {
        String _license = multi.getLicense();
        String _copyright = multi.getCopyright();
        return this.fileHeader("MultiClassessFactory.cpp", "C++ source for the class_factory method of the DServer\ndevice class. This method is responsible for the creation of\nall class singleton for a device server. It is called\nat device server startup.", "", _license, _copyright);
    }

    public String mainFileHeader(PogoDeviceClass cls) {
        String _name = cls.getName();
        String _plus = "C++ source for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " device server main.\n";
        String _plus_2 = String.valueOf(_plus_1) + "The main rule is to initialise (and create) the Tango\n";
        String _plus_3 = String.valueOf(_plus_2) + "system and to create the DServerClass singleton.\n";
        String _plus_4 = String.valueOf(_plus_3) + "The main should be the same for every Tango device server.";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        return this.fileHeader("main.cpp", _plus_4, _title, _license, _copyright);
    }

    public String mainFileHeader(PogoMultiClasses multi) {
        String _name = multi.getName();
        String _plus = "C++ source for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " device server main.\n";
        String _plus_2 = String.valueOf(_plus_1) + "The main rule is to initialise (and create) the Tango\n";
        String _plus_3 = String.valueOf(_plus_2) + "system and to create the DServerClass singleton.\n";
        String _plus_4 = String.valueOf(_plus_3) + "The main should be the same for every Tango device server.";
        String _title = multi.getTitle();
        String _license = multi.getLicense();
        String _copyright = multi.getCopyright();
        return this.fileHeader("main.cpp", _plus_4, _title, _license, _copyright);
    }

    public String simpleMethodHeader(PogoDeviceClass cls, String method, String description) {
        String _name = cls.getName();
        String _plus = "//--------------------------------------------------------\n/**\n *\tMethod      : " + _name;
        String _plus_1 = String.valueOf(_plus) + "::";
        String _plus_2 = String.valueOf(_plus_1) + method;
        String _plus_3 = String.valueOf(_plus_2) + "()\n";
        String _plus_4 = String.valueOf(_plus_3) + " *\tDescription : ";
        String _comments = StringUtils.comments(description, " *                ");
        String _plus_5 = String.valueOf(_plus_4) + _comments;
        String _plus_6 = String.valueOf(_plus_5) + "\n";
        String _plus_7 = String.valueOf(_plus_6) + " */\n";
        return String.valueOf(_plus_7) + "//--------------------------------------------------------";
    }

    public String simpleMethodHeader1(PogoDeviceClass cls, String method, String description) {
        String _name = cls.getName();
        String _plus = "//--------------------------------------------------------\n/*\n *\tMethod      : " + _name;
        String _plus_1 = String.valueOf(_plus) + "::";
        String _plus_2 = String.valueOf(_plus_1) + method;
        String _plus_3 = String.valueOf(_plus_2) + "()\n";
        String _plus_4 = String.valueOf(_plus_3) + " *\tDescription : ";
        String _comments = StringUtils.comments(description, " *                ");
        String _plus_5 = String.valueOf(_plus_4) + _comments;
        String _plus_6 = String.valueOf(_plus_5) + "\n";
        String _plus_7 = String.valueOf(_plus_6) + " */\n";
        return String.valueOf(_plus_7) + "//--------------------------------------------------------";
    }

    public String simpleMethodHeaderClass(PogoDeviceClass cls, String method, String description) {
        String _name = cls.getName();
        String _plus = "//--------------------------------------------------------\n/**\n *\tMethod      : " + _name;
        String _plus_1 = String.valueOf(_plus) + "Class::";
        String _plus_2 = String.valueOf(_plus_1) + method;
        String _plus_3 = String.valueOf(_plus_2) + "()\n";
        String _plus_4 = String.valueOf(_plus_3) + " *\tDescription : ";
        String _comments = StringUtils.comments(description, " *                ");
        String _plus_5 = String.valueOf(_plus_4) + _comments;
        String _plus_6 = String.valueOf(_plus_5) + "\n";
        String _plus_7 = String.valueOf(_plus_6) + " */\n";
        return String.valueOf(_plus_7) + "//--------------------------------------------------------";
    }

    public String attributeMethodHeader(Attribute attr, String rw) {
        String _name = attr.getName();
        String _plus = "//--------------------------------------------------------\n/**\n *\t" + rw + " attribute " + _name;
        String _plus_1 = String.valueOf(_plus) + " related method\n";
        String _plus_2 = String.valueOf(_plus_1) + " *\tDescription: ";
        AttrProperties _properties = attr.getProperties();
        String _description = _properties.getDescription();
        String _comments = StringUtils.comments(_description, " *               ");
        String _plus_3 = String.valueOf(_plus_2) + _comments;
        String _plus_4 = String.valueOf(_plus_3) + "\n";
        String _plus_5 = String.valueOf(_plus_4) + " *\n";
        String _plus_6 = String.valueOf(_plus_5) + " *\tData type:\t";
        Type _dataType = attr.getDataType();
        String _cppType = CppTypeDefinitions.cppType(_dataType);
        String _plus_7 = String.valueOf(_plus_6) + _cppType;
        String _manageEnumForMethodHeader = this._cppStringUtils.manageEnumForMethodHeader(attr);
        String _plus_8 = String.valueOf(_plus_7) + _manageEnumForMethodHeader;
        String _plus_9 = String.valueOf(_plus_8) + "\n";
        String _plus_10 = String.valueOf(_plus_9) + " *\tAttr type:\t";
        String _attType = attr.getAttType();
        String _plus_11 = String.valueOf(_plus_10) + _attType;
        String _attTypeDimentions = this._cppStringUtils.attTypeDimentions(attr);
        String _plus_12 = String.valueOf(_plus_11) + _attTypeDimentions;
        String _plus_13 = String.valueOf(_plus_12) + "\n";
        String _plus_14 = String.valueOf(_plus_13) + " */\n";
        return String.valueOf(_plus_14) + "//--------------------------------------------------------\n";
    }

    public String pipeMethodHeader(Pipe pipe, String rw) {
        String _name = pipe.getName();
        String _plus = "//--------------------------------------------------------\n/**\n *\t" + rw + " pipe " + _name;
        String _plus_1 = String.valueOf(_plus) + " related method\n";
        String _plus_2 = String.valueOf(_plus_1) + " *\tDescription: ";
        String _description = pipe.getDescription();
        String _comments = StringUtils.comments(_description, " *               ");
        String _plus_3 = String.valueOf(_plus_2) + _comments;
        String _plus_4 = String.valueOf(_plus_3) + "\n";
        String _plus_5 = String.valueOf(_plus_4) + " */\n";
        return String.valueOf(_plus_5) + "//--------------------------------------------------------\n";
    }

    public String attributePrototypeMethodHeader(Attribute attr) {
        String _name = attr.getName();
        String _plus = "/**\n *\tAttribute " + _name;
        String _plus_1 = String.valueOf(_plus) + " related methods\n";
        String _plus_2 = String.valueOf(_plus_1) + " *\tDescription: ";
        AttrProperties _properties = attr.getProperties();
        String _description = _properties.getDescription();
        String _comments = StringUtils.comments(_description, " *               ");
        String _plus_3 = String.valueOf(_plus_2) + _comments;
        String _plus_4 = String.valueOf(_plus_3) + "\n";
        String _plus_5 = String.valueOf(_plus_4) + " *\n";
        String _plus_6 = String.valueOf(_plus_5) + " *\tData type:\t";
        Type _dataType = attr.getDataType();
        String _cppType = CppTypeDefinitions.cppType(_dataType);
        String _plus_7 = String.valueOf(_plus_6) + _cppType;
        String _plus_8 = String.valueOf(_plus_7) + "\n";
        String _plus_9 = String.valueOf(_plus_8) + " *\tAttr type:\t";
        String _attType = attr.getAttType();
        String _plus_10 = String.valueOf(_plus_9) + _attType;
        String _attTypeDimentions = this._cppStringUtils.attTypeDimentions(attr);
        String _plus_11 = String.valueOf(_plus_10) + _attTypeDimentions;
        String _plus_12 = String.valueOf(_plus_11) + "\n";
        return String.valueOf(_plus_12) + " */\n";
    }

    public String commandExecutionMethodHeader(Command cmd) {
        String _name = cmd.getName();
        String _plus = "/**\n *\tCommand " + _name;
        String _plus_1 = String.valueOf(_plus) + " related method\n";
        String _plus_2 = String.valueOf(_plus_1) + " *\tDescription: ";
        String _description = cmd.getDescription();
        String _comments = StringUtils.comments(_description, " *               ");
        String _plus_3 = String.valueOf(_plus_2) + _comments;
        String _plus_4 = String.valueOf(_plus_3) + "\n";
        String _plus_5 = String.valueOf(_plus_4) + " *\n";
        String _commandParameterHeader = CppStringUtils.commandParameterHeader(cmd);
        String _plus_6 = String.valueOf(_plus_5) + _commandParameterHeader;
        return String.valueOf(_plus_6) + " */\n";
    }
}

