/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;

public class Utils {
    private static Utils instance = null;
    private static ImageIcon tango_icon = null;
    public ImageIcon logoIcon;
    public ImageIcon rootIcon = this.getIcon("TangoSplash.jpg", 0.2);
    public ImageIcon classIcon;
    public ImageIcon collectionIcon;
    public ImageIcon classPropertyIcon;
    public ImageIcon cmdIcon;
    public ImageIcon cmdExpertIcon;
    public ImageIcon scalarIcon;
    public ImageIcon scalarExpertIcon;
    public ImageIcon spectrumIcon;
    public ImageIcon spectrumExpertIcon;
    public ImageIcon imageIcon;
    public ImageIcon imageExpertIcon;
    public ImageIcon forwardedIcon;
    public ImageIcon pipeIcon;
    public ImageIcon devicePropertyIcon;
    public ImageIcon stateIcon;
    public ImageIcon inheritanceIcon;
    public ImageIcon removeIcon;
    public ImageIcon abstractIcon;
    public ImageIcon inheritedIcon;
    public ImageIcon overloadedIcon;
    public ImageIcon unknownIcon;
    public ImageIcon reloadIcon;
    public ImageIcon newIcon;
    public ImageIcon openIcon;
    public ImageIcon saveIcon;
    public ImageIcon cppLogo;
    public ImageIcon javaLogo;
    public ImageIcon pythonLogo;
    public ImageIcon pythonHLLogo;
    public ImageIcon errorIcon;
    private static double pogoGuiRevision = -1.0;
    private static final String tooltipHeader = "<html><BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFD0\">";
    private static HashMap<String, Color> foregroundMap = null;
    private static HashMap<String, Color> stateMap = null;
    private static Splash splash = null;
    private static boolean splashOn;
    private SplashRefresher splash_refresher;
    private static boolean useDisplay;
    private boolean splashInit = false;

    private Utils() {
        this.logoIcon = this.classIcon = this.getIcon("TangoClass.gif", 0.12);
        this.collectionIcon = this.getIcon("tools.gif");
        this.classPropertyIcon = this.getIcon("class.gif");
        this.cmdIcon = this.getIcon("command.gif");
        this.cmdExpertIcon = this.getIcon("command_expert.gif");
        this.scalarIcon = this.getIcon("scalar.gif");
        this.scalarExpertIcon = this.getIcon("scalar_expert.gif");
        this.spectrumIcon = this.getIcon("spectrum.gif");
        this.spectrumExpertIcon = this.getIcon("spectrum_expert.gif");
        this.imageIcon = this.getIcon("image.gif", 0.25);
        this.imageExpertIcon = this.getIcon("image_expert.gif", 0.25);
        this.forwardedIcon = this.getIcon("forward.gif", 0.2);
        this.pipeIcon = this.getIcon("pipe.gif", 0.16);
        this.devicePropertyIcon = this.getIcon("device.gif");
        this.stateIcon = this.getIcon("state.gif");
        this.inheritanceIcon = this.getIcon("inherite.gif", 0.5);
        this.removeIcon = this.getIcon("remove.gif");
        this.abstractIcon = this.getIcon("abstract.gif");
        this.inheritedIcon = this.getIcon("inherited.gif");
        this.overloadedIcon = this.getIcon("concrete.gif");
        this.unknownIcon = this.getIcon("greyball.gif");
        this.reloadIcon = this.getIcon("reload_icon.gif", 0.8);
        this.newIcon = this.getIcon("new_icon.gif", 1.0);
        this.openIcon = this.getIcon("open_icon.gif", 1.0);
        this.saveIcon = this.getIcon("save_icon.gif", 1.0);
        this.cppLogo = this.getIcon("CppLogo.gif", 0.66);
        this.javaLogo = this.getIcon("JavaLogo.gif", 0.12);
        this.pythonLogo = this.getIcon("PythonLogo.gif", 0.33);
        this.pythonHLLogo = this.getIcon("PythonHLLogo.gif", 0.33);
        this.errorIcon = this.getIcon("error.gif");
        Utils.getPogoGuiRevision();
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public static double getPogoGuiRevision() {
        if (pogoGuiRevision < 0.0) {
            StringTokenizer stk = new StringTokenizer("9.1.10  -  Wed Nov 25 07:48:43 CET 2015");
            String s = stk.nextToken();
            int end = s.indexOf(46);
            if (end > 0) {
                if ((end = s.indexOf(46, end + 1)) > 0) {
                    s = s.substring(0, end);
                }
                try {
                    pogoGuiRevision = Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    System.err.println("When trying to get PogoGuiRevision :\n" + e);
                }
            }
            System.out.println("********* Pogo GUI Release : " + pogoGuiRevision + ".x *********");
        }
        return pogoGuiRevision;
    }

    public ImageIcon getIcon(String filename, double ratio) {
        ImageIcon icon = this.getIcon(filename);
        return this.getIcon(icon, ratio);
    }

    public ImageIcon getIcon(ImageIcon icon, double ratio) {
        if (icon != null) {
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            width = (int)(ratio * (double)width);
            height = (int)(ratio * (double)height);
            icon = new ImageIcon(icon.getImage().getScaledInstance(width, height, 4));
        }
        return icon;
    }

    public URL getImageUrl(String filename) {
        return this.getClass().getResource("/org/tango/pogo/pogo_gui/img/" + filename);
    }

    public ImageIcon getIcon(String filename) {
        URL url = this.getImageUrl(filename);
        if (url == null) {
            System.err.println("Icon file  " + filename + "  not found");
            return null;
        }
        return new ImageIcon(url);
    }

    public static String getRelativeFilename(String absFilename) {
        String relativeFilename = absFilename;
        int pos = absFilename.lastIndexOf(System.getProperty("file.separator"));
        if (pos > 0) {
            relativeFilename = absFilename.substring(pos + 1);
        }
        return relativeFilename;
    }

    public static String getPath(String filename) {
        String separator = System.getProperty("file.separator");
        int pos = filename.lastIndexOf(separator);
        String path = "./";
        if (pos > 0) {
            path = filename.substring(0, pos);
        }
        return path;
    }

    public static int getLanguage(String lang) {
        for (int i = 0; i < PogoConst.strLang.length; ++i) {
            if (!lang.toLowerCase().equals(PogoConst.strLang[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public static String getFileExtension(String lang) {
        return PogoConst.fileExtension[Utils.getLanguage(lang)];
    }

    public static String buildCppExecuteMethodName(String commandName) {
        if (commandName.equals("State")) {
            return "dev_state";
        }
        if (commandName.equals("Status")) {
            return "dev_status";
        }
        String str = "";
        for (int i = 0; i < commandName.length(); ++i) {
            if (commandName.charAt(i) >= 'A' && commandName.charAt(i) <= 'Z') {
                if (i > 0 && (commandName.charAt(i - 1) < 'A' || commandName.charAt(i - 1) > 'Z')) {
                    str = str + '_';
                }
                str = str + (char)(commandName.charAt(i) + 32);
                continue;
            }
            str = str + commandName.charAt(i);
        }
        return str;
    }

    public static int getCommandIndex(EList<Command> list, Command cmd) {
        int idx = -1;
        int i = 0;
        for (Command c : list) {
            if (c == cmd) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getAttributeIndex(EList<Attribute> list, Attribute attribute) {
        int idx = -1;
        int i = 0;
        for (Attribute att : list) {
            if (att == attribute) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getForwardedAttributeIndex(EList<ForwardedAttribute> list, ForwardedAttribute attribute) {
        int idx = -1;
        int i = 0;
        for (ForwardedAttribute att : list) {
            if (att == attribute) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getPipeIndex(EList<Pipe> list, Pipe attribute) {
        int idx = -1;
        int i = 0;
        for (Pipe pipe : list) {
            if (pipe == attribute) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getStateIndex(EList<State> list, State state) {
        int idx = -1;
        int i = 0;
        for (State st : list) {
            if (st == state) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static int getPropertyIndex(EList<Property> list, Property prop) {
        int idx = -1;
        int i = 0;
        for (Property p : list) {
            if (p == prop) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static String strReplaceSpecialCharToCode(String text) {
        if (text == null) {
            return null;
        }
        text = Utils.strReplace(text, "\"", "``").trim();
        text = Utils.strReplace(text, "'", "`").trim();
        return text;
    }

    public static String strReplaceSpecialCharToDisplay(String text) {
        if (text == null) {
            return null;
        }
        text = Utils.strReplace(text, "\\\"", "\"").trim();
        text = Utils.strReplace(text, "\\'", "'").trim();
        return text;
    }

    public static String strReplace(String text, String old_str, String new_str) {
        if (text == null) {
            return "";
        }
        int pos = 0;
        while ((pos = text.indexOf(old_str, pos)) >= 0) {
            text = text.substring(0, pos) + new_str + text.substring(pos + old_str.length());
            pos += new_str.length();
        }
        return text;
    }

    public static String checkNameSyntax(String name, String type, boolean isStateStatus) throws PogoException {
        return Utils.checkNameSyntax(name, type, isStateStatus, false);
    }

    public static String checkNameSyntax(String name, String type, boolean isStateStatus, boolean isAttribute) throws PogoException {
        if (name == null || name.length() == 0) {
            throw new PogoException(type + " (" + name + ") not valid !");
        }
        StringTokenizer stk = new StringTokenizer(name);
        ArrayList<String> vs = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            vs.add(stk.nextToken());
        }
        name = "";
        for (String s : vs) {
            name = name + s;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z' || c == '_') continue;
            throw new PogoException("Syntax error in " + type + ": Do not use '" + c + "' char.");
        }
        char firstChar = name.toUpperCase().charAt(0);
        if (!(firstChar >= 'A' && firstChar <= 'Z' || firstChar == '_' && isAttribute)) {
            throw new PogoException(name + ":\nSyntax error in " + type + ": The first char must be a letter");
        }
        if (!isStateStatus && (name.equals("State") || name.equals("Status"))) {
            throw new PogoException(name + "  is reserved");
        }
        return name;
    }

    public static String strBoolean(boolean b) {
        return b ? "true" : "false";
    }

    public static String strBoolean(String str) {
        return Utils.isTrue(str) ? "true" : "false";
    }

    public static boolean isTrue(String str) {
        return str != null && str.equals("true");
    }

    public static boolean isFalse(String str) {
        return !Utils.isTrue(str);
    }

    public static boolean isSet(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isEquals(String str1, String str2) {
        return str1 != null && str2 != null && str1.equals(str2);
    }

    public static boolean isExpert(Command cmd) {
        return Utils.isEquals(cmd.getDisplayLevel(), PogoConst.strLevel[1]);
    }

    public static boolean isExpert(Attribute att) {
        return Utils.isEquals(att.getDisplayLevel(), PogoConst.strLevel[1]);
    }

    public static void popupError(Component component, String message) {
        try {
            throw new PogoException(message);
        }
        catch (PogoException e) {
            Utils.getInstance().stopSplashRefresher();
            e.popup(component);
            return;
        }
    }

    public ArrayList<String> getFileList(String dirName) {
        ArrayList<String> v = new ArrayList<String>();
        File dir = new File(dirName);
        String[] fileNames = dir.list();
        if (fileNames == null) {
            return v;
        }
        for (String name : fileNames) {
            String filename = dirName + "/" + name;
            File f = new File(filename);
            if (f.isDirectory()) continue;
            v.add(name);
        }
        Collections.sort(v, new StringCompare());
        return v;
    }

    public static String searchFileFromDirectory(String searched, String dirname) {
        File d = new File(dirname);
        String[] filenames = d.list();
        if (filenames == null) {
            return null;
        }
        for (String name : filenames) {
            String filename = dirname + "/" + name;
            File f = new File(filename);
            if (f.isDirectory()) {
                String found = Utils.searchFileFromDirectory(searched, f.toString());
                if (found == null) continue;
                return found;
            }
            if (!name.equals(searched)) continue;
            return filename;
        }
        return null;
    }

    public static boolean osIsUnix() {
        String os = System.getProperty("os.name");
        return !os.toLowerCase().startsWith("windows");
    }

    public static void showInHtmBrowser(String url) {
        String browser = System.getProperty("BROWSER");
        if (browser == null) {
            browser = Utils.osIsUnix() ? "firefox - turbo" : "explorer";
        }
        String cmd = browser + " " + url;
        try {
            Utils.executeShellCmdAndReturn(cmd);
        }
        catch (Exception e) {
            PogoException.popup((Component)new JFrame(), e.toString());
        }
    }

    public static void executeShellCmdAndReturn(String cmd) throws IOException {
        Process process = Runtime.getRuntime().exec(cmd);
        InputStream inputStream = process.getInputStream();
        new BufferedReader(new InputStreamReader(inputStream));
    }

    public static String getXmiFile() {
        String[] fileList;
        File f = new File(".");
        for (String fileName : fileList = f.list()) {
            if (!fileName.endsWith(".xmi") || !new File(fileName).isFile()) continue;
            return fileName;
        }
        return null;
    }

    static void manageHtmlDirectory(PogoDeviceClass pogoClass, boolean beforeProcessing) {
        String defaultLocation = "./doc_html";
        if (!PogoProperty.docHome.equals(defaultLocation) && pogoClass.getDescription().getFilestogenerate().contains("html")) {
            File defaultLocationFile = new File(pogoClass.getDescription().getSourcePath() + "/" + defaultLocation);
            File expectedLocationFile = new File(pogoClass.getDescription().getSourcePath() + "/" + PogoProperty.docHome);
            if (beforeProcessing) {
                if (expectedLocationFile.renameTo(defaultLocationFile)) {
                    System.err.println("Failed to move html dir to " + defaultLocation);
                }
            } else if (defaultLocationFile.renameTo(expectedLocationFile)) {
                System.err.println("Failed to move html dir to " + expectedLocationFile);
            }
        }
    }

    private static String getAbsolutePath(String path) {
        File file = new File(path);
        if (file.isFile()) {
            return file.getParent();
        }
        return file.getAbsolutePath();
    }

    public static String getRelativePath(String path, String referencePath) {
        int i;
        String separator = System.getProperty("file.separator");
        path = Utils.getAbsolutePath(path);
        referencePath = Utils.getAbsolutePath(referencePath);
        StringTokenizer stk = new StringTokenizer(path, separator);
        ArrayList<String> pathList = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            pathList.add(stk.nextToken());
        }
        stk = new StringTokenizer(referencePath, separator);
        ArrayList<String> refList = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            refList.add(stk.nextToken());
        }
        if (((String)refList.get(0)).endsWith(":") && ((String)pathList.get(0)).endsWith(":") && !((String)refList.get(0)).equalsIgnoreCase((String)pathList.get(0))) {
            return path;
        }
        for (int idx = ((String)refList.get(0)).equalsIgnoreCase((String)pathList.get(0)) ? 1 : 0; idx < refList.size() && idx < pathList.size() && ((String)refList.get(idx)).equals(pathList.get(idx)); ++idx) {
        }
        StringBuilder sb = new StringBuilder();
        for (i = idx; i < refList.size(); ++i) {
            sb.append("..").append(separator);
        }
        for (i = idx; i < pathList.size(); ++i) {
            sb.append((String)pathList.get(i)).append(separator);
        }
        String relative = sb.toString();
        if (relative.endsWith(separator)) {
            relative = relative.substring(0, relative.length() - 1);
        }
        if (!relative.startsWith("..")) {
            relative = "./" + relative;
        }
        if ((relative = Utils.strReplace(relative, "\\", "/")).startsWith("./.")) {
            relative = ".";
        }
        return relative;
    }

    public static String getAbsolutePath(String relativePath, String referencePath) {
        String separator = System.getProperty("file.separator");
        referencePath = Utils.getAbsolutePath(referencePath);
        return new File(referencePath + separator + relativePath).getAbsolutePath();
    }

    public static void main(String[] args) {
        String relative = "../../CounterTimer/trunk/src";
        String reference = "Y:/tango/tmp/pascal/rel_path/SimCounterTimer/trunk/SimCounterTimer.xmi";
        String path = "y:/tango/tmp/pascal/rel_path/CounterTimer/trunk/src";
        System.out.println("Absolute: " + Utils.getAbsolutePath(relative, reference));
        System.out.println("Relative: " + Utils.getRelativePath(path, reference));
    }

    public static String buildToolTip(String text) {
        return Utils.buildToolTip(null, text);
    }

    public static String buildToolTip(String title, String text) {
        StringBuilder sb = new StringBuilder(tooltipHeader);
        if (title != null && title.length() > 0) {
            sb.append("<b><Center>").append(Utils.strReplace(title, "\n", "<br>\n")).append("</center></b><HR WIDTH=\"100%\">");
        }
        if (text != null && text.length() > 0) {
            text = Utils.strReplace(text, "\n", "<br>\n");
            text = Utils.strReplace(text, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            sb.append(text);
        }
        return sb.toString();
    }

    public static Color getForeground4State(String stateName) {
        Color color;
        if (foregroundMap == null) {
            foregroundMap = new HashMap();
            foregroundMap.put("ON", Color.black);
            foregroundMap.put("OFF", Color.black);
            foregroundMap.put("CLOSE", Color.black);
            foregroundMap.put("OPEN", Color.black);
            foregroundMap.put("INSERT", Color.black);
            foregroundMap.put("EXTRACT", Color.black);
            foregroundMap.put("MOVING", Color.white);
            foregroundMap.put("STANDBY", Color.black);
            foregroundMap.put("FAULT", Color.white);
            foregroundMap.put("INIT", Color.black);
            foregroundMap.put("RUNNING", Color.white);
            foregroundMap.put("ALARM", Color.black);
            foregroundMap.put("DISABLE", Color.black);
            foregroundMap.put("UNKNOWN", Color.white);
        }
        if ((color = foregroundMap.get(stateName)) == null) {
            color = foregroundMap.get("UNKNOWN");
        }
        return color;
    }

    public static Color getColor4State(String stateName) {
        Color color;
        if (stateMap == null) {
            stateMap = new HashMap();
            stateMap.put("ON", new Color(0, 255, 0));
            stateMap.put("OFF", new Color(255, 255, 255));
            stateMap.put("CLOSE", new Color(255, 255, 255));
            stateMap.put("OPEN", new Color(0, 255, 0));
            stateMap.put("INSERT", new Color(255, 255, 255));
            stateMap.put("EXTRACT", new Color(0, 255, 0));
            stateMap.put("MOVING", new Color(128, 160, 255));
            stateMap.put("STANDBY", new Color(255, 255, 0));
            stateMap.put("FAULT", new Color(255, 0, 0));
            stateMap.put("INIT", new Color(204, 204, 122));
            stateMap.put("RUNNING", new Color(0, 125, 0));
            stateMap.put("ALARM", new Color(255, 140, 0));
            stateMap.put("DISABLE", new Color(255, 0, 255));
            stateMap.put("UNKNOWN", new Color(125, 125, 125));
        }
        if ((color = stateMap.get(stateName)) == null) {
            color = stateMap.get("UNKNOWN");
        }
        return color;
    }

    private void createSplash() {
        try {
            if (tango_icon == null) {
                tango_icon = this.getIcon("TangoSplash.gif");
            }
            JSmoothProgressBar myBar = new JSmoothProgressBar();
            myBar.setStringPainted(true);
            myBar.setBackground(Color.lightGray);
            myBar.setProgressBarColors(Color.gray, Color.lightGray, Color.darkGray);
            splash = new Splash(tango_icon, Color.black, myBar);
            splash.setMessage("POGO: Tango code generator");
            splash.setMaxProgress(100);
            splash.setTitle("POGO");
            splash.setCopyright("9.1.10  -  Wed Nov 25 07:48:43 CET 2015");
        }
        catch (Exception e) {
            useDisplay = false;
            System.err.println("Cannot create Splah: " + e);
        }
    }

    public void stopSplashRefresher() {
        if (splash != null && useDisplay) {
            this.splash_refresher.setSplashOn(false, "");
        }
    }

    public void startSplashRefresher(String message) {
        String env;
        if (!this.splashInit && (env = System.getenv("Classes2www")) != null && env.equals("true")) {
            useDisplay = false;
        }
        this.splashInit = true;
        if (splash == null && useDisplay) {
            this.createSplash();
        }
        if (!useDisplay) {
            splash = null;
        }
        if (useDisplay) {
            splashOn = true;
            this.splash_refresher = new SplashRefresher();
            this.splash_refresher.start();
            this.splash_refresher.setSplashOn(true, message);
        }
    }

    static {
        useDisplay = true;
    }

    class StringCompare
    implements Comparator<String> {
        StringCompare() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }

    private class SplashRefresher
    extends Thread {
        private SplashRefresher() {
        }

        private synchronized void setSplashOn(boolean b, String message) {
            if (useDisplay) {
                splashOn = b;
                splash.setMessage(message);
            }
        }

        @Override
        public void run() {
            int idx = 1;
            splash.initProgress();
            splash.setVisible(true);
            splash.repaint();
            while (splashOn) {
                splash.progress(idx);
                if (idx++ > 98) {
                    idx = 10;
                }
                this.doSleep(100L);
            }
            splash.progress(100);
            splash.setVisible(false);
        }

        private synchronized void doSleep(long millis) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

