/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.tools.Utils;

public class StateMachineTable
extends JTable {
    private EList<Command> commands = null;
    private EList<Attribute> attributes = null;
    private EList<Pipe> pipes = null;
    private EList<State> stateList;
    private List<String> columnNames = new ArrayList<String>();
    private List<RowItem> itemList = new ArrayList<RowItem>();
    private TablePopupMenu popupMenu = new TablePopupMenu(this);
    private int width = 0;
    private static Color headerBackground;
    private boolean sortUp = true;
    public static final int COMMAND = 0;
    public static final int ATTRIBUTE = 1;
    public static final int PIPE = 2;
    private static final String[] ItemNames;
    private static final int FIRST_COLUMN_WIDTH = 200;
    private static final int STATE_COLUMN_WIDTH = 60;
    public static final int MAX_HEIGHT = 500;
    private static final Boolean READ;
    private static final Boolean WRITE;
    private int selectedColumn;
    private int selectedRow;
    private static final int SELECT_ALL = 0;
    private static final int RESET_ALL = 1;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    static {
        ItemNames = new String[]{"Commands", "Attributes", "Pipes"};
        READ = false;
        WRITE = true;
        menuLabels = new String[]{"Select ALL", "Un select ALL"};
    }

    public StateMachineTable(PogoDeviceClass pogoClass, int type) {
        this.stateList = pogoClass.getStates();
        this.columnNames.add(ItemNames[type]);
        for (State state : this.stateList) {
            this.columnNames.add(state.getName());
        }
        switch (type) {
            case 0: {
                this.commands = pogoClass.getCommands();
                for (Command command : this.commands) {
                    String name = command.getName();
                    if (name.equals("State") || name.equals("Status")) continue;
                    this.itemList.add(new RowItem(name, command.getExcludedStates()));
                }
                break;
            }
            case 1: {
                this.attributes = pogoClass.getAttributes();
                for (Attribute attribute : this.attributes) {
                    boolean writable;
                    this.itemList.add(new RowItem(attribute.getName(), attribute.getReadExcludedStates(), READ));
                    boolean bl = writable = !attribute.getRwType().equals(PogoConst.AttrRWtypeArray[0]);
                    if (!writable) continue;
                    this.itemList.add(new RowItem(attribute.getName(), attribute.getWriteExcludedStates(), WRITE));
                }
                break;
            }
            case 2: {
                this.pipes = pogoClass.getPipes();
                for (Pipe pipe : this.pipes) {
                    boolean writable;
                    this.itemList.add(new RowItem(pipe.getName(), pipe.getReadExcludedStates(), READ));
                    boolean bl = writable = !pipe.getRwType().equals(PogoConst.AttrRWtypeArray[0]);
                    if (!writable) continue;
                    this.itemList.add(new RowItem(pipe.getName(), pipe.getWriteExcludedStates(), WRITE));
                }
                break;
            }
        }
        this.buildTable();
    }

    public Dimension getDimension(JDialog parent) {
        parent.pack();
        int height = this.getHeight() + 30;
        if (height > 500) {
            height = 500;
        }
        return new Dimension(this.width, height);
    }

    private void buildTable() {
        this.setModel(new DataTableModel());
        this.setDefaultRenderer(String.class, new LabelCellRenderer());
        this.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StateMachineTable.this.tableActionPerformed(evt);
            }
        });
        Enumeration<TableColumn> columnEnum = this.getColumnModel().getColumns();
        int i = 0;
        while (columnEnum.hasMoreElements()) {
            int w = i++ == 0 ? 200 : 60;
            this.width += w;
            TableColumn tableColumn = columnEnum.nextElement();
            tableColumn.setPreferredWidth(w);
        }
        this.width += 20;
        this.getTableHeader().setDefaultRenderer(new LabelHeaderRenderer());
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StateMachineTable.this.tableHeaderActionPerformed(evt);
            }
        });
        headerBackground = this.getTableHeader().getBackground();
    }

    private void tableActionPerformed(MouseEvent event) {
        Point clickedPoint = new Point(event.getX(), event.getY());
        int row = this.rowAtPoint(clickedPoint);
        int column = this.columnAtPoint(clickedPoint);
        int mask = event.getModifiers();
        if ((mask & 0x10) != 0) {
            if (column > 0) {
                RowItem rowItem = this.itemList.get(row);
                rowItem.toggleAllowed(--column);
                this.repaint();
            }
        } else if ((mask & 4) != 0) {
            this.selectedRow = row;
            this.popupMenu.showMenu(event, false);
        }
    }

    private void tableHeaderActionPerformed(MouseEvent event) {
        int mask = event.getModifiers();
        this.selectedColumn = this.getTableHeader().columnAtPoint(new Point(event.getX(), event.getY()));
        if ((mask & 4) != 0) {
            if (this.selectedColumn > 0) {
                this.popupMenu.showMenu(event, true);
            }
        } else if ((mask & 0x10) != 0 && this.selectedColumn == 0) {
            Collections.sort(this.itemList, new RowItemComparator());
            this.sortUp = !this.sortUp;
        }
    }

    private void setAllFor(boolean b, boolean forState) {
        if (forState) {
            for (RowItem item : this.itemList) {
                item.setAllowed(this.selectedColumn - 1, b);
            }
        } else {
            this.itemList.get(this.selectedRow).setAllowed(b);
        }
        this.repaint();
    }

    private void updateExcluded(String name) {
        for (RowItem item : this.itemList) {
            if (!item.name.equals(name)) continue;
            item.updateExcluded();
        }
    }

    public void updateExcluded() {
        if (this.commands != null) {
            for (Command command : this.commands) {
                this.updateExcluded(command.getName());
            }
        }
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                this.updateExcluded(attribute.getName());
            }
        }
        if (this.pipes != null) {
            for (Pipe pipe : this.pipes) {
                this.updateExcluded(pipe.getName());
            }
        }
    }

    public class DataTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return StateMachineTable.this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return StateMachineTable.this.itemList.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.getColumnCount()) {
                return (String)StateMachineTable.this.columnNames.get(this.getColumnCount() - 1);
            }
            return (String)StateMachineTable.this.columnNames.get(columnIndex);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return StateMachineTable.this.itemList.get(row);
            }
            RowItem rowItem = (RowItem)StateMachineTable.this.itemList.get(row);
            return rowItem.allowed[--column];
        }

        public Class getColumnClass(int column) {
            if (StateMachineTable.this.isVisible()) {
                if (column == 0) {
                    return String.class;
                }
                return Boolean.class;
            }
            return null;
        }
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setFont(new Font("Dialog", 1, 12));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(((RowItem)StateMachineTable.this.itemList.get(row)).toString());
            this.setBackground(headerBackground);
            return this;
        }
    }

    public class LabelHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        public LabelHeaderRenderer() {
            this.setFont(new Font("Dialog", 1, 12));
            this.setOpaque(true);
            this.setBorder(new MatteBorder(null));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            switch (column) {
                case 0: {
                    this.setText("");
                    this.setBackground(headerBackground);
                    break;
                }
                default: {
                    String stateName = (String)StateMachineTable.this.columnNames.get(column);
                    this.setText(stateName);
                    this.setBackground(Utils.getColor4State((String)StateMachineTable.this.columnNames.get(column)));
                    this.setForeground(Utils.getForeground4State((String)StateMachineTable.this.columnNames.get(column)));
                }
            }
            return this;
        }
    }

    private class RowItem {
        private String name;
        private boolean write = false;
        private boolean display = false;
        private Boolean[] allowed;
        private EList<String> excluded;

        private RowItem(String name, EList<String> excluded) {
            this.name = name;
            this.excluded = excluded;
            this.manageAllowed(excluded);
        }

        private RowItem(String name, EList<String> excluded, boolean write) {
            this.name = name;
            this.write = write;
            this.display = true;
            this.excluded = excluded;
            this.manageAllowed(excluded);
        }

        private void manageAllowed(EList<String> excluded) {
            this.allowed = new Boolean[StateMachineTable.this.stateList.size()];
            int i = 0;
            for (State state : StateMachineTable.this.stateList) {
                this.allowed[i++] = this.isAllowed(state.getName(), excluded);
            }
        }

        private boolean isAllowed(String stateName, EList<String> excluded) {
            boolean found = false;
            for (String s : excluded) {
                if (!s.equals(stateName)) continue;
                found = true;
            }
            return !found;
        }

        private void setAllowed(boolean b) {
            int i = 0;
            while (i < this.allowed.length) {
                this.allowed[i] = b;
                ++i;
            }
        }

        private void setAllowed(int index, boolean b) {
            this.allowed[index] = b;
        }

        private void toggleAllowed(int index) {
            this.allowed[index] = this.allowed[index] == false;
        }

        private void updateExcluded() {
            this.excluded.clear();
            int i = 0;
            Boolean[] booleanArray = this.allowed;
            int n = this.allowed.length;
            int n2 = 0;
            while (n2 < n) {
                boolean b = booleanArray[n2];
                if (!b) {
                    this.excluded.add(((State)StateMachineTable.this.stateList.get(i)).getName());
                }
                ++i;
                ++n2;
            }
        }

        public String toString() {
            if (this.display) {
                return String.valueOf(this.name) + (this.write ? " (Write)" : " (Read)");
            }
            return this.name;
        }
    }

    private class RowItemComparator
    implements Comparator<RowItem> {
        private RowItemComparator() {
        }

        @Override
        public int compare(RowItem item1, RowItem item2) {
            switch (StateMachineTable.this.selectedColumn) {
                case 0: {
                    return this.alphabeticalSort(item1.toString(), item2.toString());
                }
            }
            return 0;
        }

        private int alphabeticalSort(String s1, String s2) {
            if (StateMachineTable.this.sortUp) {
                if (s1 == null) {
                    return 1;
                }
                if (s2 == null) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s2.compareTo(s1);
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private JLabel title;
        private JTable table;
        private boolean forState;

        private TablePopupMenu(JTable table) {
            this.table = table;
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            String[] stringArray = menuLabels;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String menuLabel = stringArray[n2];
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                } else {
                    JMenuItem btn = new JMenuItem(menuLabel);
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            TablePopupMenu.this.menuActionPerformed(evt);
                        }
                    });
                    this.add(btn);
                }
                ++n2;
            }
        }

        private void showMenu(MouseEvent event, boolean forState) {
            this.forState = forState;
            if (forState) {
                this.title.setText((String)StateMachineTable.this.columnNames.get(StateMachineTable.this.selectedColumn));
                this.show(this.table.getTableHeader(), event.getX(), event.getY());
            } else {
                this.title.setText(((RowItem)StateMachineTable.this.itemList.get(StateMachineTable.this.selectedRow)).toString());
                this.show(this.table, event.getX(), event.getY());
            }
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int itemIndex = -1;
            int i = 0;
            while (i < menuLabels.length) {
                if (this.getComponent(2 + i) == obj) {
                    itemIndex = i;
                }
                ++i;
            }
            switch (itemIndex) {
                case 0: {
                    StateMachineTable.this.setAllFor(true, this.forState);
                    break;
                }
                case 1: {
                    StateMachineTable.this.setAllFor(false, this.forState);
                }
            }
        }
    }
}

