/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.PogoDslFactory;
import fr.esrf.tango.pogo.pogoDsl.PropType;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.EditDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PropertyDialog
extends JDialog {
    private static final String[] propertyTypeNames = new String[]{"DevBoolean", "DevShort", "DevUShort", "DevLong", "DevULong", "DevLong64", "DevULong64", "DevFloat", "DevDouble", "String", "Array of DevShort", "Array of DevLong", "Array of DevLong64", "Array of DevFloat", "Array of DevDouble", "Array of String"};
    private static final int booleanProp = 0;
    private static final int shortProp = 1;
    private static final int ushortProp = 2;
    private static final int intProp = 3;
    private static final int uintProp = 4;
    private static final int long64Prop = 5;
    private static final int ulong64Prop = 6;
    private static final int floatProp = 7;
    private static final int doubleProp = 8;
    private static final int stringProp = 9;
    private static final int shortVector = 10;
    private static final int intVector = 11;
    private static final int longVector = 12;
    private static final int floatVector = 13;
    private static final int doubleVector = 14;
    private static final int stringVector = 15;
    private static final String defaultDataType = propertyTypeNames[9];
    private InheritanceStatus orig_status;
    private int retVal = 0;
    private JButton descBtn;
    private JTextArea descTxt;
    private JRadioButton mandatoryBtn;
    private JTextField nameTxt;
    private JLabel titleLbl;
    private JComboBox<String> typeComboBox;
    private JButton valueBtn;
    private JTextArea valueTxt;
    private static int[] columnSize = new int[]{140, 130, 40, 400};
    private static String[] columnTitle = new String[]{"name", "type", "Inherited", "Description"};

    public PropertyDialog(JFrame jFrame, Property property, boolean bl) {
        super((Frame)jFrame, true);
        this.initComponents();
        this.setProperty(property);
        this.manageInheritanceStatus(property);
        this.titleLbl.setText((bl ? "Device" : "Class") + "  Property");
        if (bl) {
            this.mandatoryBtn.setToolTipText(Utils.buildToolTip("Mandatoty Device Property", "The property value must be specified in Tango database.\nOtherwise all commands and read/write attribute will throw an exception."));
        } else {
            this.mandatoryBtn.setVisible(false);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void manageInheritanceStatus(Property property) {
        if (property != null) {
            this.orig_status = property.getStatus();
            if (Utils.isTrue(this.orig_status.getInherited())) {
                this.setEditable(false);
            } else {
                this.setEditable(true);
            }
        } else {
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
        }
    }

    private void setNotEditable(JComboBox<String> jComboBox) {
        String string = (String)jComboBox.getSelectedItem();
        if (string != null) {
            jComboBox.removeAllItems();
            jComboBox.addItem(string);
        }
    }

    private void setEditable(boolean bl) {
        this.nameTxt.setEditable(bl);
        if (!bl) {
            this.setNotEditable(this.typeComboBox);
        }
    }

    private void setProperty(Property property) {
        for (String i : propertyTypeNames) {
            this.typeComboBox.addItem(i);
        }
        if (property != null) {
            this.nameTxt.setText(property.getName());
            String string = Utils.strReplaceSpecialCharToDisplay(property.getDescription());
            this.descTxt.setText(string);
            EList<String> eList = property.getDefaultPropValue();
            StringBuilder stringBuilder = new StringBuilder();
            for (int string2 = 0; string2 < eList.size(); ++string2) {
                stringBuilder.append((String)eList.get(string2));
                if (string2 >= eList.size() - 1) continue;
                stringBuilder.append("\n");
            }
            this.valueTxt.setText(stringBuilder.toString().trim());
            this.mandatoryBtn.setSelected(Utils.isTrue(property.getMandatory()));
            String string3 = PropertyDialog.pogo2tangoType(property.getType());
            for (String string4 : propertyTypeNames) {
                if (!string4.equals(string3)) continue;
                this.typeComboBox.setSelectedItem(string4);
            }
        } else {
            this.typeComboBox.setSelectedItem(defaultDataType);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLbl = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel();
        this.nameTxt = new JTextField();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descTxt = new JTextArea();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.descBtn = new JButton();
        this.valueBtn = new JButton();
        this.mandatoryBtn = new JRadioButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.valueTxt = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PropertyDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLbl.setFont(new Font("Dialog", 1, 18));
        this.titleLbl.setText("Dialog Title");
        jPanel.add(this.titleLbl);
        this.getContentPane().add((Component)jPanel, "First");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel3.setLayout(new GridBagLayout());
        jLabel.setFont(new Font("Arial", 1, 18));
        jLabel.setText("Property Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 20, 0, 10);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        this.nameTxt.setColumns(20);
        this.nameTxt.setFont(new Font("Arial", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel3.add((Component)this.nameTxt, gridBagConstraints);
        jLabel2.setFont(new Font("Arial", 1, 12));
        jLabel2.setText("Property description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 10);
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        this.descTxt.setColumns(20);
        this.descTxt.setFont(new Font("Arial", 1, 12));
        this.descTxt.setRows(5);
        jScrollPane.setViewportView(this.descTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        jLabel3.setFont(new Font("Arial", 1, 12));
        jLabel3.setText("Property Type :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 20, 0, 10);
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setFont(new Font("Arial", 1, 12));
        jLabel4.setText("Default Value :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        this.typeComboBox.setFont(new Font("Arial", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        jPanel3.add(this.typeComboBox, gridBagConstraints);
        this.descBtn.setText("...");
        this.descBtn.setBorder(new SoftBevelBorder(0));
        this.descBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.descBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel3.add((Component)this.descBtn, gridBagConstraints);
        this.valueBtn.setText("...");
        this.valueBtn.setBorder(new SoftBevelBorder(0));
        this.valueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.descBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel3.add((Component)this.valueBtn, gridBagConstraints);
        this.mandatoryBtn.setFont(new Font("Arial", 1, 12));
        this.mandatoryBtn.setText("Mandatory in Database");
        this.mandatoryBtn.setHorizontalTextPosition(2);
        this.mandatoryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.mandatoryBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(30, 20, 0, 0);
        jPanel3.add((Component)this.mandatoryBtn, gridBagConstraints);
        jScrollPane2.setPreferredSize(new Dimension(166, 100));
        this.valueTxt.setColumns(20);
        this.valueTxt.setFont(new Font("Arial", 1, 12));
        this.valueTxt.setRows(5);
        jScrollPane2.setViewportView(this.valueTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 10, 0);
        jPanel3.add((Component)jScrollPane2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel3, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        try {
            String string = this.nameTxt.getText();
            if (string.length() == 0) {
                throw new PogoException("Property name ?");
            }
            string = Utils.checkNameSyntax(string, "name", true);
            this.nameTxt.setText(string);
        }
        catch (Exception exception) {
            PogoException.popup((Component)this, exception);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void descBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = "";
        if (jButton == this.valueBtn) {
            string = this.valueTxt.getText();
        } else if (jButton == this.descBtn) {
            string = this.descTxt.getText();
        }
        EditDialog editDialog = new EditDialog(this, string.trim());
        if (editDialog.showDialog() == 0) {
            if (jButton == this.valueBtn) {
                this.valueTxt.setText(editDialog.getText().trim());
            } else if (jButton == this.descBtn) {
                this.descTxt.setText(editDialog.getText().trim());
            }
        }
    }

    private void mandatoryBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.mandatoryBtn.getSelectedObjects() != null;
        this.valueTxt.setEnabled(!bl);
        this.valueBtn.setEnabled(!bl);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    Property getProperty() {
        boolean bl;
        String string = this.nameTxt.getText();
        Property property = OAWutils.factory.createProperty();
        property.setName(string);
        String string2 = this.descTxt.getText();
        string2 = Utils.strReplaceSpecialCharToCode(string2);
        property.setDescription(string2);
        String string3 = (String)this.typeComboBox.getSelectedItem();
        PropType propType = PropertyDialog.tango2pogoType(string3);
        property.setType(propType);
        boolean bl2 = bl = this.mandatoryBtn.getSelectedObjects() != null;
        if (bl) {
            property.setMandatory("true");
        } else {
            String string4 = Utils.strReplace(this.valueTxt.getText(), "\\n", "\n").trim();
            EList<String> eList = property.getDefaultPropValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken().trim();
                if (string5.length() <= 0) continue;
                eList.add(string5);
            }
        }
        property.setStatus(this.orig_status);
        return property;
    }

    public static Property cloneProperty(Property property) {
        Property property2 = OAWutils.cloneProperty(property);
        InheritanceStatus inheritanceStatus = property2.getStatus();
        if (!Utils.isTrue(inheritanceStatus.getAbstract())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        if (Utils.isTrue(inheritanceStatus.getInherited())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        property2.setStatus(inheritanceStatus);
        return property2;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static PropType createType(PropType propType) {
        return PropertyDialog.tango2pogoType(PropertyDialog.pogo2tangoType(propType));
    }

    public static PropType tango2pogoType(String string) {
        if (string.startsWith("Tango::")) {
            string = string.substring("Tango::".length());
        }
        if (string.equals("void")) {
            string = "DevVoid";
        }
        PogoDslFactory pogoDslFactory = OAWutils.factory;
        if (string.equals(propertyTypeNames[0])) {
            return pogoDslFactory.createBooleanType();
        }
        if (string.equals(propertyTypeNames[1])) {
            return pogoDslFactory.createShortType();
        }
        if (string.equals(propertyTypeNames[3]) || string.equals("DevInt")) {
            return pogoDslFactory.createIntType();
        }
        if (string.equals(propertyTypeNames[7])) {
            return pogoDslFactory.createFloatType();
        }
        if (string.equals(propertyTypeNames[8])) {
            return pogoDslFactory.createDoubleType();
        }
        if (string.equals(propertyTypeNames[2])) {
            return pogoDslFactory.createUShortType();
        }
        if (string.equals(propertyTypeNames[4])) {
            return pogoDslFactory.createUIntType();
        }
        if (string.equals(propertyTypeNames[5])) {
            return pogoDslFactory.createLongType();
        }
        if (string.equals(propertyTypeNames[6])) {
            return pogoDslFactory.createULongType();
        }
        if (string.equals(propertyTypeNames[9]) || string.equals("DevString") || string.equals("string")) {
            return pogoDslFactory.createStringType();
        }
        if (string.equals(propertyTypeNames[10]) || string.equals("vector<short>") || string.equals("DevVarShortArray")) {
            return pogoDslFactory.createShortVectorType();
        }
        if (string.equals(propertyTypeNames[11]) || string.equals("vector<long>") || string.equals("DevVarLongArray")) {
            return pogoDslFactory.createIntVectorType();
        }
        if (string.equals(propertyTypeNames[12])) {
            return pogoDslFactory.createIntVectorType();
        }
        if (string.equals(propertyTypeNames[13]) || string.equals("vector<float>") || string.equals("DevVarFloatArray")) {
            return pogoDslFactory.createFloatVectorType();
        }
        if (string.equals(propertyTypeNames[14]) || string.equals("vector<double>") || string.equals("DevVarDoubleArray")) {
            return pogoDslFactory.createDoubleVectorType();
        }
        if (string.equals(propertyTypeNames[15]) || string.toLowerCase().equals("vector<string>") || string.equals("DevStringVector") || string.equals("DevVarStringArray")) {
            return pogoDslFactory.createStringVectorType();
        }
        System.err.println("============================================");
        System.err.println(string + " NOT FOUND for property !!!");
        System.err.println("============================================");
        return null;
    }

    public static String pogo2tangoType(PropType propType) {
        String string = "fr.esrf.tango.pogo.pogoDsl.impl.";
        String string2 = "Vector";
        String string3 = "TypeImpl";
        String string4 = propType.toString();
        if (string4.startsWith(string)) {
            String string5 = string4.substring(string.length());
            int n = string5.indexOf(string3);
            if (n > 0) {
                string5 = string5.substring(0, n);
            }
            if (string5.indexOf(string2) > 0) {
                if (string5.contains("ShortVector")) {
                    return propertyTypeNames[10];
                }
                if (string5.contains("IntVector")) {
                    return propertyTypeNames[11];
                }
                if (string5.contains("LongVector")) {
                    return propertyTypeNames[12];
                }
                if (string5.contains("FloatVector")) {
                    return propertyTypeNames[13];
                }
                if (string5.contains("DoubleVector")) {
                    return propertyTypeNames[14];
                }
                if (string5.contains("StringVector")) {
                    return propertyTypeNames[15];
                }
            }
            if (string5.startsWith("Boolean")) {
                return propertyTypeNames[0];
            }
            if (string5.startsWith("Short")) {
                return propertyTypeNames[1];
            }
            if (string5.startsWith("UShort")) {
                return propertyTypeNames[2];
            }
            if (string5.startsWith("Int")) {
                return propertyTypeNames[3];
            }
            if (string5.startsWith("UInt")) {
                return propertyTypeNames[4];
            }
            if (string5.startsWith("Long")) {
                return propertyTypeNames[5];
            }
            if (string5.startsWith("ULong")) {
                return propertyTypeNames[6];
            }
            if (string5.startsWith("Float")) {
                return propertyTypeNames[7];
            }
            if (string5.startsWith("Double")) {
                return propertyTypeNames[8];
            }
            if (string5.startsWith("String")) {
                return propertyTypeNames[9];
            }
        } else {
            System.err.println(string4 + " not found !  (" + string + ")");
        }
        return "Not a Pogo Type";
    }

    public static void popupSummary(JFrame jFrame, ArrayList<Property> arrayList, boolean bl) {
        ArrayList<ArrayList<String>> arrayList2 = PropertyDialog.buildSummary(arrayList);
        String string = Integer.toString(arrayList.size()) + (bl ? "  Device" : "  Class") + " Properties";
        PopupTable popupTable = new PopupTable(jFrame, string, columnTitle, arrayList2);
        int n = arrayList.size();
        if (n > 35) {
            n = 35;
        }
        popupTable.setPreferredSize(columnSize, n);
        popupTable.setVisible(true);
    }

    public static ArrayList<ArrayList<String>> buildSummary(ArrayList<Property> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        for (Property property : arrayList) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(property.getName());
            arrayList3.add(PropertyDialog.pogo2tangoType(property.getType()));
            InheritanceStatus inheritanceStatus = property.getStatus();
            arrayList3.add(Utils.strBoolean(inheritanceStatus.getInherited()));
            arrayList3.add(Utils.strReplace(property.getDescription(), "\\n", "\n"));
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }
}

