/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tango.pogo.pogoDsl.Preferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.ServerDialog;
import org.tango.pogo.pogo_gui.packaging.PackUtils;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.TangoServer;
import org.tango.pogo.pogo_gui.tools.Utils;

public class MultiClassesTree
extends JTree {
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private MultiClassesTreePopupMenu menu;
    private JFrame parent;
    private EditClasses editedClasses = new EditClasses();
    private boolean modified = false;
    private LoadedClasses loadedClasses = new LoadedClasses();
    private static JFileChooser chooser = null;
    private static final Color background = Color.white;
    private DeviceClass copiedClass = null;
    private static final int EDIT_SERVER = 0;
    private static final int EDIT_CLASS = 1;
    private static final int ADD_CLASS = 2;
    private static final int COPY_CLASS = 3;
    private static final int PASTE_CLASS = 4;
    private static final int REMOVE_CLASS = 5;
    private static final int MOVE_UP = 6;
    private static final int MOVE_DOWN = 7;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Edit Server", "Edit class", "Add  class", "Copy  class", "Paste class", "Remove class", "Move up", "Move down"};

    public MultiClassesTree(JFrame jFrame, PogoMultiClasses pogoMultiClasses) throws PogoException {
        this.parent = jFrame;
        this.initComponents();
        this.buildTree(new TangoServer(pogoMultiClasses));
        this.createClassNodes(this.root, pogoMultiClasses.getClasses());
        this.expandChildren(this.root);
        this.setSelectionPath(null);
    }

    public MultiClassesTree(JFrame jFrame, TangoServer tangoServer) throws PogoException {
        this.parent = jFrame;
        this.initComponents();
        this.buildTree(tangoServer);
    }

    private void initComponents() {
        String string = System.getenv("SOURCE_PATH");
        if (string == null && (string = System.getProperty("SOURCE_PATH")) == null) {
            string = new File("").getAbsolutePath();
        }
        chooser = new JFileChooser(new File(string).getAbsolutePath());
        chooser.setFileFilter(PogoGUI.pogo6Filter);
        chooser.setFileFilter(PogoGUI.pogoFilter);
        this.menu = new MultiClassesTreePopupMenu(this);
        this.setBackground(background);
    }

    private void buildTree(TangoServer tangoServer) throws PogoException {
        this.root = new DefaultMutableTreeNode(tangoServer);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer tangoRenderer = new TangoRenderer();
        this.setCellRenderer(tangoRenderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MultiClassesTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        if ((mouseEvent.getClickCount() != 2 || (n & 0x10) == 0) && (n & 4) != 0) {
            if (defaultMutableTreeNode == this.root) {
                this.menu.showMenu(mouseEvent, (TangoServer)object);
            } else if (object instanceof DeviceClass) {
                this.menu.showMenu(mouseEvent, (DeviceClass)object);
            }
        }
    }

    private DeviceClass loadDeviceClass(OneClassSimpleDef oneClassSimpleDef) throws PogoException {
        String string = oneClassSimpleDef.getSourcePath() + "/" + oneClassSimpleDef.getClassname();
        string = Utils.isTrue(oneClassSimpleDef.getPogo6()) ? string + ".h" : string + ".xmi";
        DeviceClass deviceClass = null;
        File file = new File(string);
        while (deviceClass == null) {
            try {
                if (!file.exists()) {
                    TangoServer tangoServer = (TangoServer)this.root.getUserObject();
                    String string2 = tangoServer.sourcePath;
                    String string3 = Utils.getAbsolutePath(string, string2);
                    file = new File(string3);
                    if (!file.exists()) {
                        throw new PogoException("No such file: " + string);
                    }
                }
                if ((deviceClass = this.loadedClasses.getDeviceClass(file.getAbsolutePath())).getPogoDeviceClass().getName().equals(oneClassSimpleDef.getClassname())) continue;
                throw new PogoException(oneClassSimpleDef.getClassname() + " file expected !");
            }
            catch (PogoException pogoException) {
                pogoException.popup(this);
                chooser.setDialogTitle("Class: " + oneClassSimpleDef.getClassname() + " ?");
                if (chooser.showOpenDialog(this) == 0) {
                    file = chooser.getSelectedFile();
                    continue;
                }
                throw new PogoException("Canceled");
            }
        }
        return deviceClass;
    }

    private void createClassNodes(DefaultMutableTreeNode defaultMutableTreeNode, EList<OneClassSimpleDef> eList) throws PogoException {
        String string = defaultMutableTreeNode == this.root ? "root" : defaultMutableTreeNode.toString();
        for (OneClassSimpleDef oneClassSimpleDef : eList) {
            EList<String> eList2 = oneClassSimpleDef.getParentClasses();
            if (eList2.size() == 0) {
                eList2.add("root");
            }
            for (String string2 : eList2) {
                if (!string2.equals(string)) continue;
                DeviceClass deviceClass = this.loadDeviceClass(oneClassSimpleDef);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(deviceClass);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.createClassNodes(defaultMutableTreeNode2, eList);
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                if (bl) continue;
                this.expandNode(defaultMutableTreeNode2);
                bl = true;
                continue;
            }
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        arrayList.add(defaultMutableTreeNode);
        while (defaultMutableTreeNode != this.root) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            arrayList.add(0, defaultMutableTreeNode);
        }
        Object[] objectArray = new DefaultMutableTreeNode[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i] = (TreeNode)arrayList.get(i);
        }
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void editSelectedClass() {
        Object object = this.getSelectedObject();
        if (object instanceof DeviceClass) {
            try {
                this.editedClasses.addClass((DeviceClass)object);
            }
            catch (PogoException pogoException) {
                pogoException.popup(this);
            }
        }
    }

    boolean allEditorsAreClosed() {
        return this.editedClasses.everythingClosed();
    }

    private void editServer() {
        TangoServer tangoServer = (TangoServer)this.root.getUserObject();
        ServerDialog serverDialog = new ServerDialog(this.parent, tangoServer);
        if (serverDialog.showDialog() == 0) {
            this.setModified(true);
        }
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isANodeSelected() {
        return this.getSelectedNode() != null;
    }

    public boolean isAClassSelected() {
        Object object = this.getSelectedObject();
        return object instanceof DeviceClass;
    }

    public void addClass() {
        block3: {
            try {
                if (chooser.showOpenDialog(this) != 0) break block3;
                File file = chooser.getSelectedFile();
                DeviceClass deviceClass = this.loadedClasses.getDeviceClass(file.getAbsolutePath());
                String string = deviceClass.getPogoDeviceClass().getDescription().getLanguage();
                if (string.toLowerCase().equals("cpp")) {
                    DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(deviceClass);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.setModified(true);
                    this.expandChildren(defaultMutableTreeNode);
                    break block3;
                }
                throw new PogoException(string + " classes are not supported by multi classes manager !");
            }
            catch (PogoException pogoException) {
                pogoException.popup(this);
            }
        }
    }

    public void removeClass() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (JOptionPane.showConfirmDialog(this, "Remove " + defaultMutableTreeNode.getUserObject() + " class  ?", "Confirmation Window", 0) == 0) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.setModified(true);
        }
    }

    public void moveNode(boolean bl) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n2 = 0;
        for (n = 0; n < defaultMutableTreeNode2.getChildCount(); ++n) {
            if (!defaultMutableTreeNode2.getChildAt(n).equals(defaultMutableTreeNode)) continue;
            n2 = n;
        }
        n = 0;
        int n3 = defaultMutableTreeNode2.getChildCount() - 1;
        if (bl) {
            if (n2 > n) {
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2 - 1);
                this.setModified(true);
            }
        } else if (n2 < n3) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2 + 1);
            this.setModified(true);
        }
    }

    public boolean pasteAvailable() {
        return this.isANodeSelected() && this.copiedClass != null;
    }

    public void copySelectedClass() {
        Object object = this.getSelectedObject();
        if (object instanceof DeviceClass) {
            this.copiedClass = (DeviceClass)object;
        }
    }

    public void pasteClass() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.copiedClass);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getSelectedNode();
        this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        this.setModified(true);
        this.expandChildren(defaultMutableTreeNode2);
    }

    private ArrayList<DeviceClass> getClasses(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DeviceClass> arrayList = new ArrayList<DeviceClass>();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DeviceClass deviceClass = (DeviceClass)defaultMutableTreeNode2.getUserObject();
            arrayList.add(deviceClass);
            if (defaultMutableTreeNode != this.root) {
                deviceClass.addParentClass(defaultMutableTreeNode.getUserObject().toString());
            }
            ArrayList<DeviceClass> arrayList2 = this.getClasses(defaultMutableTreeNode2);
            for (DeviceClass deviceClass2 : arrayList2) {
                arrayList.add(deviceClass2);
            }
        }
        return arrayList;
    }

    public String getServerFileName() {
        TangoServer tangoServer = (TangoServer)this.root.getUserObject();
        if (tangoServer.sourcePath != null) {
            return tangoServer.sourcePath + "/" + tangoServer.name + ".multi.xmi";
        }
        return null;
    }

    public String getAuthor() {
        if (this.loadedClasses.isEmpty()) {
            return "? ? ?";
        }
        return PackUtils.buildMailAddress(this.loadedClasses.getAny().getPogoDeviceClass().getDescription());
    }

    public PogoMultiClasses getServer() {
        this.loadedClasses.resetParentClasses();
        TangoServer tangoServer = (TangoServer)this.root.getUserObject();
        ArrayList<DeviceClass> arrayList = this.getClasses(this.root);
        ArrayList<DeviceClass> arrayList2 = new ArrayList<DeviceClass>();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            DeviceClass deviceClass = arrayList.get(i);
            boolean bl = false;
            String string = deviceClass.getPogoDeviceClass().getName();
            for (DeviceClass deviceClass2 : arrayList2) {
                if (!deviceClass2.getPogoDeviceClass().getName().equals(string)) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList2.add(0, deviceClass);
        }
        for (DeviceClass deviceClass : arrayList2) {
            System.out.println(deviceClass.getPogoDeviceClass().getName());
        }
        PogoMultiClasses pogoMultiClasses = this.buildPogoMultiClassesObject(tangoServer.name, arrayList2);
        pogoMultiClasses.setName(tangoServer.name);
        pogoMultiClasses.setDescription(tangoServer.description);
        pogoMultiClasses.setSourcePath(tangoServer.sourcePath);
        return pogoMultiClasses;
    }

    private PogoMultiClasses buildPogoMultiClassesObject(String string, ArrayList<DeviceClass> arrayList) {
        PogoMultiClasses pogoMultiClasses = OAWutils.factory.createPogoMultiClasses();
        pogoMultiClasses.setName(string);
        Preferences preferences = OAWutils.factory.createPreferences();
        preferences.setMakefileHome(PogoProperty.makefileHome);
        pogoMultiClasses.setPreferences(preferences);
        EList<OneClassSimpleDef> eList = pogoMultiClasses.getClasses();
        for (DeviceClass deviceClass : arrayList) {
            Object object;
            Object object22;
            PogoDeviceClass pogoDeviceClass = deviceClass.getPogoDeviceClass();
            OneClassSimpleDef oneClassSimpleDef = OAWutils.factory.createOneClassSimpleDef();
            oneClassSimpleDef.setClassname(pogoDeviceClass.getName());
            oneClassSimpleDef.setSourcePath(pogoDeviceClass.getDescription().getSourcePath());
            for (String string2 : deviceClass.getParentClasses()) {
                oneClassSimpleDef.getParentClasses().add(string2);
            }
            if (Utils.getPogoGuiRevision() >= 8.1 && pogoDeviceClass.getDynamicAttributes().size() > 0) {
                oneClassSimpleDef.setHasDynamic("true");
            }
            if (deviceClass.isOldPogoModel()) {
                oneClassSimpleDef.setPogo6("true");
            }
            eList.add(oneClassSimpleDef);
            EList<Inheritance> eList2 = oneClassSimpleDef.getInheritances();
            EList<Inheritance> object32 = pogoDeviceClass.getDescription().getInheritances();
            for (Object object22 : object32) {
                object = OAWutils.factory.createInheritance();
                object.setClassname(object22.getClassname());
                object.setSourcePath(object22.getSourcePath());
                eList2.add((Inheritance)object);
            }
            EList<AdditionalFile> eList3 = oneClassSimpleDef.getAdditionalFiles();
            object22 = pogoDeviceClass.getAdditionalFiles();
            object = object22.iterator();
            while (object.hasNext()) {
                AdditionalFile additionalFile = (AdditionalFile)object.next();
                eList3.add(OAWutils.cloneAdditionalFile(additionalFile));
            }
        }
        return pogoMultiClasses;
    }

    @Override
    public String getName() {
        return this.root.getUserObject().toString();
    }

    private class MultiClassesTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private MultiClassesTreePopupMenu(JTree jTree) {
            this.tree = jTree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MultiClassesTreePopupMenu.this.hostActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent, TangoServer tangoServer) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(tangoServer.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.getComponent(6).setVisible(MultiClassesTree.this.pasteAvailable());
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, DeviceClass deviceClass) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(deviceClass.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(true);
            }
            this.getComponent(6).setVisible(MultiClassesTree.this.pasteAvailable());
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        private void hostActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    MultiClassesTree.this.editServer();
                    break;
                }
                case 1: {
                    MultiClassesTree.this.editSelectedClass();
                    break;
                }
                case 2: {
                    MultiClassesTree.this.addClass();
                    break;
                }
                case 3: {
                    MultiClassesTree.this.copySelectedClass();
                    break;
                }
                case 4: {
                    MultiClassesTree.this.pasteClass();
                    break;
                }
                case 5: {
                    MultiClassesTree.this.removeClass();
                    break;
                }
                case 6: {
                    MultiClassesTree.this.moveNode(true);
                    break;
                }
                case 7: {
                    MultiClassesTree.this.moveNode(false);
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int CLASS = 1;
        private ImageIcon class_icon = Utils.getInstance().getIcon("TangoClass.gif", 0.17);

        public TangoRenderer() {
            this.fonts = new Font[2];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 14);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (n == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(Utils.getInstance().rootIcon);
            } else {
                this.setFont(this.fonts[1]);
                this.setIcon(this.class_icon);
            }
            return this;
        }
    }

    private class EditClasses
    extends ArrayList<PogoGUI> {
        private EditClasses() {
        }

        private void addClass(DeviceClass deviceClass) throws PogoException {
            for (PogoGUI pogoGUI : this) {
                if (!pogoGUI.getMainClassName().equals(deviceClass.toString())) continue;
                pogoGUI.setVisible(true);
                return;
            }
            this.add(new PogoGUI(deviceClass, false));
            if (this.size() == 1) {
                Point point = MultiClassesTree.this.parent.getLocation();
                point.x += MultiClassesTree.this.parent.getWidth();
                point.y -= 50;
                ((PogoGUI)this.get(0)).setLocation(point);
            }
        }

        private boolean everythingClosed() {
            for (PogoGUI pogoGUI : this) {
                if (!pogoGUI.isVisible()) continue;
                return false;
            }
            return true;
        }
    }

    private static class LoadedClasses {
        private final Map<String, DeviceClass> deviceClasses = new HashMap<String, DeviceClass>();

        private LoadedClasses() {
        }

        DeviceClass getAny() {
            return this.deviceClasses.values().iterator().next();
        }

        boolean isEmpty() {
            return this.deviceClasses.size() == 0;
        }

        DeviceClass getDeviceClass(String string) throws PogoException {
            DeviceClass deviceClass = this.deviceClasses.get(string);
            if (deviceClass == null) {
                deviceClass = new DeviceClass(string);
                this.deviceClasses.put(string, deviceClass);
            }
            return deviceClass;
        }

        void resetParentClasses() {
            for (DeviceClass deviceClass : this.deviceClasses.values()) {
                deviceClass.resetParentClasses();
            }
        }
    }
}

