/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.xtext.xbase.lib.Pure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class ExclusiveRange
implements Iterable<Integer> {
    private final int first;
    private final int last;
    private final int step;
    private static final ListIterator<Integer> EMPTY_LIST_ITERATOR = new ListIterator<Integer>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Integer next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Integer previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return -1;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from a Range");
        }

        @Override
        public void set(Integer e) {
            throw new UnsupportedOperationException("Cannot set elements in a Range");
        }

        @Override
        public void add(Integer e) {
            throw new UnsupportedOperationException("Cannot add elements to a Range");
        }
    };

    @Override
    @Pure
    public ListIterator<Integer> iterator() {
        return this.isEmpty() ? EMPTY_LIST_ITERATOR : new RangeIterator();
    }

    @Pure
    public ExclusiveRange(int start, int end, boolean increment) {
        if (increment) {
            this.first = start;
            this.last = end - 1;
            this.step = 1;
        } else {
            this.first = start - 1;
            this.last = end;
            this.step = -1;
        }
    }

    @Pure
    public int size() {
        return this.isEmpty() ? 0 : Math.abs(this.last - this.first) + 1;
    }

    @Pure
    public boolean isEmpty() {
        return (this.last - this.first) * this.step < 0;
    }

    @Pure
    public boolean contains(int number) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.step == -1) {
            return number <= this.first && number >= this.last;
        }
        return number >= this.first && number <= this.last;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RangeIterator
    implements ListIterator<Integer> {
        private int next;
        private int nextIndex;

        private RangeIterator() {
            this.next = ExclusiveRange.this.first;
            this.nextIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (ExclusiveRange.this.step < 0) {
                return this.next >= ExclusiveRange.this.last;
            }
            return this.next <= ExclusiveRange.this.last;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int value = this.next;
            this.next += ExclusiveRange.this.step;
            ++this.nextIndex;
            return value;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public Integer previous() {
            if (this.nextIndex <= 0) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            this.next -= ExclusiveRange.this.step;
            return this.next;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from a Range");
        }

        @Override
        public void set(Integer e) {
            throw new UnsupportedOperationException("Cannot set elements in a Range");
        }

        @Override
        public void add(Integer e) {
            throw new UnsupportedOperationException("Cannot add elements to a Range");
        }
    }
}

