/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtIncompatible(value="reflection")
public class Conversions {
    @Pure
    public static Object doWrapArray(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> arrayClass = object.getClass();
        if (arrayClass.isArray()) {
            if (arrayClass.getComponentType().isPrimitive()) {
                WrappedPrimitiveArray result = WrappedPrimitiveArray.create(object);
                return result;
            }
            WrappedArray<Object> result = WrappedArray.create((Object[])object);
            return result;
        }
        return object;
    }

    @Pure
    public static Object unwrapArray(Object value) {
        return Conversions.unwrapArray(value, Object.class);
    }

    @Pure
    public static Object unwrapArray(Object value, Class<?> componentType) {
        if (value instanceof WrappedArray) {
            T[] result = ((WrappedArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedPrimitiveArray) {
            Object result = ((WrappedPrimitiveArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof Iterable) {
            if (!componentType.isPrimitive()) {
                ?[] result = Iterables.toArray((Iterable)value, componentType);
                return result;
            }
            try {
                List list = IterableExtensions.toList((Iterable)value);
                Object result = Array.newInstance(componentType, list.size());
                int i = 0;
                while (i < list.size()) {
                    Object element = list.get(i);
                    if (element == null) {
                        throw new ArrayStoreException("Cannot store <null> in primitive arrays.");
                    }
                    Array.set(result, i, element);
                    ++i;
                }
                return result;
            }
            catch (IllegalArgumentException iae) {
                throw new ArrayStoreException("Primitive conversion failed: " + iae.getMessage());
            }
        }
        return value;
    }

    private static Object checkComponentType(Object array, Class<?> expectedComponentType) {
        Class<?> actualComponentType = array.getClass().getComponentType();
        if (!expectedComponentType.isAssignableFrom(actualComponentType)) {
            throw new ArrayStoreException(String.format("The expected component type %s is not assignable from the actual type %s", expectedComponentType.getCanonicalName(), actualComponentType.getCanonicalName()));
        }
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappedArray<T>
    extends AbstractList<T>
    implements RandomAccess {
        private T[] array;

        public static <T> WrappedArray<T> create(T[] array) {
            return new WrappedArray<T>(array);
        }

        protected WrappedArray(T[] array) {
            this.array = array;
        }

        @Override
        public T get(int index) {
            return this.array[index];
        }

        @Override
        public T set(int index, T element) {
            T old = this.array[index];
            this.array[index] = element;
            ++this.modCount;
            return old;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.array.clone();
        }

        public T[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappedPrimitiveArray
    extends AbstractList<Object>
    implements RandomAccess {
        private Object array;
        private int size;

        @Pure
        public static WrappedPrimitiveArray create(Object array) {
            return new WrappedPrimitiveArray(array);
        }

        protected WrappedPrimitiveArray(Object array) {
            this.array = array;
            if (array != null) {
                this.size = Array.getLength(array);
            }
        }

        @Override
        public Object get(int index) {
            if (this.array == null) {
                throw new NullPointerException();
            }
            return Array.get(this.array, index);
        }

        @Override
        public Object set(int index, Object element) {
            if (this.array == null) {
                throw new NullPointerException();
            }
            Object old = this.get(index);
            Array.set(this.array, index, element);
            ++this.modCount;
            return old;
        }

        @Override
        public int size() {
            if (this.array == null) {
                throw new NullPointerException();
            }
            return this.size;
        }

        public Object internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }
}

