/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimapBasedSelectable
implements ISelectable {
    private Multimap<QualifiedName, IEObjectDescription> nameToObjects;
    private List<IEObjectDescription> allDescriptions;

    public MultimapBasedSelectable(Iterable<IEObjectDescription> allDescriptions) {
        this.setExportedObjects(allDescriptions);
    }

    @Override
    public boolean isEmpty() {
        return this.allDescriptions.isEmpty();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(final EClass type) {
        if (this.allDescriptions.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.filter(this.allDescriptions, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                return EcoreUtil2.isAssignableFrom(type, input.getEClass());
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(final EObject object) {
        if (this.allDescriptions.isEmpty()) {
            return Collections.emptyList();
        }
        final URI uri = EcoreUtil2.getPlatformResourceOrNormalizedURI(object);
        return Iterables.filter(this.allDescriptions, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return true;
                }
                return uri.equals(input.getEObjectURI());
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName name, boolean ignoreCase) {
        if (this.allDescriptions.isEmpty()) {
            return Collections.emptyList();
        }
        QualifiedName lowerCase = name.toLowerCase();
        if (this.nameToObjects.containsKey(lowerCase)) {
            Predicate<IEObjectDescription> predicate = ignoreCase ? new Predicate<IEObjectDescription>(){

                @Override
                public boolean apply(IEObjectDescription input) {
                    return EcoreUtil2.isAssignableFrom(type, input.getEClass());
                }
            } : new Predicate<IEObjectDescription>(){

                @Override
                public boolean apply(IEObjectDescription input) {
                    return name.equals(input.getName()) && EcoreUtil2.isAssignableFrom(type, input.getEClass());
                }
            };
            return Iterables.filter(this.nameToObjects.get(lowerCase), predicate);
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        return this.allDescriptions;
    }

    public void setExportedObjects(Iterable<IEObjectDescription> allDescriptions) {
        this.allDescriptions = Lists.newArrayList();
        this.nameToObjects = LinkedHashMultimap.create();
        for (IEObjectDescription description : allDescriptions) {
            this.allDescriptions.add(description);
            this.nameToObjects.put(description.getName().toLowerCase(), description);
        }
    }
}

