/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatefulTraceRegion
extends AbstractTraceRegion {
    private final ITextRegionWithLineInformation myRegion;
    private final List<ILocationData> associatedLocations;

    protected AbstractStatefulTraceRegion(ITextRegionWithLineInformation myRegion, ILocationData associatedLocation, AbstractTraceRegion parent) {
        this(myRegion, Lists.newArrayList(associatedLocation), parent);
    }

    protected AbstractStatefulTraceRegion(ITextRegionWithLineInformation myRegion, List<ILocationData> associatedLocations, AbstractTraceRegion parent) {
        super(parent);
        this.myRegion = myRegion;
        this.associatedLocations = associatedLocations;
        if (!this.isConsistentWithParent()) {
            throw new IllegalArgumentException("Produced region is inconsistent with parent, this: " + this + ", parent: " + parent);
        }
    }

    @Override
    public int getMyLength() {
        return this.myRegion.getLength();
    }

    @Override
    public int getMyOffset() {
        return this.myRegion.getOffset();
    }

    @Override
    public int getMyEndLineNumber() {
        return this.myRegion.getEndLineNumber();
    }

    @Override
    public int getMyLineNumber() {
        return this.myRegion.getLineNumber();
    }

    @Override
    public ITextRegionWithLineInformation getMyRegion() {
        return this.myRegion;
    }

    @Override
    public List<ILocationData> getAssociatedLocations() {
        return Collections.unmodifiableList(this.associatedLocations);
    }

    protected List<ILocationData> getWritableAssociatedLocations() {
        return this.associatedLocations;
    }
}

