/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.binary.asm.ClassFileBytesAccess;
import org.eclipse.xtext.common.types.access.binary.asm.JvmDeclaredTypeBuilder;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.access.reflect.ReflectURIHelper;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeFactory;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredTypeFactory
implements ITypeFactory<BinaryClass, JvmDeclaredType> {
    private final Stopwatches.StoppedTask createTypeTask = Stopwatches.forTask("AsmTypeFactory.createType");
    private static final Logger logger = Logger.getLogger(DeclaredTypeFactory.class);
    private final ClassLoader classLoader;
    private final ClassFileBytesAccess bytesAccess;
    private static final boolean ASM_AVAILABLE = DeclaredTypeFactory.isAsm5Available();
    private final boolean useASM;

    @Inject
    public DeclaredTypeFactory(ClassFileBytesAccess bytesAccess, ClassLoader loader) {
        this(bytesAccess, loader, ASM_AVAILABLE);
    }

    public DeclaredTypeFactory(ClassFileBytesAccess bytesAccess, ClassLoader loader, boolean useASM) {
        this.bytesAccess = bytesAccess;
        this.classLoader = loader;
        this.useASM = useASM;
    }

    private static boolean isAsm5Available() {
        try {
            if (Opcodes.class.getDeclaredField("ASM5") != null) {
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            logger.warn("--- xtext.common.types ---------------------------------------------------");
            logger.warn("ASM library is not available. Falling back to java.lang.reflect API.");
        }
        catch (NoSuchFieldException e) {
            logger.warn("--- xtext.common.types ---------------------------------------------------");
            logger.warn("ASM library is too old. Falling back to java.lang.reflect API.");
        }
        logger.warn("Please note that no information about compile time constants is available.");
        logger.warn("It's recommended to use org.objectweb.asm 5.0.1 or better.");
        logger.warn("--------------------------------------------------------------------------");
        return false;
    }

    @Override
    public JvmDeclaredType createType(BinaryClass binaryClass) {
        if (this.useASM) {
            try {
                this.createTypeTask.start();
                JvmDeclaredType jvmDeclaredType = this.doCreateType(binaryClass);
                return jvmDeclaredType;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.createTypeTask.stop();
            }
        }
        try {
            ReflectURIHelper uriHelper = new ReflectURIHelper();
            ReflectionTypeFactory reflectionBased = new ReflectionTypeFactory(uriHelper);
            Class<?> clazz = Class.forName(binaryClass.getName(), false, this.classLoader);
            return reflectionBased.createType(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected JvmDeclaredType doCreateType(BinaryClass binaryClass) {
        JvmDeclaredTypeBuilder builder = new JvmDeclaredTypeBuilder(binaryClass, this.bytesAccess, this.classLoader);
        return builder.buildType();
    }
}

