/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractRuntimeJvmTypeProvider
extends AbstractJvmTypeProvider {
    protected AbstractRuntimeJvmTypeProvider(ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        super(resourceSet, indexedJvmTypeAccess);
    }

    protected void registerProtocol(ResourceSet resourceSet) {
        super.registerProtocol(resourceSet);
        resourceSet.eAdapters().add(new TypeInResourceSetAdapter());
    }

    protected JvmType doTryFindInIndex(String name, boolean binaryNestedTypeDelimiter) {
        IndexedJvmTypeAccess indexAccess = this.getIndexedJvmTypeAccess();
        if (indexAccess != null) {
            JvmType result = this.doTryFindInIndex(name, indexAccess);
            if (result == null && !this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter)) {
                AbstractJvmTypeProvider.ClassNameVariants variants = new AbstractJvmTypeProvider.ClassNameVariants(name);
                while (result == null && variants.hasNext()) {
                    String nextVariant = (String)variants.next();
                    result = this.doTryFindInIndex(nextVariant, indexAccess);
                }
            }
            return result;
        }
        return null;
    }

    private JvmType doTryFindInIndex(String name, IndexedJvmTypeAccess indexAccess) {
        String qualifiedNameString;
        List<String> nameSegments;
        QualifiedName qualifiedName;
        EObject candidate;
        int index = name.indexOf(36);
        if (index < 0) {
            index = name.indexOf(91);
        }
        if ((candidate = indexAccess.getIndexedJvmType(qualifiedName = QualifiedName.create(nameSegments = Strings.split(qualifiedNameString = index < 0 ? name : name.substring(0, index), '.')), name, this.getResourceSet())) instanceof JvmType) {
            return (JvmType)candidate;
        }
        return null;
    }

    protected static class TypeInResourceSetAdapter
    extends AdapterImpl {
        private Map<String, JvmType> typeByQueryString = Maps.newHashMap();

        protected TypeInResourceSetAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return TypeInResourceSetAdapter.class.equals(type);
        }

        public JvmType tryFindTypeInIndex(String name, AbstractRuntimeJvmTypeProvider typeProvider, boolean binaryNestedTypeDelimiter) {
            JvmType result = this.typeByQueryString.get(name);
            if (result != null) {
                return result;
            }
            JvmType candidate = typeProvider.doTryFindInIndex(name, binaryNestedTypeDelimiter);
            if (candidate != null) {
                this.typeByQueryString.put(name, candidate);
                return candidate;
            }
            return null;
        }
    }
}

