/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;

public class WorkingSetTypePage
extends WizardPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private TableViewer typesListViewer;
    private WorkingSetDescriptor[] descriptors;

    public WorkingSetTypePage() {
        this(WorkbenchPlugin.getDefault().getWorkingSetRegistry().getNewPageWorkingSetDescriptors());
    }

    public WorkingSetTypePage(WorkingSetDescriptor[] descriptors) {
        super("workingSetTypeSelectionPage", WorkbenchMessages.WorkingSetTypePage_description, WorkbenchImages.getImageDescriptor("IMG_WIZBAN_WORKINGSET_WIZ"));
        this.descriptors = descriptors;
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(256));
        this.setControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, "org.eclipse.ui.working_set_type_page");
        Label typesLabel = new Label(composite, 0);
        typesLabel.setText(WorkbenchMessages.WorkingSetTypePage_typesLabel);
        GridData data = new GridData(768);
        typesLabel.setLayoutData(data);
        typesLabel.setFont(font);
        this.typesListViewer = new TableViewer(composite, 2052);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.typesListViewer.getTable().setLayoutData(data);
        this.typesListViewer.getTable().setFont(font);
        this.typesListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                WorkingSetTypePage.this.handleSelectionChanged();
            }
        });
        this.typesListViewer.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                WorkingSetTypePage.this.handleDoubleClick();
            }
        });
        this.typesListViewer.setContentProvider(new ArrayContentProvider());
        this.typesListViewer.setLabelProvider(new LabelProvider(){
            private ResourceManager images = new LocalResourceManager(JFaceResources.getResources());

            @Override
            public String getText(Object element) {
                return ((WorkingSetDescriptor)element).getName();
            }

            @Override
            public void dispose() {
                this.images.dispose();
                super.dispose();
            }

            @Override
            public Image getImage(Object element) {
                ImageDescriptor imageDescriptor = ((WorkingSetDescriptor)element).getIcon();
                return imageDescriptor == null ? null : (Image)this.images.get(imageDescriptor);
            }
        });
        this.typesListViewer.setInput(this.descriptors);
        this.setPageComplete(false);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public String getSelection() {
        WorkingSetDescriptor descriptor = this.getSelectedWorkingSet();
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    private WorkingSetDescriptor getSelectedWorkingSet() {
        ISelection selection = this.typesListViewer.getSelection();
        boolean hasSelection = selection != null && !selection.isEmpty();
        WorkingSetDescriptor descriptor = null;
        if (hasSelection && selection instanceof IStructuredSelection) {
            descriptor = (WorkingSetDescriptor)((IStructuredSelection)selection).getFirstElement();
        }
        return descriptor;
    }

    private void handleDoubleClick() {
        this.handleSelectionChanged();
        this.getContainer().showPage(this.getNextPage());
    }

    private void handleSelectionChanged() {
        ISelection selection = this.typesListViewer.getSelection();
        boolean hasSelection = selection != null && !selection.isEmpty();
        WorkingSetDescriptor descriptor = this.getSelectedWorkingSet();
        this.setDescription(descriptor == null ? "" : descriptor.getDescription());
        this.setPageComplete(hasSelection);
    }
}

