/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.misc.StringMatcher;

class BundlePatternFilter
extends ViewerFilter {
    private StringMatcher matcher;

    BundlePatternFilter() {
    }

    public void setPattern(String searchPattern) {
        if (searchPattern == null || searchPattern.length() == 0) {
            this.matcher = null;
        } else {
            String pattern = "*" + searchPattern + "*";
            this.matcher = new StringMatcher(pattern, true, false);
        }
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.matcher == null) {
            return true;
        }
        if (element instanceof AboutBundleData) {
            AboutBundleData data = (AboutBundleData)element;
            return this.matcher.match(data.getName()) || this.matcher.match(data.getProviderName()) || this.matcher.match(data.getId());
        }
        return true;
    }
}

