/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.GenericSpecification;

public class GenericConstraint
extends ResolverConstraint {
    private final boolean effective;
    private final boolean multiple;

    GenericConstraint(ResolverBundle bundle, GenericSpecification constraint) {
        super(bundle, constraint);
        String effectiveDirective = constraint.getRequirement().getDirectives().get("effective");
        this.effective = effectiveDirective == null || "resolve".equals(effectiveDirective);
        this.multiple = (constraint.getResolution() & 2) != 0;
    }

    @Override
    boolean isOptional() {
        return (((GenericSpecification)this.constraint).getResolution() & 1) != 0;
    }

    boolean isFromRequiredEE() {
        return (((GenericSpecification)this.constraint).getResolution() & 4) != 0;
    }

    boolean isMultiple() {
        return this.multiple;
    }

    boolean isEffective() {
        return this.effective;
    }

    public String getNameSpace() {
        return ((GenericSpecification)this.getVersionConstraint()).getType();
    }

    public VersionSupplier[] getMatchingCapabilities() {
        VersionSupplier[] versionSupplierArray;
        if (this.isMultiple()) {
            return this.getPossibleSuppliers();
        }
        VersionSupplier supplier = this.getSelectedSupplier();
        if (supplier == null) {
            versionSupplierArray = null;
        } else {
            VersionSupplier[] versionSupplierArray2 = new VersionSupplier[1];
            versionSupplierArray = versionSupplierArray2;
            versionSupplierArray2[0] = supplier;
        }
        return versionSupplierArray;
    }
}

