/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.ast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.internal.core.ast.AbstractASTBase;
import org.eclipse.emf.mwe.internal.core.ast.parser.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredPropertyFileAST
extends AbstractASTBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private String file;
    private Properties properties = null;
    private List<String> propertyNames = null;

    public DeclaredPropertyFileAST(Location location, String file) {
        super(location);
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public String toString() {
        return "<property file='" + this.file + "'/>";
    }

    public Properties getProperties(ResourceLoader loader) {
        if (this.properties == null) {
            InputStream in = loader.getResourceAsStream(this.getFile());
            if (in == null) {
                return null;
            }
            try {
                try {
                    this.properties = new Properties();
                    this.properties.load(in);
                    this.loadPropertyNames(loader.getResourceAsStream(this.getFile()));
                }
                catch (IOException e) {
                    this.log.error(e.getMessage(), e);
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        this.log.error(e2.getMessage(), e2);
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.log.error(e.getMessage(), e);
                }
            }
        }
        return this.properties;
    }

    public List<String> getPropertyNames(ResourceLoader loader) {
        this.getProperties(loader);
        return this.propertyNames;
    }

    public void setFile(String string) {
        this.file = string;
    }

    private synchronized void loadPropertyNames(InputStream inStream) throws IOException {
        this.propertyNames = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        String line;
        while ((line = in.readLine()) != null) {
            String key;
            int sep;
            if (line.length() <= 0 || (sep = line.indexOf(61)) == -1 || (key = line.substring(0, sep).trim()).length() <= 0 || key.indexOf(32) != -1 || key.indexOf(35) != -1 || key.indexOf(33) != -1) continue;
            this.propertyNames.add(key);
        }
        return;
    }
}

