/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.xtext;

import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.danieldietrich.protectedregions.core.IRegionParser;
import net.danieldietrich.protectedregions.core.RegionParserFactory;
import net.danieldietrich.protectedregions.support.IPathFilter;
import net.danieldietrich.protectedregions.support.IProtectedRegionSupport;
import net.danieldietrich.protectedregions.support.ProtectedRegionSupport;
import net.danieldietrich.protectedregions.xtext.BidiJavaIoFileSystemAccess;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProtectedRegionSupportTest {
    private TestGenerator testGenerator;
    private IRegionParser cssParser;
    private IRegionParser htmlParser;
    private IRegionParser javaParser;
    private IRegionParser jsParser;
    private IRegionParser phpParser;
    private IRegionParser xmlParser;

    @Before
    public void setup() {
        this.testGenerator = new TestGenerator();
        this.cssParser = RegionParserFactory.createCssParser();
        this.htmlParser = RegionParserFactory.createHtmlParser();
        this.javaParser = RegionParserFactory.createJavaParser();
        this.jsParser = RegionParserFactory.createJavaScriptParser();
        this.phpParser = RegionParserFactory.createPhpParser();
        this.xmlParser = RegionParserFactory.createXmlParser();
    }

    @Test
    public void mergeOfMultilanguageFilesShouldMatchExpected() throws Exception {
        ProtectedRegionSupport support = new ProtectedRegionSupport();
        support.addParser(this.htmlParser, ".html");
        support.addParser(this.phpParser, ".html");
        support.addParser(this.jsParser, ".html");
        support.addParser(this.cssParser, ".html");
        TestableBidiJavaIoFileSystemAccess fsa = new TestableBidiJavaIoFileSystemAccess(support);
        fsa.setFilter(new EndsWithFilter("multilang_previous.html"));
        fsa.setOutputPath("src/test/resources");
        this.testGenerator.doGenerate("src/test/resources/multilang_current.html", (IFileSystemAccess)fsa);
        String mergedContents = fsa.getSingleResult();
        String expectedContents = IOUtils.toString(new FileReader("src/test/resources/multilang_expected.html"));
        Assert.assertEquals(expectedContents, mergedContents);
    }

    @Test
    public void nonUniqueIdsShouldBeGloballyDetected() throws Exception {
        ProtectedRegionSupport support = new ProtectedRegionSupport();
        support.addParser(this.javaParser, ".java");
        TestableBidiJavaIoFileSystemAccess fsa = new TestableBidiJavaIoFileSystemAccess(support);
        fsa.setFilter(new PatternFilter(".*\\/duplicate_id_\\d.java"));
        try {
            fsa.setOutputPath("src/test/resources");
            Assert.assertTrue("Duplicate id not recognized", false);
        }
        catch (IllegalStateException x) {
            Assert.assertTrue("Other exception catched as expected: " + x.getMessage(), "Duplicate protected region id: 'duplicate'. Protected region ids have to be globally unique.".equals(x.getMessage()));
        }
    }

    @Test
    public void protectedRegionStartInStringLiteralShouldBeIgnored() throws Exception {
        ProtectedRegionSupport support = new ProtectedRegionSupport();
        support.addParser(this.javaParser, ".java");
        TestableBidiJavaIoFileSystemAccess fsa = new TestableBidiJavaIoFileSystemAccess(support);
        fsa.setFilter(new EndsWithFilter("string_literals_ignore_start.java"));
        try {
            fsa.setOutputPath("src/test/resources");
        }
        catch (IllegalStateException x) {
            Assert.assertTrue("Protected region start in string literal not ignored. Original message: " + x.getMessage(), false);
        }
    }

    @Test
    public void protectedRegionEndInStringLiteralShouldBeIgnored() throws Exception {
        ProtectedRegionSupport support = new ProtectedRegionSupport();
        support.addParser(this.javaParser, ".java");
        TestableBidiJavaIoFileSystemAccess fsa = new TestableBidiJavaIoFileSystemAccess(support);
        fsa.setFilter(new EndsWithFilter("string_literals_ignore_end.java"));
        try {
            fsa.setOutputPath("src/test/resources");
        }
        catch (IllegalStateException x) {
            Assert.assertTrue("Protected region end in string literal not ignored. Original message: " + x.getMessage(), false);
        }
    }

    @Test
    public void protectedRegionStartInXmlCDATAShouldBeIgnored() throws Exception {
        ProtectedRegionSupport support = new ProtectedRegionSupport();
        support.addParser(this.xmlParser, ".xml");
        TestableBidiJavaIoFileSystemAccess fsa = new TestableBidiJavaIoFileSystemAccess(support);
        fsa.setFilter(new EndsWithFilter("string_literals_ignore_cdata.xml"));
        try {
            fsa.setOutputPath("src/test/resources");
        }
        catch (IllegalStateException x) {
            Assert.assertTrue("Protected region end in xml CDATA not ignored. Original message: " + x.getMessage(), false);
        }
    }

    @Test
    public void commentsInStringLiteralsShouldBeIgnored() throws URISyntaxException {
        ProtectedRegionSupport support = new ProtectedRegionSupport();
        support.addParser(this.javaParser, ".java");
        TestableBidiJavaIoFileSystemAccess fsa = new TestableBidiJavaIoFileSystemAccess(support);
        fsa.setFilter(new EndsWithFilter("string_literals_ignore_comments.java"));
        try {
            fsa.setOutputPath("src/test/resources");
        }
        catch (IllegalStateException x) {
            Assert.assertTrue("Comments in string literals are not ignored. Original message: " + x.getMessage(), false);
        }
    }

    @Test
    public void ensureStringLiteralsParsedCorrectly() {
        ProtectedRegionSupport support = new ProtectedRegionSupport();
        support.addParser(this.javaParser, ".java");
        TestableBidiJavaIoFileSystemAccess fsa = new TestableBidiJavaIoFileSystemAccess(support);
        fsa.setFilter(new EndsWithFilter("ensure_str_literals_parsed_correctly.java"));
        fsa.setOutputPath("src/test/resources");
    }

    static class EndsWithFilter
    implements IPathFilter {
        private String name;

        EndsWithFilter(String name) {
            this.name = name;
        }

        public boolean accept(URI path) {
            return path.getPath().endsWith(this.name);
        }
    }

    static class PatternFilter
    implements IPathFilter {
        private final Pattern pattern;

        PatternFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public boolean accept(URI path) {
            return this.pattern.matcher(path.getPath()).matches();
        }
    }

    static class TestGenerator
    implements IGenerator {
        TestGenerator() {
        }

        public void doGenerate(Resource input, IFileSystemAccess fsa) {
            throw new IllegalStateException("Call #doGenerate(String, IFileSystemAccess) instead.");
        }

        public void doGenerate(String fileName, IFileSystemAccess fsa) throws IOException {
            String current = IOUtils.toString(new FileReader(fileName));
            fsa.generateFile(fileName, current);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestableBidiJavaIoFileSystemAccess
    extends BidiJavaIoFileSystemAccess {
        private Map<String, String> results = new HashMap<String, String>();

        public TestableBidiJavaIoFileSystemAccess(IProtectedRegionSupport support) {
            super(support);
        }

        @Override
        public void generateFile(String fileName, CharSequence contents) {
            String mergedContents = this.getSupport().mergeRegions(this, fileName, "DEFAULT_OUTPUT", contents).toString();
            this.results.put(fileName, mergedContents);
        }

        @Override
        public void generateFile(String fileName, String slot, CharSequence contents) {
            String mergedContents = this.getSupport().mergeRegions(this, fileName, slot, contents).toString();
            this.results.put(fileName, mergedContents);
        }

        public Map<String, String> getResults() {
            return this.results;
        }

        public String getSingleResult() {
            if (this.results.size() == 0) {
                throw new IllegalStateException("result is empty");
            }
            if (this.results.size() > 1) {
                throw new IllegalStateException("not a single result");
            }
            return this.results.values().iterator().next();
        }
    }
}

