/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.EclipseProjects;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.java.JavaDevice;
import fr.esrf.tango.pogo.generator.java.projects.IdeaProject;
import fr.esrf.tango.pogo.generator.java.projects.LinuxMakefile;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class JavaGenerator
implements IGenerator {
    @Inject
    private JavaDevice javaDevice;
    @Inject
    private LinuxMakefile linuxMakefile;
    @Inject
    private IdeaProject ideaProject;
    @Inject
    @Extension
    private EclipseProjects _eclipseProjects;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        this.javaDevice.doGenerate(resource, fsa);
        this.linuxMakefile.doGenerate(resource, fsa);
        this.ideaProject.doGenerate(resource, fsa);
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description_1;
            String _filestogenerate;
            String _lowerCase_1;
            boolean _contains;
            ClassDescription _description = cls.getDescription();
            String _language = _description.getLanguage();
            String _lowerCase = _language.toLowerCase();
            boolean _equals = _lowerCase.equals("java");
            if (!_equals || !(_contains = (_lowerCase_1 = (_filestogenerate = (_description_1 = cls.getDescription()).getFilestogenerate()).toLowerCase()).contains("eclipse"))) continue;
            StringUtils.printTrace("Generating Eclipse project");
            CharSequence _generateEclipseProject = this._eclipseProjects.generateEclipseProject(cls);
            fsa.generateFile(".project", _generateEclipseProject);
        }
    }
}

