/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.Headers;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.java.JavaTypeDefinitions;
import fr.esrf.tango.pogo.generator.java.JavaUtils;
import fr.esrf.tango.pogo.generator.java.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class JavaDynamicCommand {
    @Inject
    @Extension
    private JavaUtils _javaUtils;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private ProtectedArea _protectedArea;

    public CharSequence generateJavaDynamicCommandClassFile(PogoDeviceClass cls, Command command) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _header = this.header(cls, command);
        _builder.append((Object)_header, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Dynamic command ");
        String _name = command.getName();
        _builder.append((Object)_name, " ");
        _builder.append(", ");
        Argument _argin = command.getArgin();
        Type _type = _argin.getType();
        String _javaType = JavaTypeDefinitions.javaType(_type);
        _builder.append((Object)_javaType, " ");
        _builder.append(", ");
        Argument _argout = command.getArgout();
        Type _type_1 = _argout.getType();
        String _javaType_1 = JavaTypeDefinitions.javaType(_type_1);
        _builder.append((Object)_javaType_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* description:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*     ");
        String _description = command.getDescription();
        String _comments = StringUtils.comments(_description, "*     ");
        _builder.append((Object)_comments, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = command.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(" implements ICommandBehavior {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**\tThe command name */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String  commandName;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        String _name_2 = command.getName();
        String _plus = String.valueOf(_name_2) + ".";
        String _plus_1 = String.valueOf(_plus) + "dataMembers";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1, "Put your data member declarations", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _constructor = this.constructor(cls, command);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _configurationMethod = this.getConfigurationMethod(cls, command);
        _builder.append((Object)_configurationMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _stateMachineMethod = this.stateMachineMethod(cls, command);
        _builder.append((Object)_stateMachineMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _executeMethod = this.executeMethod(cls, command);
        _builder.append((Object)_executeMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        String _name_3 = command.getName();
        String _plus_2 = String.valueOf(_name_3) + ".";
        String _plus_3 = String.valueOf(_plus_2) + "methods";
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, _plus_3, "Put your own methods", true);
        _builder.append((Object)_protectedArea_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence header(PogoDeviceClass cls, Command command) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = command.getName();
        String _plus = String.valueOf(_name) + ".java";
        String _openProtectedArea = this._protectedArea.openProtectedArea(cls, _plus);
        _builder.append((Object)_openProtectedArea, "");
        _builder.newLineIfNotEmpty();
        String _name_1 = command.getName();
        String _plus_1 = String.valueOf(_name_1) + ".java";
        String _name_2 = command.getName();
        String _plus_2 = "Java source for the dynamic command " + _name_2;
        String _plus_3 = String.valueOf(_plus_2) + ".\n";
        String _plus_4 = String.valueOf(_plus_3) + "this command belongs to the ";
        String _name_3 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_3;
        String _plus_6 = String.valueOf(_plus_5) + " class.";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        String _fileHeader = this._headers.fileHeader(_plus_1, _plus_6, _title, _license, _copyright);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_4 = command.getName();
        String _plus_7 = String.valueOf(_name_4) + ".java";
        String _closeProtectedArea = this._protectedArea.closeProtectedArea(cls, _plus_7);
        _builder.append((Object)_closeProtectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("package ");
        String _javaDevicePackage = this._javaUtils.javaDevicePackage(cls);
        _builder.append((Object)_javaDevicePackage, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.tango.DeviceState;");
        _builder.newLine();
        _builder.append("import fr.esrf.TangoDs.TangoConst;");
        _builder.newLine();
        _builder.append("import org.tango.server.StateMachineBehavior;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("//\tImport Tango IDL types");
        _builder.newLine();
        _builder.append("import fr.esrf.Tango.*;");
        _builder.newLine();
        _builder.append("import org.tango.server.command.CommandConfiguration;");
        _builder.newLine();
        _builder.append("import org.tango.server.command.ICommandBehavior;");
        _builder.newLine();
        _builder.newLine();
        String _name_5 = command.getName();
        String _plus_8 = String.valueOf(_name_5) + ".";
        String _plus_9 = String.valueOf(_plus_8) + "addImports";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_9);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence constructor(PogoDeviceClass cls, Command command) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Dynamic command ");
        String _name = command.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" constructor");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @param commandName The dynamic command name");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name_1 = command.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("(String commandName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this.commandName = commandName;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getConfigurationMethod(PogoDeviceClass cls, Command command) {
        String _polledPeriod_1;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Build and return the configuration for dynamic command ");
        String _name = command.getName();
        _builder.append((Object)_name, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return the configuration for dynamic command ");
        String _name_1 = command.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @throws DevFailed in case of configuration error.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public CommandConfiguration getConfiguration() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CommandConfiguration  config = new CommandConfiguration();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("config.setName(commandName);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("config.setInTangoType(");
        Argument _argin = command.getArgin();
        Type _type = _argin.getType();
        String _javaTypeConstants = JavaTypeDefinitions.javaTypeConstants(_type);
        _builder.append((Object)_javaTypeConstants, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("config.setInTypeDesc(\"");
        Argument _argin_1 = command.getArgin();
        String _description = _argin_1.getDescription();
        String _oneLineString = this._javaUtils.oneLineString(_description);
        _builder.append((Object)_oneLineString, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("config.setOutTangoType(");
        Argument _argout = command.getArgout();
        Type _type_1 = _argout.getType();
        String _javaTypeConstants_1 = JavaTypeDefinitions.javaTypeConstants(_type_1);
        _builder.append((Object)_javaTypeConstants_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("config.setOutTypeDesc(\"");
        Argument _argout_1 = command.getArgout();
        String _description_1 = _argout_1.getDescription();
        String _oneLineString_1 = this._javaUtils.oneLineString(_description_1);
        _builder.append((Object)_oneLineString_1, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("config.setDispLevel(DispLevel.");
        String _displayLevel = command.getDisplayLevel();
        _builder.append((Object)_displayLevel, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        String _polledPeriod = command.getPolledPeriod();
        boolean bl = _notEquals = !Objects.equal(_polledPeriod, null);
        _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal(_polledPeriod_1 = command.getPolledPeriod(), "0"));
        if (_and) {
            _builder.append("\t");
            _builder.append("config.setPolled(true);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("config.setPollingPeriod(");
            String _polledPeriod_2 = command.getPolledPeriod();
            _builder.append((Object)_polledPeriod_2, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return config;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence stateMachineMethod(PogoDeviceClass cls, Command command) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Get dynamic command state machine");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the command state machine");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if the state machine computation failed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public StateMachineBehavior getStateMachine() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("StateMachineBehavior stateMachine = new StateMachineBehavior();");
        _builder.newLine();
        _builder.append("\t");
        String _stateMachineForDynamic = this._javaUtils.stateMachineForDynamic(command);
        _builder.append((Object)_stateMachineForDynamic, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name = command.getName();
        String _plus = String.valueOf(_name) + ".";
        String _plus_1 = String.valueOf(_plus) + "getStateMachine";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return stateMachine;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence executeMethod(PogoDeviceClass cls, Command command) {
        boolean _equals_5;
        Argument _argout;
        Type _type_1;
        String _javaType_1;
        boolean _equals_2;
        boolean _equals_3;
        boolean _equals_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Execute the dynamic command ");
        String _name = command.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        Argument _argin = command.getArgin();
        Type _type = _argin.getType();
        String _javaType = JavaTypeDefinitions.javaType(_type);
        boolean _equals = _javaType.equals("void");
        boolean bl = _equals_1 = !_equals;
        if (_equals_1) {
            _builder.append("* @param argIn ");
            Argument _argin_1 = command.getArgin();
            String _description = _argin_1.getDescription();
            String _comments = StringUtils.comments(_description, "*              ");
            _builder.append((Object)_comments, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _equals_3 = !(_equals_2 = (_javaType_1 = JavaTypeDefinitions.javaType(_type_1 = (_argout = command.getArgout()).getType())).equals("void"));
        if (_equals_3) {
            _builder.append("* @return  ");
            Argument _argout_1 = command.getArgout();
            String _description_1 = _argout_1.getDescription();
            String _comments_1 = StringUtils.comments(_description_1, "*          ");
            _builder.append((Object)_comments_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(" ");
        _builder.append("* @throws DevFailed if the command execution failed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public Object execute(Object argIn) throws DevFailed {");
        _builder.newLine();
        Argument _argout_2 = command.getArgout();
        Type _type_2 = _argout_2.getType();
        String _javaType_2 = JavaTypeDefinitions.javaType(_type_2);
        boolean _equals_4 = _javaType_2.equals("void");
        boolean bl3 = _equals_5 = !_equals_4;
        if (_equals_5) {
            _builder.append("\t");
            Argument _argout_3 = command.getArgout();
            Type _type_3 = _argout_3.getType();
            String _javaType_3 = JavaTypeDefinitions.javaType(_type_3);
            _builder.append((Object)_javaType_3, "\t");
            _builder.append("\targOut;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name_1 = command.getName();
            String _plus = String.valueOf(_name_1) + ".";
            String _plus_1 = String.valueOf(_plus) + "execute";
            String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1);
            _builder.append((Object)_protectedArea, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return argOut;");
            _builder.newLine();
        } else {
            _builder.append("\t");
            String _name_2 = command.getName();
            String _plus_2 = String.valueOf(_name_2) + ".";
            String _plus_3 = String.valueOf(_plus_2) + "execute";
            String _protectedArea_1 = this._protectedArea.protectedArea(cls, _plus_3);
            _builder.append((Object)_protectedArea_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return null;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

