/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.internal.http.HttpConnection;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.RequestLine;
import com.squareup.okhttp.internal.http.Response;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.Transport;
import com.squareup.okhttp.internal.okio.Sink;
import com.squareup.okhttp.internal.okio.Source;
import java.io.IOException;
import java.net.CacheRequest;

public final class HttpTransport
implements Transport {
    private final HttpEngine httpEngine;
    private final HttpConnection httpConnection;

    public HttpTransport(HttpEngine httpEngine, HttpConnection httpConnection) {
        this.httpEngine = httpEngine;
        this.httpConnection = httpConnection;
    }

    @Override
    public Sink createRequestBody(Request request) throws IOException {
        long contentLength = OkHeaders.contentLength(request);
        if (this.httpEngine.bufferRequestBody) {
            if (contentLength > Integer.MAX_VALUE) {
                throw new IllegalStateException("Use setFixedLengthStreamingMode() or setChunkedStreamingMode() for requests larger than 2 GiB.");
            }
            if (contentLength != -1L) {
                this.writeRequestHeaders(request);
                return new RetryableSink((int)contentLength);
            }
            return new RetryableSink();
        }
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            this.writeRequestHeaders(request);
            return this.httpConnection.newChunkedSink();
        }
        if (contentLength != -1L) {
            this.writeRequestHeaders(request);
            return this.httpConnection.newFixedLengthSink(contentLength);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void flushRequest() throws IOException {
        this.httpConnection.flush();
    }

    @Override
    public void writeRequestBody(RetryableSink requestBody) throws IOException {
        this.httpConnection.writeRequestBody(requestBody);
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        this.httpEngine.writingRequestHeaders();
        String requestLine = RequestLine.get(request, this.httpEngine.getConnection().getRoute().getProxy().type(), this.httpEngine.getConnection().getHttpMinorVersion());
        this.httpConnection.writeRequest(request.getHeaders(), requestLine);
    }

    @Override
    public Response.Builder readResponseHeaders() throws IOException {
        return this.httpConnection.readResponse();
    }

    @Override
    public void releaseConnectionOnIdle() throws IOException {
        if (this.canReuseConnection()) {
            this.httpConnection.poolOnIdle();
        } else {
            this.httpConnection.closeOnIdle();
        }
    }

    @Override
    public boolean canReuseConnection() {
        if ("close".equalsIgnoreCase(this.httpEngine.getRequest().header("Connection"))) {
            return false;
        }
        if ("close".equalsIgnoreCase(this.httpEngine.getResponse().header("Connection"))) {
            return false;
        }
        return !this.httpConnection.isClosed();
    }

    @Override
    public void emptyTransferStream() throws IOException {
        this.httpConnection.emptyResponseBody();
    }

    @Override
    public Source getTransferStream(CacheRequest cacheRequest) throws IOException {
        if (!this.httpEngine.hasResponseBody()) {
            return this.httpConnection.newFixedLengthSource(cacheRequest, 0L);
        }
        if ("chunked".equalsIgnoreCase(this.httpEngine.getResponse().header("Transfer-Encoding"))) {
            return this.httpConnection.newChunkedSource(cacheRequest, this.httpEngine);
        }
        long contentLength = OkHeaders.contentLength(this.httpEngine.getResponse());
        if (contentLength != -1L) {
            return this.httpConnection.newFixedLengthSource(cacheRequest, contentLength);
        }
        return this.httpConnection.newUnknownLengthSource(cacheRequest);
    }

    @Override
    public void disconnect(HttpEngine engine) throws IOException {
        this.httpConnection.closeIfOwnedBy(engine);
    }
}

