/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class CppStateMachine
extends PogoGene
implements PogoDefs {
    public CppStateMachine(PogoClass pogo) {
        super(pogo);
    }

    void generateSource(String template, String src_filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String method;
        int start;
        String signature;
        int i;
        PogoString readcode;
        if (CppStateMachine.mustGenerate(src_filename)) {
            readcode = new PogoString(PogoUtil.readFile(template, "TemplateDevServ", this.pogo.class_name));
            readcode = PogoUtil.removeLogMessages(readcode);
        } else {
            readcode = new PogoString(PogoUtil.readFile(src_filename));
        }
        for (i = 0; i < this.pogo.attributes.size(); ++i) {
            Attrib attr = this.pogo.attributes.attributeAt(i);
            signature = attr.allowedSignatureMethod(this.pogo.class_name);
            if (readcode.indexOf(signature) >= 0) continue;
            signature = attr.allowedFullSignatureMethod(this.pogo.class_name);
            start = readcode.indexOf("Commands Allowed Methods");
            start = readcode.lastIndexOf("//============", start);
            method = signature;
            method = method + "\n{\n\t\t//\tEnd of Generated Code\n";
            method = method + "\n\t\t//\tRe-Start of Generated Code\n";
            method = method + "\treturn true;\n}\n";
            readcode.insert(--start, method);
        }
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method || readcode.indexOf(signature = cmd.allowedSignatureMethod(this.pogo.class_name)) >= 0) continue;
            signature = cmd.allowedFullSignatureMethod(this.pogo.class_name);
            start = readcode.indexOf("\n}\t// namespace");
            method = signature;
            method = method + "\n{\n\t\t//\tEnd of Generated Code\n";
            method = method + "\n\t\t//\tRe-Start of Generated Code\n";
            method = method + "\treturn true;\n}\n";
            readcode.insert(start, method);
        }
        String newcode = this.updateAllowedMethods(readcode);
        PogoUtil.writeFile(src_filename, newcode);
    }

    private String updateAllowedMethods(PogoString readcode) {
        String newmethod;
        String test;
        String user_part;
        String method;
        int start;
        String signature;
        int i;
        for (i = 0; i < this.pogo.attributes.size(); ++i) {
            Attrib attr = this.pogo.attributes.attributeAt(i);
            signature = attr.allowedFullSignatureMethod(this.pogo.class_name);
            start = readcode.indexOf(signature);
            method = readcode.extractMethodCore(start);
            user_part = this.getAllowedUserPart(method);
            method = signature + "\n{" + method + "}";
            test = attr.allowedCore();
            newmethod = signature + "\n";
            if (test != null) {
                newmethod = newmethod + test + user_part + "\n";
                newmethod = newmethod + "\t\treturn false;\n";
                newmethod = newmethod + "\t}\n\treturn true;\n}";
                readcode.replace(method, newmethod);
            } else {
                newmethod = newmethod + "{\n\t\t//\t" + user_part + "\n";
                newmethod = newmethod + "\treturn true;\n}";
                readcode.replace(method, newmethod);
            }
            readcode.replace(method, newmethod);
        }
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            signature = cmd.allowedFullSignatureMethod(this.pogo.class_name);
            start = readcode.indexOf(signature);
            method = readcode.extractMethodCore(start);
            user_part = this.getAllowedUserPart(method);
            method = signature + "\n{" + method + "}";
            test = cmd.allowedCore();
            newmethod = signature + "\n";
            if (test != null) {
                if (this.pogo.deviceImpl < 3) {
                    user_part = this.getAllowedUserPart(cmd);
                }
                newmethod = newmethod + test + user_part + "\n";
                newmethod = newmethod + "\t\treturn false;\n";
                newmethod = newmethod + "\t}\n\treturn true;\n}";
            } else {
                newmethod = newmethod + "{\n\t\t//\t" + user_part + "\n";
                newmethod = newmethod + "\treturn true;\n}";
                readcode.replace(method, newmethod);
            }
            readcode.replace(method, newmethod);
        }
        String newcode = this.removeDeletedAttrCmdAllowedMethods(readcode);
        this.removeOldAllowedMethods();
        return newcode;
    }

    private String removeDeletedAttrCmdAllowedMethods(PogoString code) {
        String start_signature = "bool " + this.pogo.class_name + "::is_";
        int start = 0;
        while ((start = code.indexOf(start_signature, start)) > 0) {
            int i;
            int end = code.indexOf("_allowed(", start);
            if (end < 0) {
                ++start;
                continue;
            }
            String name = code.substring(start + start_signature.length(), end);
            boolean still_exists = false;
            for (i = 0; i < this.pogo.commands.size(); ++i) {
                if (!this.pogo.commands.cmdAt(i).toString().equals(name)) continue;
                still_exists = true;
            }
            for (i = 0; i < this.pogo.attributes.size(); ++i) {
                if (!this.pogo.attributes.attributeAt(i).toString().equals(name)) continue;
                still_exists = true;
            }
            if (!still_exists) {
                end = code.inMethod(end);
                end = code.outMethod(end);
                start = code.lastIndexOf("//+-------", start);
                String method = code.substring(start, end);
                code.remove(method);
            }
            start = end;
        }
        return code.str;
    }

    private void removeOldAllowedMethods() {
        String filename = this.pogo.projectFiles.getServerClass();
        try {
            PogoString readcode = new PogoString(PogoUtil.readFile(filename));
            for (int i = 0; i < this.pogo.commands.size(); ++i) {
                String patern;
                int start;
                Cmd cmd = this.pogo.commands.cmdAt(i);
                if (cmd.virtual_method || (start = readcode.indexOf(patern = cmd.cmd_class + "::is_allowed")) < 0) continue;
                start = readcode.lastIndexOf("}", start);
                int end = readcode.inMethod(start);
                end = readcode.outMethod(end);
                end = readcode.nextCr(end);
                end = readcode.indexOf("//", end);
                start = readcode.lastIndexOf("//+-------", start);
                String method = readcode.substring(start, end);
                readcode.remove(method);
            }
            PogoUtil.writeFile(filename, readcode.str);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private String getAllowedUserPart(String method) {
        int idx0 = method.indexOf("End of Generated Code");
        int idx1 = method.indexOf("Re-Start of Generated Code");
        return method.substring(idx0, idx1 += "Re-Start of Generated Code".length());
    }

    private String getAllowedUserPart(Cmd cmd) {
        System.out.println("getAllowedUserPart for " + cmd);
        String filename = this.pogo.projectFiles.getServerClass();
        try {
            PogoString readcode = new PogoString(PogoUtil.readFile(filename));
            String signature = "bool " + cmd.name + "Cmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)";
            int start = readcode.indexOf(signature);
            if (start > 0) {
                start = readcode.inMethod(start);
                int end = readcode.outMethod(start);
                String method = readcode.substring(start, end);
                return this.getAllowedUserPart(method);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return "End of Generated Code\n\n\t\t//\tRe-Start of Generated Code\n";
    }
}

