/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.appli.PogoAppliDefs;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGeneCpp;
import pogo.gene.PogoGeneDoc;
import pogo.gene.PogoGeneJava;
import pogo.gene.PogoGenePython;

public class PogoCmdLine
implements PogoAppliDefs,
PogoDefs {
    private Vector<String> sourcefiles = new Vector();
    private int action = -1;
    private PogoClass server = null;
    private static final int NOT_INITIALIZED = -1;
    private static final int HELP = 2;
    private static final String[] known_actions = new String[]{"-src", "-doc", "-?"};

    public PogoCmdLine(String[] args) throws PogoException, FileNotFoundException, SecurityException, IOException, InterruptedException {
        this.manageArgs(args);
        switch (this.action) {
            case 0: {
                for (String s : this.sourcefiles) {
                    this.server = new PogoClass(s);
                    switch (this.server.language) {
                        case 1: {
                            new PogoGeneCpp(this.server).generate(this.action);
                            break;
                        }
                        case 0: {
                            new PogoGeneJava(this.server).generate(this.action);
                            break;
                        }
                        case 2: {
                            new PogoGenePython(this.server).generate();
                        }
                    }
                }
                System.exit(0);
                break;
            }
            case 1: {
                for (String s : this.sourcefiles) {
                    this.server = new PogoClass(s);
                    new PogoGeneDoc(this.server).generate();
                }
                System.exit(0);
                break;
            }
            case 2: {
                this.displaySyntax();
                break;
            }
            default: {
                System.setProperty("POGO_FILE", args[0]);
            }
        }
    }

    private void manageArgs(String[] args) throws PogoException {
        for (int i = 0; i < args.length; ++i) {
            boolean found = false;
            for (int j = 0; !found && j < known_actions.length; ++j) {
                found = args[i].equals(known_actions[j]);
                if (!found) continue;
                this.action = j;
            }
            if (found) continue;
            this.sourcefiles.add(args[i]);
        }
        if (this.action != -1) {
            System.out.println("action: " + known_actions[this.action]);
        }
        System.out.print("sourcefiles: ");
        for (String s : this.sourcefiles) {
            System.out.println("\t" + s);
        }
    }

    private void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("pogo <action> <filename1> <filename2>....");
        System.out.println();
        System.out.println("Without option, pogo start the Graphic User Interface");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\t-src:\twill re-generate the device server source files.");
        System.out.println("\t-doc:\twill generate the device server documentation.");
        System.out.println();
        System.exit(0);
    }
}

