/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.DbPollPanel;
import admin.astor.HostInfoDialog;
import admin.astor.ManagePollingDialog;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.PollingProfiler;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class ServerPopupMenu
extends JPopupMenu
implements AstorDefs {
    private TangoHost host;
    private TangoServer server;
    private JFrame frame;
    private HostInfoDialog parent;
    private static String[] pMenuLabels = new String[]{"Start server", "Restart server", "Set startup level", "Polling Manager", "Polling Profiler", "Configure (Wizard)", "DB Attribute Properties", "Server Info", "Class  Info", "Test   Device", "Check  States", "Start daemon", "Standard Error"};
    private static final int OFFSET = 2;
    private static final int START_STOP = 0;
    private static final int RESTART = 1;
    private static final int STARTUP_LEVEL = 2;
    private static final int POLLING_MANAGER = 3;
    private static final int POLLING_PROFILER = 4;
    private static final int CONFIGURE = 5;
    private static final int DB_ATTRIBUTES = 6;
    private static final int SERVER_INFO = 7;
    private static final int CLASS_INFO = 8;
    private static final int TEST_DEVICE = 9;
    private static final int CHECK_STATES = 10;
    private static final int START_DAEMON = 11;
    private static final int STD_ERROR = 12;
    private boolean running;
    private Point location;

    public ServerPopupMenu(JFrame frame, HostInfoDialog parent, TangoHost host) {
        this.frame = frame;
        this.parent = parent;
        this.host = host;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel title = new JLabel("Server Control :");
        title.setFont(new Font("Dialog", 1, 16));
        this.add(title);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < pMenuLabels.length; ++i) {
            JMenuItem btn = new JMenuItem(pMenuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ServerPopupMenu.this.serverCmdActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt, int host_state) {
        Object o = evt.getSource();
        if (!(o instanceof JLabel) || this.isVisible()) {
            this.setVisible(false);
            return;
        }
        JLabel btn = (JLabel)evt.getSource();
        String name = btn.getText();
        JLabel lbl = (JLabel)this.getComponent(0);
        lbl.setText("  " + name + "  :");
        if (name.startsWith("Events")) {
            this.server = null;
            for (int i = 0; i < pMenuLabels.length; ++i) {
                this.getComponent(i + 2).setVisible(false);
            }
            this.getComponent(13).setVisible(true);
            this.getComponent(14).setVisible(false);
            boolean running = this.host.notifyd_state == 3;
            this.getComponent(13).setEnabled(!running);
        } else {
            boolean running;
            this.server = this.host.getServer(btn.getText());
            for (int i = 0; i < pMenuLabels.length; ++i) {
                this.getComponent(i + 2).setVisible(true);
            }
            this.getComponent(13).setVisible(false);
            JMenuItem mi = (JMenuItem)this.getComponent(2);
            boolean bl = running = this.server.getState() == DevState.ON;
            if (running || this.server.getState() == DevState.MOVING) {
                mi.setText("Kill  Server");
            } else {
                mi.setText("Start Server");
            }
            this.getComponent(3).setEnabled(running);
            this.getComponent(6).setEnabled(running);
            this.getComponent(11).setEnabled(running);
            this.getComponent(12).setEnabled(running);
            this.getComponent(7).setEnabled(running);
            this.getComponent(8).setVisible(!running);
        }
        this.location = btn.getLocationOnScreen();
        this.show(btn, evt.getX(), evt.getY());
    }

    private void serverCmdActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = 0;
        for (int i = 0; i < pMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        switch (cmdidx) {
            case 2: {
                if (!this.server.startupLevel(this.parent, this.host.getName(), this.location)) break;
                this.parent.updateData();
                break;
            }
            case 3: {
                if (this.server.getState() == DevState.ON) {
                    new ManagePollingDialog(this.parent, this.server).setVisible(true);
                    break;
                }
                new DbPollPanel(this.parent, this.server.getName()).setVisible(true);
                break;
            }
            case 4: {
                this.startPollingProfiler();
                break;
            }
            case 9: {
                this.server.testDevice(this.parent, this.location);
                break;
            }
            case 10: {
                this.server.checkStates(this.parent, this.location);
                break;
            }
            case 5: {
                this.server.configureWithWizard(this.parent);
                break;
            }
            case 7: {
                this.server.displayServerInfo(this.parent);
                break;
            }
            case 6: {
                this.server.manageMemorizedAttributes(this.parent);
                break;
            }
            case 8: {
                this.server.displayClassInfo(this.frame);
                break;
            }
            case 12: {
                if (this.server != null) {
                    this.host.readStdErrorFile(this.frame, this.server.getName());
                    break;
                }
                this.host.readStdErrorFile(this.frame, "notify_daemon/" + this.host.getName());
                break;
            }
            case 11: {
                this.host.startServer(this.parent, "notify_daemon/" + this.host.getName());
                break;
            }
            case 1: {
                this.server.restart(this.parent, this.host);
                break;
            }
            case 0: {
                if (this.server.getState() == DevState.ON || this.server.getState() == DevState.MOVING) {
                    try {
                        if (JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to kill " + this.server.getName(), "Confirm Dialog", 0) != 0) {
                            return;
                        }
                        this.host.stopServer(this.server.getName());
                    }
                    catch (DevFailed e) {
                        if (e.errors[0].reason.equals("SERVER_NOT_RESPONDING")) {
                            try {
                                if (JOptionPane.showConfirmDialog(this.parent, e.errors[0].desc + "\n" + "Do you even want to kill it ?", "Confirm Dialog", 0) != 0) {
                                    return;
                                }
                                this.host.hardKillServer(this.server.getName());
                            }
                            catch (DevFailed e2) {
                                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e2);
                            }
                            break;
                        }
                        ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
                    }
                    break;
                }
                this.host.startServer(this.parent, this.server.getName());
            }
        }
    }

    private void startPollingProfiler() {
        try {
            String[] devnames = this.server.queryDevice();
            new PollingProfiler((JDialog)this.parent, devnames).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }
}

