/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.HostInfoDialog;
import admin.astor.HostInfoDialogVector;
import admin.astor.HostStateThread;
import admin.astor.Monitor;
import admin.astor.RemoteLoginThread;
import admin.astor.RenameDialog;
import admin.astor.TangoHost;
import admin.astor.TreePopupMenu;
import app_util.PopupError;
import app_util.PopupMessage;
import app_util.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.MainPanel;

public class AstorTree
extends JTree
implements AstorDefs {
    private Astor parent;
    public TangoHost[] hosts;
    private TangoHost selected_host = null;
    private DbaseObject selected_db = null;
    private DbaseObject[] dbase;
    private DefaultTreeModel treeModel;
    private Timer watchDogTimer;
    private MainPanel jive = null;
    private jive3.MainPanel jive3 = null;
    private TreePopupMenu pMenu;
    private DbPopupMenu dbMenu;
    HostInfoDialogVector hostDialogs = null;
    static String[] collec_names;
    private static Monitor monitor;
    private static int host_subscribed;
    private static Vector hosts_using_evt;
    private static DefaultMutableTreeNode[] leaf;
    private static DefaultMutableTreeNode[] collection;
    String start_host_err = "";
    private boolean jive_is_read_only = false;

    public AstorTree(Astor parent, boolean polling) throws DevFailed {
        this.parent = parent;
        this.initComponent();
        String message = "";
        if (this.hosts.length > 0) {
            message = this.hosts[0].getName();
        }
        host_subscribed = 0;
        monitor = new Monitor(parent, "Subscribing events", message);
        hosts_using_evt = new Vector();
        for (int i = 0; i < this.hosts.length; ++i) {
            this.hosts[i].do_polling = false;
            if (polling) {
                this.hosts[i].setPolling(null);
            }
            if (this.hosts[i].use_events) {
                hosts_using_evt.add(this.hosts[i]);
            }
            this.hosts[i].thread = new HostStateThread(this, this.hosts[i]);
            this.hosts[i].thread.start();
        }
        new subscribeThread().start();
        this.updateMonitor(null);
        this.pMenu = new TreePopupMenu(parent, this);
        this.dbMenu = new DbPopupMenu(this);
        this.hostDialogs = new HostInfoDialogVector();
        this.expandRow(1);
        int delay = 10000;
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AstorTree.this.watchDog(evt);
            }
        };
        this.watchDogTimer = new Timer(delay, taskPerformer);
        this.watchDogTimer.start();
    }

    private void watchDog(ActionEvent evt) {
    }

    void updateMonitor(String strerror) {
        if (strerror != null) {
            this.start_host_err = this.start_host_err + strerror + "\n\n";
        }
        if (host_subscribed >= hosts_using_evt.size()) {
            monitor.setProgressValue(1.0, "");
            if (this.start_host_err.length() > 0) {
                PopupMessage.show((Component)this, this.start_host_err);
            }
            return;
        }
        TangoHost host = (TangoHost)((Object)hosts_using_evt.elementAt(host_subscribed));
        String message = "For  " + host.getName() + "  (" + (host_subscribed + 1) + "/" + hosts_using_evt.size() + ")";
        double ratio = (double)(host_subscribed + 1) / (double)(hosts_using_evt.size() + 1);
        if (Astor.displayed) {
            monitor.setProgressValue(ratio, message);
        }
        ++host_subscribed;
    }

    void stopThreads() {
        this.watchDogTimer.stop();
        for (int i = 0; i < this.hosts.length; ++i) {
            this.hosts[i].stopThread();
        }
    }

    void expand(boolean expand) {
        if (expand) {
            for (int i = 0; i < this.hosts.length + collec_names.length + 1; ++i) {
                this.expandRow(i);
            }
        } else {
            for (int i = 1; i <= collec_names.length; ++i) {
                this.collapseRow(i);
            }
        }
    }

    private void initComponent() throws DevFailed {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("TANGO Control System");
        this.initTangoObjects();
        this.createNodes(root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AstorTree.this.hostSelectionPerformed(e);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                AstorTree.this.collapsedPerfomed(e);
            }

            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AstorTree.this.treeMouseClicked(evt);
            }
        });
        this.setExpandsSelectedPaths(true);
    }

    private void initTangoObjects() throws DevFailed {
        String tango_hosts = AstorUtil.getTangoHost();
        StringTokenizer stk = tango_hosts.indexOf(",") > 0 ? new StringTokenizer(tango_hosts, ",") : new StringTokenizer(tango_hosts);
        Vector<String> vector = new Vector<String>();
        while (stk.hasMoreTokens()) {
            vector.add(stk.nextToken());
        }
        this.dbase = new DbaseObject[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.dbase[i] = new DbaseObject(this, (String)vector.elementAt(i));
        }
        AstorUtil au = AstorUtil.getInstance();
        this.hosts = au.getTangoHostList();
        collec_names = au.getCollectionList(this.hosts);
    }

    private void createNodes(DefaultMutableTreeNode root) {
        int i;
        collection = new DefaultMutableTreeNode[collec_names.length];
        for (i = 0; i < collec_names.length; ++i) {
            AstorTree.collection[i] = new DefaultMutableTreeNode(collec_names[i]);
            root.add(collection[i]);
        }
        for (i = 0; i < this.dbase.length; ++i) {
            collection[0].add(new DefaultMutableTreeNode(this.dbase[i]));
        }
        leaf = new DefaultMutableTreeNode[this.hosts.length];
        for (i = 0; i < this.hosts.length; ++i) {
            DefaultMutableTreeNode host = new DefaultMutableTreeNode((Object)this.hosts[i]);
            this.hosts[i].state = 0;
            int idx = this.getHostCollection(this.hosts[i]);
            collection[idx].add(host);
            AstorTree.leaf[i] = host;
        }
    }

    int getHostCollection(TangoHost host) {
        for (int i = 0; i < collec_names.length; ++i) {
            if (host.collection == null) {
                return collec_names.length - 1;
            }
            if (!host.collection.equals(collec_names[i])) continue;
            return i;
        }
        return collec_names.length - 1;
    }

    public void collapsedPerfomed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        if (path.getPathCount() > 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        if (path.getPathCount() == 1 || node == collection[0]) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(0);
            Object[] leaf_path = leaf.getPath();
            this.setExpandedState(new TreePath(leaf_path), true);
            if (path.getPathCount() == 1) {
                String message = "TANGO Control System\n\n";
                message = message + this.hosts.length + " hosts controled.\n";
                int nb_on_events = 0;
                for (int i = 0; i < this.hosts.length; ++i) {
                    if (!this.hosts[i].use_events) continue;
                    ++nb_on_events;
                }
                if (nb_on_events == this.hosts.length) {
                    message = message + "All are controled on events.";
                } else if (nb_on_events > 0) {
                    message = message + nb_on_events + " are controled on events.";
                }
                PopupMessage.showImage((Component)this.parent, message, "/app_util/img/tango_icon.jpg");
            }
        }
    }

    private Rectangle computeBounds(TreePath selPath) {
        this.scrollPathToVisible(selPath);
        Rectangle r = this.getPathBounds(selPath);
        Point p = r.getLocation();
        SwingUtilities.convertPointToScreen(p, this);
        r.setLocation(p);
        r.width += 20;
        r.height += 2;
        return r;
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        return node.getUserObject();
    }

    void changeNodeName() {
        Rectangle r = this.computeBounds(this.getSelectionPath());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        RenameDialog dlg = new RenameDialog((Frame)this.parent, node.toString(), r);
        if (dlg.showDlg()) {
            String new_name = dlg.getNewName();
            try {
                DefaultMutableTreeNode n2 = node;
                int nb = n2.getChildCount();
                for (int i = 0; i < nb; ++i) {
                    n2 = n2.getNextNode();
                    TangoHost th = (TangoHost)((Object)n2.getUserObject());
                    th.setCollection(new_name);
                }
            }
            catch (DevFailed e) {
                PopupError.show((Component)this.parent, e);
                return;
            }
            node.setUserObject(new_name);
        }
    }

    void addBranch(String name) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        model.insertNodeInto(node, root, root.getChildCount());
    }

    void moveNode(DefaultMutableTreeNode host_node) {
        DefaultMutableTreeNode old_collec = (DefaultMutableTreeNode)host_node.getParent();
        DefaultMutableTreeNode new_collec = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        try {
            TangoHost host = (TangoHost)((Object)host_node.getUserObject());
            host.setCollection((String)new_collec.getUserObject());
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.removeNodeFromParent(host_node);
        model.insertNodeInto(host_node, new_collec, 0);
        if (old_collec.getChildCount() == 0) {
            model.removeNodeFromParent(old_collec);
        }
        this.scrollPathToVisible(new TreePath(host_node.getPath()));
    }

    public void hostSelectionPerformed(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (node.isLeaf()) {
            if (obj instanceof TangoHost) {
                this.selected_host = (TangoHost)((Object)obj);
                this.selected_db = null;
            } else if (obj instanceof DbaseObject) {
                this.selected_host = null;
                this.selected_db = (DbaseObject)obj;
            } else {
                this.selected_host = null;
                this.selected_db = null;
            }
        } else {
            this.selected_host = null;
            this.selected_db = null;
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.setSelectionPath(selectedPath);
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2) {
            if ((mask & 0x10) != 0) {
                if (this.selected_host != null) {
                    this.displayHostInfo();
                } else {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
                    Object o = node.getUserObject();
                    if (this.selected_db != null || o.toString().equals(collec_names[0])) {
                        this.displayJiveAppli();
                    }
                }
            }
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            Object obj = node.getUserObject();
            if ((mask & 4) != 0) {
                if (obj instanceof DbaseObject) {
                    this.dbMenu.showMenu(evt);
                } else {
                    this.pMenu.showMenu(evt);
                }
            }
        }
    }

    public void setSelectionPath(String hostname) {
        for (int i = 0; i < leaf.length; ++i) {
            String leafname = leaf[i].getUserObject().toString();
            int start = leafname.indexOf("(");
            if (start > 0) {
                leafname = leafname.substring(0, start).trim();
            }
            if (!leafname.equals(hostname)) continue;
            TreePath path = new TreePath(leaf[i].getPath());
            this.setSelectionPath(path);
            return;
        }
        this.setSelectionRow(0);
    }

    void displayJiveAppli() {
        if (this.selected_db != null && this.selected_db.state == 1) {
            PopupError.show((Component)this.parent, this.selected_db.except);
        } else {
            boolean from_shell = false;
            boolean read_only = AstorUtil.getInstance().jiveIsReadOnly();
            if (this.jive_is_read_only != read_only || this.jive == null && this.jive3 == null) {
                try {
                    this.jive3 = new jive3.MainPanel(from_shell, read_only);
                }
                catch (NoClassDefFoundError e) {
                    e.printStackTrace();
                    this.jive = new MainPanel(from_shell, read_only);
                }
            }
            if (this.jive3 != null) {
                this.jive3.setVisible(true);
                this.jive3.toFront();
            } else if (this.jive != null) {
                this.jive.setVisible(true);
                this.jive.toFront();
            }
            this.jive_is_read_only = read_only;
        }
    }

    void changeHostNode(TangoHost h) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        int pos = 0;
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            if (!parent_node.getChildAt(i).equals(node)) continue;
            pos = i;
        }
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode((Object)h);
        this.treeModel.insertNodeInto(new_node, parent_node, pos);
        this.treeModel.removeNodeFromParent(node);
        Object[] path = new_node.getPath();
        this.setSelectionPath(new TreePath(path));
    }

    public void displayHostInfo(String devname) {
        try {
            String hostname = new IORdump(devname).get_host();
            if (hostname == null) {
                Except.throw_exception((String)"UNKNOWN_HOST", (String)"May be this device has never been exported !", (String)"");
            }
            StringTokenizer st = new StringTokenizer(hostname);
            hostname = st.nextToken();
            st = new StringTokenizer(hostname, ".");
            hostname = st.nextToken();
            this.parent.setVisible(true);
            this.setSelectionPath(hostname);
            this.displayHostInfo();
            String servname = new DeviceProxy(devname).adm_name();
            servname = servname.substring(servname.indexOf(47) + 1);
            HostInfoDialog dlg = this.hostDialogs.getByHostName(this.selected_host);
            dlg.setSelection(servname);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    public void displayHostInfo() {
        if (this.selected_host == null) {
            PopupError.show((Component)this, "this Host is not controled by Astor !");
            return;
        }
        if (!this.selected_host.do_polling) {
            this.selected_host.do_polling = true;
            this.selected_host.updateData();
            this.sleep(1000);
        }
        if (this.selected_host.state == 1 && this.selected_host.except != null) {
            String reason = this.selected_host.except.errors[0].reason;
            String desc = this.selected_host.except.errors[0].desc;
            if (reason.equals("TangoApi_DEVICE_NOT_EXPORTED") || desc.indexOf("CORBA.TRANSIENT: Retries exceeded,") > 0) {
                if (JOptionPane.showConfirmDialog(this.parent, "Starter is not running on " + (Object)((Object)this.selected_host) + "\n\n\n" + "Do you want a remote login to start it ?", "Dialog", 0) == 0) {
                    new RemoteLoginThread(this.selected_host.getName(), this.parent).start();
                }
            } else {
                PopupError.show((Component)this.parent, "Starter on " + (Object)((Object)this.selected_host), this.selected_host.except);
            }
        } else if (this.selected_host.state == 0) {
            PopupMessage.show((Component)this.parent, "Connection with Starter device server is blocked !");
        } else {
            this.hostDialogs.add(this.parent, this.selected_host);
        }
    }

    void displayBranchInfo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        String str = node + ":\n\n";
        int nb = node.getChildCount();
        for (int i = 0; i < nb; ++i) {
            node = node.getNextNode();
            TangoHost host = (TangoHost)((Object)node.getUserObject());
            str = str + host.hostStatus();
        }
        PopupMessage.show((Component)this.parent, str);
    }

    public void updateState() {
        this.repaint();
        if (this.hostDialogs != null) {
            for (int i = 0; i < this.hosts.length; ++i) {
                if (this.hosts[i].state != 1) continue;
                this.hostDialogs.close(this.hosts[i]);
            }
        }
    }

    private synchronized void sleep(int ms) {
        try {
            this.wait(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        host_subscribed = 0;
    }

    class DbPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private final String[] menuLabels = new String[]{"Server Info", "Database Info"};
        private final int OFFSET = 2;
        private final int SERVER_INFO = 0;
        private final int DATABASE_INFO = 1;

        DbPopupMenu(JTree tree) {
            this.tree = tree;
            JLabel title = new JLabel("Datbase Server :");
            title.setFont(new Font("Dialog", 1, 16));
            this.add(title);
            this.add(new JPopupMenu.Separator());
            for (int i = 0; i < this.menuLabels.length; ++i) {
                JMenuItem btn = new JMenuItem(this.menuLabels[i]);
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        DbPopupMenu.this.treeActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt) {
            Object obj = AstorTree.this.getSelectedObject();
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText(obj.toString() + "  :");
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void treeActionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != src) continue;
                cmdidx = i;
            }
            Object obj = AstorTree.this.getSelectedObject();
            DbaseObject db = (DbaseObject)obj;
            PopupText ppt = new PopupText((Frame)AstorTree.this.parent, true);
            ppt.setFont(new Font("helvetica", 1, 14));
            try {
                switch (cmdidx) {
                    case 0: {
                        ppt.show(db.getServerInfo());
                        break;
                    }
                    case 1: {
                        ppt.show(db.getInfo());
                    }
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    class subscribeThread
    extends Thread {
        subscribeThread() {
        }

        public void run() {
            long t0 = System.currentTimeMillis();
            int nb_subscribed = 0;
            for (int i = 0; i < AstorTree.this.hosts.length; ++i) {
                if (!AstorTree.this.hosts[i].use_events) continue;
                AstorTree.this.hosts[i].thread.subscribeChangeStateEvent();
                ++nb_subscribed;
            }
            long t1 = System.currentTimeMillis();
            System.out.println("Total time to subscribe on " + nb_subscribed + " hosts : " + (t1 - t0) + " ms");
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon;
        private ImageIcon dbIcon = new ImageIcon(this.getClass().getResource("/app_util/img/MySql.jpg"));
        private Font[] fonts;

        public TangoRenderer() {
            this.tangoIcon = new ImageIcon(this.getClass().getResource("/app_util/img/TangoSmall.gif"));
            this.fonts = new Font[2];
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setForeground(Color.black);
            if (row == 0) {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.tangoIcon);
                this.setFont(this.fonts[0]);
            } else if (this.isDatabase(obj)) {
                if (leaf) {
                    this.setBackgroundSelectionColor(Color.lightGray);
                    DbaseObject db = this.getDbase(obj);
                    this.setIcon(Astor.state_icons[db.state]);
                    this.setFont(this.fonts[1]);
                } else {
                    this.setBackgroundSelectionColor(Color.white);
                    int state = 3;
                    for (int i = 0; i < AstorTree.this.dbase.length; ++i) {
                        if (((AstorTree)AstorTree.this).dbase[i].state != 1) continue;
                        state = 1;
                    }
                    if (state == 1) {
                        this.setForeground(Color.red);
                    }
                    this.setIcon(this.dbIcon);
                    this.setFont(this.fonts[0]);
                }
            } else if (this.isHost(obj)) {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[1]);
                this.setBackgroundNonSelectionColor(Color.white);
                TangoHost host = this.getHost(obj);
                int state = host.state;
                if (state == 0 && host.do_polling) {
                    state = 5;
                }
                this.setIcon(Astor.state_icons[state]);
            } else {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[0]);
                int state = this.branchState(obj);
                this.setIcon(Astor.state_icons[state]);
            }
            return this;
        }

        protected int branchState(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            int nb = node.getChildCount();
            TangoHost[] th = new TangoHost[nb];
            for (int i = 0; i < nb; ++i) {
                node = node.getNextNode();
                th[i] = (TangoHost)((Object)node.getUserObject());
            }
            boolean is_faulty = false;
            boolean is_alarm = false;
            boolean is_unknown = false;
            boolean is_moving = false;
            for (int i = 0; i < nb; ++i) {
                if (th[i].do_polling) {
                    if (th[i].state == 0) {
                        return 0;
                    }
                    if (th[i].state == 1) {
                        is_faulty = true;
                        continue;
                    }
                    if (th[i].state == 2) {
                        is_alarm = true;
                        continue;
                    }
                    if (th[i].state != 4) continue;
                    is_moving = true;
                    continue;
                }
                is_unknown = true;
            }
            int state = is_unknown ? 0 : (is_faulty ? 1 : (is_moving ? 4 : (is_alarm ? 2 : 3)));
            return state;
        }

        protected boolean isHost(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            return obj instanceof TangoHost;
        }

        protected TangoHost getHost(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            if (obj instanceof TangoHost) {
                return (TangoHost)((Object)obj);
            }
            return null;
        }

        protected DbaseObject getDbase(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            if (obj instanceof DbaseObject) {
                return (DbaseObject)obj;
            }
            return null;
        }

        protected boolean isDatabase(Object tree_node) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node;
            Object obj = node.getUserObject();
            if (obj instanceof DbaseObject) {
                return true;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                return str.equals(collec_names[0]);
            }
            return false;
        }
    }
}

