/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;
import pogo.gene.PropertyTable;

public class CppServer
extends PogoGene
implements PogoDefs,
TangoConst {
    private PropertyTable properties;
    private static String readprop_method_name = "get_device_property";
    private String readprop_method_signature;
    private String init_signature;
    private String classname;
    private String cpp_flag_dev_impl_2 = "#ifdef DEV_IMPL_2\n";

    public CppServer(PogoClass pogo) {
        super(pogo);
        this.classname = pogo.class_name;
        this.properties = pogo.dev_properties;
        this.init_signature = "void " + this.classname + "::" + "init_device";
        this.readprop_method_signature = "void " + this.classname + "::" + readprop_method_name + "()";
    }

    private String addPropertyDataMembers(PogoString readcode) throws PogoException {
        String tagStr = "Device properties member data.";
        int start = readcode.str.indexOf(tagStr);
        if (start < 0) {
            start = readcode.str.indexOf("Attribute member data.");
            if (start < 0 && (start = readcode.str.indexOf("Attributs member data.")) < 0) {
                throw new PogoException("Tags not found in header file");
            }
            start = readcode.inMethod(start) + 1;
            start = readcode.outMethod(start) + 1;
            String sb = "/**\n";
            sb = sb + " * @name Device properties\n";
            sb = sb + " * " + tagStr + "\n */\n";
            sb = sb + "//@{\n//@}\n\n";
            readcode.insert(start, sb);
        }
        start = readcode.inMethod(start) + 2;
        int end = readcode.str.indexOf("//@}", start);
        String old = readcode.str.substring(start, end);
        String sb = "";
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = this.properties.propertyAt(i);
            sb = sb + "/**\n";
            sb = sb + " *\t" + new PogoString(property.description).setComments() + "\n";
            sb = sb + " */\n";
            String type = property.type.cpp;
            if (type.equals("Tango::DevString")) {
                type = "string";
            }
            sb = sb + "\t" + type + "\t" + property.getVarName() + ";\n";
        }
        if (old.length() > 0) {
            readcode.replace(start, old, sb);
        } else {
            readcode.insert(start, sb);
        }
        if (readcode.str.indexOf(readprop_method_name) < 0) {
            start = readcode.str.indexOf("Here is the end of the automatic");
            while (readcode.str.charAt(start) != '}') {
                --start;
            }
            start = readcode.previousCr(start);
            sb = "";
            sb = sb + "/**\n";
            sb = sb + " *\tRead the device properties from database\n";
            sb = sb + " */\n";
            sb = sb + "\t void " + readprop_method_name + "();\n";
            readcode.insert(start, sb);
        }
        return readcode.toString();
    }

    protected String addPrototypes(PogoString readcode) throws PogoException {
        Cmd cmd;
        Attrib attr;
        int i;
        String newcode = "";
        int start = -1;
        for (int i2 = 1; start < 0 && i2 < PogoUtil.cpp_target.length; ++i2) {
            start = readcode.str.indexOf(PogoUtil.cpp_target[i2]);
        }
        if (start < 0 && (start = readcode.str.indexOf(": public " + this.pogo.inheritedNamespace() + "::" + this.pogo.inheritedClassName())) < 0) {
            System.out.println("Do not found\n: public " + this.pogo.inheritedNamespace() + "::" + this.pogo.inheritedClassName());
            throw new PogoException("Input File Syntax error !", "\"public Tango::Device_3Impl\" NOT FOUND");
        }
        while (start > 0 && readcode.str.charAt(start) != '\n') {
            --start;
        }
        String header = this.setProjectTitle(readcode.str.substring(0, start));
        int end = header.indexOf("Class Description:");
        if (end > 0) {
            end = header.indexOf(" * ", end) + 3;
            newcode = newcode + header.substring(0, end);
        } else {
            newcode = newcode + header;
            newcode = newcode + "\n/**\n * Class Description:\n * ";
        }
        if (this.pogo.class_desc != null) {
            newcode = newcode + new PogoString(this.pogo.class_desc).setComments();
        }
        newcode = newcode + "\n */\n";
        newcode = newcode + "\n/*\n";
        newcode = newcode + this.pogo.states.toStringComments(1);
        newcode = newcode + " */\n\n";
        end = readcode.str.indexOf("//@{");
        if (end < 0) {
            throw new PogoException("Input File Syntax error !", "tag:  \"//@{\"   NOT FOUND");
        }
        while (readcode.str.charAt(end) != '\n') {
            ++end;
        }
        newcode = newcode + readcode.str.substring(start, ++end);
        for (int i3 = 0; i3 < this.pogo.attributes.size(); ++i3) {
            Attrib attr2 = this.pogo.attributes.attributeAt(i3);
            newcode = newcode + attr2.cppMemberData();
        }
        String start_proto = "/**\n * @name " + this.pogo.class_name + " methods prototypes\n */\n\n//@{\n";
        start = readcode.str.indexOf("//@}", end);
        end = readcode.str.indexOf("always_executed_hook");
        if (end < 0) {
            if (this.pogo.is_abstractclass) {
                end = readcode.str.indexOf(start_proto);
                if (end < 0) {
                    throw new PogoException("Input File Syntax error !", "\"" + start_proto + "\" NOT FOUND");
                }
            } else {
                throw new PogoException("Input File Syntax error !", "\"always_executed_hook\" NOT FOUND");
            }
        }
        newcode = newcode + readcode.str.substring(start, end);
        if (!this.pogo.is_abstractclass) {
            newcode = newcode + readcode.str.substring(end, readcode.str.indexOf("\n", end) + 1);
            newcode = newcode + "\n//@}\n\n";
        }
        newcode = newcode + start_proto;
        if (this.pogo.attributes.size() > 0) {
            String sig = this.pogo.attributes.readHardwareFullSignatureMethod(null);
            newcode = newcode + sig + ";\n";
        }
        for (i = 0; i < this.pogo.attributes.size(); ++i) {
            attr = this.pogo.attributes.attributeAt(i);
            newcode = newcode + attr.readFullSignatureMethod(null) + ";\n";
            if (!attr.getWritable()) continue;
            newcode = newcode + attr.writeFullSignatureMethod(null) + ";\n";
        }
        for (i = 0; i < this.pogo.attributes.size(); ++i) {
            attr = this.pogo.attributes.attributeAt(i);
            newcode = newcode + attr.allowedFullSignatureMethod(null) + ";\n";
        }
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            newcode = newcode + cmd.allowedFullSignatureMethod(null) + ";\n";
        }
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method && (!cmd.virtual_method || cmd.override_method == 0)) continue;
            newcode = newcode + cmd.buildCppCmdProtypes();
        }
        newcode = newcode + "\n//@}\n";
        for (start = readcode.str.indexOf("Here is the end of the automatic"); start > 0 && readcode.str.charAt(start) != '\n'; --start) {
        }
        if (start < 0) {
            throw new PogoException("Input File Syntax error !\n\"//@}\" tag NOT FOUND");
        }
        newcode = newcode + readcode.str.substring(start);
        return newcode;
    }

    private String toAbstractClassHeader(String str) {
        int end;
        PogoString code = new PogoString(str);
        String start_proto = "/**\n * @name " + this.pogo.class_name + " methods prototypes\n */\n\n//@{\n";
        int start = code.str.indexOf("/**@name Destructor");
        if (start > 0) {
            end = code.str.indexOf(start_proto, start);
            if (end < 0) {
                System.out.println("WARNING: " + start_proto + "  Not Found !!!");
                return str;
            }
            code.remove(code.str.substring(start, end));
        }
        if ((start = code.str.indexOf("void get_device_property();")) > 0) {
            end = code.str.indexOf("//@}", start);
            start = code.str.lastIndexOf("/**", start);
            code.remove(code.str.substring(start, end));
        }
        Vector<String> old_lines = new Vector<String>();
        Vector<String> new_lines = new Vector<String>();
        start = code.str.indexOf(start_proto) + start_proto.length();
        if ((start = code.str.indexOf("/**", start)) < 0) {
            return code.str;
        }
        end = code.str.indexOf("//@}", start);
        while (start < end) {
            String old_line;
            String new_line;
            int end_line = code.str.indexOf("/**", start = code.str.indexOf("*/", start) + "*/".length());
            if (end_line < 0) {
                end_line = end;
            }
            if (!(new_line = (old_line = code.str.substring(start, end_line).trim())).startsWith("virtual ")) {
                new_line = "virtual " + new_line;
            }
            if (new_line.indexOf("_allowed(") < 0) {
                if (new_line.indexOf("0") < 0) {
                    new_line = new_line.substring(0, new_line.length() - 1) + " = 0;";
                }
            } else if (new_line.indexOf("return true;") < 0) {
                new_line = new_line.substring(0, new_line.length() - 1) + "{ return true; };";
            }
            old_lines.add(old_line);
            new_lines.add(new_line);
            start = end_line;
        }
        for (int i = 0; i < old_lines.size(); ++i) {
            code.replace((String)old_lines.elementAt(i), (String)new_lines.elementAt(i));
        }
        return code.str;
    }

    private PogoString udateConstructorPrototypes(PogoString readcode) {
        String[] old_constr = new String[]{this.pogo.class_name + "(Tango::DeviceClass *,string &)", this.pogo.class_name + "(Tango::DeviceClass *,const char *)", this.pogo.class_name + "(Tango::DeviceClass *,const char *,const char *)"};
        String[] new_constr = new String[]{this.pogo.class_name + "(Tango::DeviceClass *cl,string &s)", this.pogo.class_name + "(Tango::DeviceClass *cl,const char *s)", this.pogo.class_name + "(Tango::DeviceClass *cl,const char *s,const char *d)"};
        for (int i = 0; i < old_constr.length; ++i) {
            readcode.replace(old_constr[i], new_constr[i]);
        }
        if (this.pogo.is_abstractclass) {
            String from_class = "Device_3Impl";
            if (this.pogo.inherited_from != null) {
                from_class = this.pogo.inheritedClassName();
            }
            String[] sc_ext = new String[]{":" + from_class + "(cl,s) {}", ":" + from_class + "(cl,s) {}", ":" + from_class + "(cl,s,d) {}"};
            for (int i = 0; i < new_constr.length; ++i) {
                int pos = readcode.str.indexOf(new_constr[i]);
                if (pos <= 0 || readcode.str.substring(pos += new_constr[i].length()).trim().charAt(0) != ';') continue;
                readcode.insert(pos, sc_ext[i]);
            }
        }
        return readcode;
    }

    public void generateHeader(String server_h) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String filename;
        System.out.println("Generating " + server_h + "....");
        boolean from_template = false;
        if (CppServer.already_exists(server_h)) {
            filename = server_h;
        } else {
            from_template = true;
            filename = this.pogo.templates_dir + "/cpp/" + "DevServ" + ".h";
        }
        PogoString readcode = new PogoString(PogoUtil.readFile(filename, "TemplateDevServ", this.pogo.class_name));
        if (from_template) {
            readcode = PogoUtil.removeLogMessages(readcode);
            while (readcode.str.indexOf("TemplateDevServ".toUpperCase()) >= 0) {
                readcode.replace("TemplateDevServ".toUpperCase(), this.pogo.class_name.toUpperCase());
            }
        } else {
            while (readcode.str.indexOf("public DeviceImpl") >= 0) {
                System.out.println("Replacing DeviceImpl by Device_3Impl");
                readcode.replace("DeviceImpl", "public Device_3Impl");
            }
            while (readcode.str.indexOf("public Device_2Impl") >= 0) {
                System.out.println("Replacing Device_2Impl by Device_3Impl");
                readcode.replace("public Device_2Impl", "public Device_3Impl");
            }
        }
        if (this.pogo.inherited_from != null && !this.pogo.inherited_from.equals("Device_3Impl")) {
            String inheritance = ": public " + this.pogo.inheritedNamespace() + "::" + this.pogo.inheritedClassName() + "\t//\t" + PogoUtil.cpp_target[0] + "Device_3Impl";
            readcode.replace(PogoUtil.cpp_target[1], inheritance);
            String sc_header = "<" + this.pogo.inheritedClassName() + ".h>";
            if (readcode.str.indexOf(sc_header) < 0) {
                int pos = readcode.str.indexOf("<tango.h>");
                pos = readcode.nextCr(pos) + 1;
                readcode.insert(pos, "#include " + sc_header + "\n");
            }
        }
        readcode = this.udateConstructorPrototypes(readcode);
        String newcode = this.addPrototypes(readcode);
        newcode = this.addPropertyDataMembers(new PogoString(newcode));
        if (this.pogo.is_abstractclass) {
            newcode = this.toAbstractClassHeader(newcode);
        }
        PogoUtil.writeFile(server_h, newcode);
    }

    public void generateSource(String server) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int namespace;
        System.out.println("Generating " + server + "....");
        boolean src_exist = CppServer.already_exists(server);
        String filename = src_exist ? server : this.pogo.templates_dir + "/cpp/" + "DevServ" + ".cpp";
        PogoString readcode = new PogoString(PogoUtil.readFile(filename, "TemplateDevServ", this.pogo.class_name));
        if (src_exist) {
            while (readcode.str.indexOf("DeviceImpl(cl") >= 0) {
                System.out.println("Replacing DeviceImpl by Device_2Impl");
                readcode.replace("DeviceImpl(cl", "Device_2Impl(cl");
            }
            while (readcode.str.indexOf("Device_2Impl(cl") >= 0) {
                System.out.println("Replacing Device_2Impl by Device_3Impl");
                readcode.replace("Device_2Impl(cl", "Device_3Impl(cl");
            }
            String target = "<" + this.pogo.class_name + "Class.h>";
            int start = readcode.str.indexOf("<" + this.pogo.class_name + ".h>");
            if (readcode.str.indexOf(target, start = readcode.nextCr(start) + 1) < 0) {
                readcode.insert(start, "#include " + target + "\n");
            }
        } else {
            readcode = PogoUtil.removeLogMessages(readcode);
        }
        if (this.pogo.inherited_from != null && !this.pogo.inherited_from.equals("Device_3Impl")) {
            String inheritance = ":" + this.pogo.inheritedNamespace() + "::" + this.pogo.inheritedClassName();
            String target = ":Tango::Device_3Impl";
            while (readcode.str.indexOf(target) > 0) {
                readcode.replace(target, inheritance);
            }
        }
        if ((namespace = readcode.indexOf("namespace " + this.pogo.namespace())) < 0) {
            namespace = readcode.indexOf("namespace " + this.pogo.class_name);
        }
        namespace = readcode.indexOf("{", namespace);
        PogoString header = new PogoString(readcode.str.substring(0, namespace));
        readcode = new PogoString(readcode.str.substring(namespace));
        int start = header.indexOf("The following table gives the correspondence");
        if (start < 0) {
            start = header.indexOf("The following table gives the correspondance");
        }
        if (start < 0) {
            start = header.indexOf("The folowing table gives the correspondance");
        }
        int end = header.indexOf("//==========================", start);
        start = header.lastIndexOf("//==========", start);
        end = header.nextCr(end);
        String old = header.substring(start, end);
        header.replace(old, this.pogo.commands.addCommentsTable());
        String newcode = this.addMethodsToExecuteCmd(readcode.str);
        if (src_exist) {
            newcode = this.checkForExecMethodModif(new PogoString(newcode), 1);
        }
        if (this.pogo.attributes.size() > 0) {
            newcode = this.buildAttributesMethods(new PogoString(newcode));
        }
        if (this.properties.size() > 0) {
            newcode = this.addReadPropMethod(new PogoString(newcode));
        }
        String finalcode = header.str + newcode;
        PogoUtil.writeFile(server, finalcode);
    }

    void comment_read_write_attr_methods(PogoString code, String classname) {
        int end;
        String pattern = "void " + classname + "::read_attr(Tango::Attribute &attr)";
        int start = code.str.indexOf(pattern);
        if (start > 0) {
            end = code.inMethod(start);
            end = code.outMethod(end);
            code.insert(end, "#endif\n");
            code.insert(start, this.cpp_flag_dev_impl_2);
        }
        if ((start = code.str.indexOf(pattern = "void " + classname + "::write_attr_hardware(vector<long> &attr_list)")) > 0) {
            end = code.inMethod(start);
            end = code.outMethod(end);
            code.insert(end, "#endif\n");
            code.insert(start, this.cpp_flag_dev_impl_2);
        }
    }

    private String buildAttributesMethods(PogoString code) {
        int insert_pos = code.indexOf(this.pogo.class_name + "::always_executed_hook()");
        insert_pos = code.inMethod(insert_pos);
        insert_pos = code.outMethod(insert_pos);
        String signature = this.pogo.attributes.readHardwareSignatureMethod(this.pogo.class_name);
        int start = code.indexOf(signature);
        if (start < 0) {
            String method = this.pogo.attributes.readHardwareFullSignatureMethod(this.pogo.class_name);
            method = method + "\n{\n" + PogoUtil.enteringTrace(signature) + "\t//\tAdd your own code here\n" + "}\n\n";
            code.insert(insert_pos, method);
            insert_pos += method.length();
        } else {
            insert_pos = code.inMethod(start);
            insert_pos = code.outMethod(insert_pos);
        }
        for (int i = 0; i < this.pogo.attributes.size(); ++i) {
            String method;
            Attrib attr = this.pogo.attributes.attributeAt(i);
            signature = attr.readSignatureMethod(this.pogo.class_name);
            if (code.indexOf(signature) < 0) {
                method = attr.readFullSignatureMethod(this.pogo.class_name);
                method = method + "\n{\n" + PogoUtil.enteringTrace(signature);
                method = method + attr.getDevImpl2ReadAttr(code, this.pogo.class_name);
                method = method + "}\n\n";
                code.insert(insert_pos, method);
                insert_pos += method.length();
            }
            if (!attr.getWritable() || code.indexOf(signature = attr.writeSignatureMethod(this.pogo.class_name)) >= 0) continue;
            method = attr.writeFullSignatureMethod(this.pogo.class_name);
            method = method + "\n{\n" + PogoUtil.enteringTrace(signature);
            method = method + attr.getDevImpl2WriteAttr(code, this.pogo.class_name);
            method = method + "}\n\n";
            code.insert(insert_pos, method);
            insert_pos += method.length();
        }
        this.comment_read_write_attr_methods(code, this.pogo.class_name);
        return code.str;
    }

    protected String addMethodsToExecuteCmd(String readcode) throws PogoException {
        StringBuffer newcode = new StringBuffer();
        int start = 0;
        int end = readcode.lastIndexOf(125);
        newcode.append(readcode.substring(start, end));
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            int sl;
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method && cmd.override_method != 1) continue;
            String line = cmd.buildCppExecCmdMethodSignature(this.pogo.class_name);
            int el = line.indexOf(" ", sl = line.indexOf("("));
            if (el < 0) {
                el = sl + 1;
            }
            if (readcode.indexOf(line = line.substring(0, el)) >= 0) continue;
            newcode.append("\n");
            newcode.append(cmd.buildCppExecCmdMethodComments(this.pogo.class_name));
            newcode.append(cmd.buildCppExecCmdMethod(this.pogo.class_name));
            if (!cmd.virtual_method) continue;
            cmd.override_method = 2;
        }
        newcode.append("\n}\t//\tnamespace\n");
        return newcode.toString();
    }

    private String addReadPropMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException, PogoException {
        Property property;
        int i;
        String pattern;
        if (this.properties.size() == 0) {
            return readcode.str;
        }
        String templatefile = this.pogo.templates_dir + "/cpp/readPropMethodName.cpp";
        PogoString method = new PogoString(PogoUtil.readFile(templatefile, "TemplateDevServ", this.pogo.class_name));
        while (method.str.indexOf("target") >= 0) {
            method.replace("target", "device");
        }
        String template_method = method.str;
        int start = readcode.str.indexOf(this.readprop_method_signature);
        if (start < 0) {
            start = readcode.str.indexOf(this.init_signature);
            if (start < 0) {
                throw new PogoException("Syntax error in existing Source file", this.init_signature + " not found ");
            }
            start = readcode.inMethod(start);
            start = readcode.outMethod(start) + 1;
            readcode.insert(start, template_method);
        }
        if ((start = readcode.str.indexOf(pattern = "Automatic code generation", start)) <= 0) {
            throw new PogoException("Syntax error in existing Source file", "\"" + pattern + "\"  Not Found");
        }
        start = readcode.nextCr(start) + 1;
        int end = readcode.str.indexOf(pattern, start = readcode.nextCr(start) + 1);
        if (end < 0) {
            throw new PogoException("Syntax error in existing Source file", "\"" + pattern + "\"  Not Found");
        }
        end = readcode.previousCr(end) - 1;
        String oldCode = readcode.str.substring(start, end);
        String sb = "\tTango::DbData\tdev_prop;\n";
        for (i = 0; i < this.properties.size(); ++i) {
            property = this.properties.propertyAt(i);
            sb = sb + "\tdev_prop.push_back(Tango::DbDatum(\"" + property.name + "\"));\n";
        }
        sb = sb + "\n";
        sb = sb + "\t//\tCall database and extract values\n";
        sb = sb + "\t//--------------------------------------------\n";
        sb = sb + "\tif (Tango::Util::instance()->_UseDb==true)\n";
        sb = sb + "\t\tget_db_device()->get_property(dev_prop);\n";
        sb = sb + "\tTango::DbDatum\tdef_prop, cl_prop;\n";
        sb = sb + "\t" + this.classname + "Class\t*ds_class =\n";
        sb = sb + "\t\t(static_cast<" + this.classname + "Class *>(get_device_class()));\n";
        sb = sb + "\tint\ti = -1;\n\n";
        for (i = 0; i < this.properties.size(); ++i) {
            property = this.properties.propertyAt(i);
            sb = sb + "\t//\tTry to initialize " + property + " from class property\n";
            sb = sb + "\tcl_prop = ds_class->get_class_property(dev_prop[++i].name);\n";
            sb = sb + "\tif (cl_prop.is_empty()==false)\tcl_prop  >>  " + property.getVarName() + ";\n";
            sb = sb + "\telse {\n";
            sb = sb + "\t\t//\tTry to initialize " + property + " from default device value\n";
            sb = sb + "\t\tdef_prop = ds_class->get_default_device_property(dev_prop[i].name);\n";
            sb = sb + "\t\tif (def_prop.is_empty()==false)\tdef_prop  >>  " + property.getVarName() + ";\n";
            sb = sb + "\t}\n";
            sb = sb + "\t//\tAnd try to extract " + property + " value from database\n";
            sb = sb + "\tif (dev_prop[i].is_empty()==false)\tdev_prop[i]  >>  " + property.getVarName() + ";\n";
            sb = sb + "\n";
        }
        sb = sb + "\n";
        readcode.replace(start, oldCode, sb);
        this.addReadPropMethodCall(readcode);
        return readcode.str;
    }

    private void addReadPropMethodCall(PogoString readcode) throws PogoException {
        int end;
        int start = readcode.str.indexOf(this.init_signature);
        if (start < 0) {
            throw new PogoException("Syntax error in existing Source file");
        }
        String meth_core = readcode.str.substring(start = readcode.inMethod(start), end = readcode.outMethod(start));
        if (meth_core.indexOf(readprop_method_name) >= 0) {
            return;
        }
        start = readcode.str.indexOf("Initialise variables to default values", start);
        start = readcode.nextCr(start) + 1;
        start = readcode.nextCr(start) + 1;
        readcode.insert(start, "\t" + readprop_method_name + "();\n");
    }
}

