/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import pogo.appli.PogoAppli;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;

public class StateMachineDialog
extends JDialog {
    private int retVal = 0;
    private PogoClass server;
    private Vector cmdBtn = new Vector();
    private Vector attBtn = new Vector();
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;

    public StateMachineDialog(JFrame parent, PogoClass server) {
        super((Frame)parent, true);
        this.server = server;
        this.initComponents();
        this.createOwnComponents();
        this.pack();
        PogoAppli.centerDialog(this, parent);
    }

    private void createOwnComponents() {
        int naf;
        JRadioButton btn;
        DevState state;
        int st;
        Vector<JRadioButton> r_btn;
        DevState state2;
        int i;
        int y = 1;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.mainPanel.add((Component)new JLabel("   "), gbc);
        JLabel lbl = new JLabel("Commands :");
        gbc.gridx = 1;
        gbc.gridy = y++;
        lbl.setFont(new Font("Dialog", 0, 18));
        this.mainPanel.add((Component)lbl, gbc);
        int x = 2;
        for (i = 0; i < this.server.states.size(); ++i) {
            gbc.gridx = x++;
            gbc.gridy = y;
            this.mainPanel.add((Component)new JLabel("   "), gbc);
            state2 = this.server.states.stateAt(i);
            gbc.gridx = x++;
            gbc.gridy = y;
            this.mainPanel.add((Component)new JLabel(state2.name), gbc);
        }
        gbc.gridx = x++;
        gbc.gridy = y++;
        this.mainPanel.add((Component)new JLabel("   "), gbc);
        i = 2;
        while (i < this.server.commands.size()) {
            x = 1;
            Cmd cmd = this.server.commands.cmdAt(i);
            gbc.gridx = x++;
            gbc.gridy = y;
            this.mainPanel.add((Component)new JLabel(cmd.name), gbc);
            r_btn = new Vector<JRadioButton>();
            for (st = 0; st < this.server.states.size(); ++st) {
                state = this.server.states.stateAt(st);
                gbc.gridx = x++;
                gbc.gridy = y;
                this.mainPanel.add((Component)new JLabel("   "), gbc);
                gbc.gridx = x++;
                gbc.gridy = y;
                btn = new JRadioButton("Allowed");
                btn.setSelected(true);
                btn.setFont(new Font("Dialog", 0, 10));
                r_btn.add(btn);
                this.mainPanel.add((Component)btn, gbc);
                for (naf = 0; naf < cmd.notAllowedFor.size(); ++naf) {
                    if (!state.name.equals(cmd.notAllowedFor.stateAt((int)naf).name)) continue;
                    btn.setSelected(false);
                }
            }
            this.cmdBtn.add(r_btn);
            ++i;
            ++y;
        }
        for (i = 0; i < 4; ++i) {
            gbc.gridx = x = 1;
            gbc.gridy = y++;
            this.mainPanel.add((Component)new JLabel(" "), gbc);
        }
        gbc.gridx = 1;
        gbc.gridy = y++;
        lbl = new JLabel("Attributes :");
        lbl.setFont(new Font("Dialog", 0, 18));
        this.mainPanel.add((Component)lbl, gbc);
        x = 2;
        for (i = 0; i < this.server.states.size(); ++i) {
            gbc.gridx = x++;
            gbc.gridy = y;
            this.mainPanel.add((Component)new JLabel("   "), gbc);
            state2 = this.server.states.stateAt(i);
            gbc.gridx = x++;
            gbc.gridy = y;
            this.mainPanel.add((Component)new JLabel(state2.name), gbc);
        }
        ++y;
        i = 0;
        while (i < this.server.attributes.size()) {
            x = 1;
            Attrib att = this.server.attributes.attributeAt(i);
            gbc.gridx = x++;
            gbc.gridy = y;
            this.mainPanel.add((Component)new JLabel(att.name), gbc);
            r_btn = new Vector();
            for (st = 0; st < this.server.states.size(); ++st) {
                state = this.server.states.stateAt(st);
                gbc.gridx = x++;
                gbc.gridy = y;
                this.mainPanel.add((Component)new JLabel("   "), gbc);
                gbc.gridx = x++;
                gbc.gridy = y;
                btn = new JRadioButton("Allowed");
                btn.setFont(new Font("Dialog", 0, 10));
                btn.setSelected(true);
                r_btn.add(btn);
                this.mainPanel.add((Component)btn, gbc);
                for (naf = 0; naf < att.notAllowedFor.size(); ++naf) {
                    if (!state.name.equals(att.notAllowedFor.stateAt((int)naf).name)) continue;
                    btn.setSelected(false);
                }
            }
            this.attBtn.add(r_btn);
            ++i;
            ++y;
        }
        for (i = 0; i < 2; ++i) {
            gbc.gridx = x = 1;
            gbc.gridy = y++;
            this.mainPanel.add((Component)new JLabel(" "), gbc);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StateMachineDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StateMachineDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StateMachineDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("State Machine");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.mainPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.mainPanel);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        DevState state;
        JRadioButton b;
        int j;
        Vector v;
        int i;
        this.retVal = 0;
        for (i = 0; i < this.cmdBtn.size(); ++i) {
            Cmd cmd = this.server.commands.cmdAt(i + 2);
            cmd.notAllowedFor.clear();
            v = (Vector)this.cmdBtn.elementAt(i);
            for (j = 0; j < v.size(); ++j) {
                b = (JRadioButton)v.elementAt(j);
                if (b.getSelectedObjects() != null) continue;
                state = this.server.states.stateAt(j);
                cmd.notAllowedFor.add(state);
            }
        }
        for (i = 0; i < this.attBtn.size(); ++i) {
            Attrib att = this.server.attributes.attributeAt(i);
            att.notAllowedFor.clear();
            v = (Vector)this.attBtn.elementAt(i);
            for (j = 0; j < v.size(); ++j) {
                b = (JRadioButton)v.elementAt(j);
                if (b.getSelectedObjects() != null) continue;
                state = this.server.states.stateAt(j);
                att.notAllowedFor.add(state);
            }
        }
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }
}

