/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class CfFileReader {
    Vector prop = new Vector();
    FileReader file = null;
    String cfStr = null;
    char currentChar;

    private char getCurrentChar() throws IOException {
        if (this.file != null) {
            return (char)this.file.read();
        }
        if (this.cfStr != null) {
            char c = this.cfStr.charAt(0);
            this.cfStr = this.cfStr.substring(1);
            return c;
        }
        return '\u0000';
    }

    private boolean eof() throws IOException {
        if (this.file != null) {
            return !this.file.ready();
        }
        if (this.cfStr != null) {
            return this.cfStr.length() == 0;
        }
        return true;
    }

    private String readWord() throws IOException {
        boolean bl = this.currentChar > ' ';
        String string = "";
        while (!this.eof() && !bl) {
            this.currentChar = this.getCurrentChar();
            bl = this.currentChar > ' ';
        }
        if (!bl) {
            return null;
        }
        if (this.currentChar == '\'') {
            bl = false;
            while (!this.eof() && !bl) {
                this.currentChar = this.getCurrentChar();
                bl = this.currentChar == '\'';
                if (bl) continue;
                string = string + this.currentChar;
            }
            if (!bl) {
                System.out.println("CfFileReader.parse: ''' is missing");
                return null;
            }
            this.currentChar = this.getCurrentChar();
            return string;
        }
        string = string + this.currentChar;
        if (this.currentChar == ',' || this.currentChar == ':') {
            this.currentChar = this.getCurrentChar();
            return string;
        }
        bl = false;
        while (!this.eof() && !bl) {
            this.currentChar = this.getCurrentChar();
            bl = this.currentChar == ',' || this.currentChar == ':' || this.currentChar <= ' ';
            if (bl) continue;
            string = string + this.currentChar;
        }
        return string;
    }

    private boolean parse() throws IOException {
        this.prop.clear();
        this.currentChar = '\u0000';
        String string = this.readWord();
        while (string != null) {
            Item item = new Item(string);
            string = this.readWord();
            if (!string.equals(":")) {
                System.out.println("CfFileReader.parse: ':' expected instead of " + string);
                return false;
            }
            boolean bl = true;
            while (bl) {
                bl = false;
                string = this.readWord();
                if (string != null) {
                    item.addProp(string);
                }
                if ((string = this.readWord()) == null) continue;
                bl = string.equals(",");
            }
            this.prop.add(item);
        }
        return true;
    }

    public boolean parseText(String string) {
        boolean bl = false;
        try {
            this.cfStr = string;
            bl = this.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean readFile(String string) {
        boolean bl = false;
        try {
            this.file = new FileReader(string);
            bl = this.parse();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public Vector getNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.prop.size(); ++i) {
            vector.add(this.prop.get(i).toString());
        }
        return vector;
    }

    public Vector getParam(String string) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.prop.size()) {
            bl = string.equals(this.prop.get(n).toString());
            if (bl) continue;
            ++n;
        }
        if (bl) {
            Item item = (Item)this.prop.get(n);
            return item.items;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        CfFileReader cfFileReader = new CfFileReader();
        if (cfFileReader.readFile("test.cfg")) {
            Vector vector = cfFileReader.getNames();
            System.out.println("Read " + vector.size() + " params");
            for (int i = 0; i < vector.size(); ++i) {
                System.out.println(vector.get(i).toString());
                Vector vector2 = cfFileReader.getParam(vector.get(i).toString());
                for (int j = 0; j < vector2.size(); ++j) {
                    System.out.println("   " + vector2.get(j).toString());
                }
            }
        } else {
            System.out.println("Error while reading config file");
        }
    }

    class Item {
        public Vector items = new Vector();
        String name;

        public Item(String string) {
            this.name = string;
        }

        public void addProp(String string) {
            this.items.add(string);
        }

        public String toString() {
            return this.name;
        }
    }
}

