/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class NumberImageTable
extends JTable
implements IImageListener {
    protected INumberImage imageModel = null;
    protected NumberImageTableModel tableModel = new NumberImageTableModel();

    public NumberImageTable() {
        this.setModel(this.tableModel);
    }

    public void setImageModel(INumberImage iNumberImage) {
        if (this.imageModel != null) {
            this.imageModel.removeImageListener((IImageListener)this);
            this.imageModel = null;
        }
        if (iNumberImage != null) {
            this.imageModel = iNumberImage;
            this.imageModel.addImageListener((IImageListener)this);
            this.imageModel.refresh();
        }
    }

    public INumberImage getImageModel() {
        return this.imageModel;
    }

    public void imageChange(NumberImageEvent numberImageEvent) {
        double[][] dArray;
        double[][] dArray2 = numberImageEvent.getValue();
        boolean bl = false;
        if (dArray2 == null) {
            dArray2 = new double[0][0];
        }
        if ((dArray = this.tableModel.getValue()) == null) {
            dArray = new double[0][0];
        }
        if (dArray2.length != dArray.length) {
            bl = true;
        } else if (dArray2.length > 0 && dArray2[0].length != dArray[0].length) {
            bl = true;
        } else {
            for (int i = 0; i < dArray2.length; ++i) {
                for (int j = 0; j < dArray2[0].length; ++j) {
                    if (dArray2[i][j] == dArray[i][j]) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        if (bl) {
            this.tableModel.setValue(dArray2);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        double[][] dArray = this.tableModel.getValue();
        if (dArray != null || dArray.length != 0 || dArray[0].length != 0) {
            this.tableModel.setValue(new double[0][0]);
        }
    }

    public static void main(String[] stringArray) throws ConnectionException {
        JFrame jFrame = new JFrame("test math");
        jFrame.setDefaultCloseOperation(3);
        String string = "tango/tangotest/1/double_spectrum";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        NumberImageTable numberImageTable = new NumberImageTable();
        AttributePolledList attributePolledList = new AttributePolledList();
        INumberImage iNumberImage = (INumberImage)attributePolledList.add(string);
        numberImageTable.setImageModel(iNumberImage);
        jFrame.getContentPane().add(new JScrollPane(numberImageTable));
        jFrame.setSize(400, 400);
        jFrame.setVisible(true);
        attributePolledList.startRefresher();
    }

    protected class NumberImageTableModel
    extends AbstractTableModel {
        double[][] value;

        public int getRowCount() {
            if (this.value == null) {
                return 0;
            }
            return this.value.length;
        }

        public int getColumnCount() {
            if (this.value == null) {
                return 0;
            }
            if (this.value.length == 0) {
                return 0;
            }
            return this.value[0].length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(double[][] dArray) {
            boolean bl = false;
            NumberImageTableModel numberImageTableModel = this;
            synchronized (numberImageTableModel) {
                double[][] dArray2 = dArray;
                if (dArray2 == null) {
                    dArray2 = new double[0][0];
                }
                if (this.value == null) {
                    bl = true;
                } else if (this.value.length != dArray2.length) {
                    bl = true;
                } else if (this.value.length > 0 && this.value[0].length != dArray2[0].length) {
                    bl = true;
                }
                this.value = dArray2;
            }
            if (bl) {
                this.fireTableStructureChanged();
            } else {
                this.fireTableRowsUpdated(0, this.value.length);
            }
        }

        public double[][] getValue() {
            return this.value;
        }

        public Object getValueAt(int n, int n2) {
            double d = -1.0;
            d = this.value[n][n2];
            return new Double(d);
        }

        public String getColumnName(int n) {
            return Integer.toString(n);
        }
    }
}

