/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Hashtable;
import org.lsmp.djep.xjep.ErrorCatchingVisitor;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.List;
import org.nfunk.jep.type.Complex;

public class PrintVisitor
extends ErrorCatchingVisitor {
    public static final int FULL_BRACKET = 1;
    public static final int COMPLEX_I = 2;
    private int maxLen = -1;
    protected StringBuffer sb;
    protected int mode = 0;
    private Hashtable specialRules = new Hashtable();
    private FieldPosition fp = new FieldPosition(1);
    protected NumberFormat format;

    public void print(Node node, PrintStream printStream) {
        this.sb = new StringBuffer();
        this.acceptCatchingErrors(node, null);
        if (this.maxLen != -1) {
            while (true) {
                if (this.sb.length() < this.maxLen) {
                    printStream.print(this.sb);
                    return;
                }
                int n = this.maxLen - 2;
                for (int i = this.maxLen - 2; i >= 0; --i) {
                    char c2 = this.sb.charAt(i);
                    if (c2 != '+' && c2 != '-' && c2 != '*' && c2 != '/') continue;
                    n = i;
                    break;
                }
                printStream.println(this.sb.substring(0, n + 1));
                this.sb.delete(0, n + 1);
            }
        }
        printStream.print(this.sb);
    }

    public void print(Node node) {
        this.print(node, System.out);
    }

    public void println(Node node, PrintStream printStream) {
        this.print(node, printStream);
        printStream.println("");
    }

    public void println(Node node) {
        this.println(node, System.out);
    }

    public String toString(Node node) {
        this.sb = new StringBuffer();
        this.acceptCatchingErrors(node, null);
        return this.sb.toString();
    }

    public void append(String string) {
        this.sb.append(string);
    }

    public void addSpecialRule(Operator operator, PrintRulesI printRulesI) {
        this.specialRules.put(operator, printRulesI);
    }

    private void printNoBrackets(Node node) throws ParseException {
        node.jjtAccept(this, null);
    }

    private void printBrackets(Node node) throws ParseException {
        this.sb.append("(");
        this.printNoBrackets(node);
        this.sb.append(")");
    }

    private Object visitUnary(ASTFunNode aSTFunNode, Object object) throws ParseException {
        Node node = aSTFunNode.jjtGetChild(0);
        this.sb.append(aSTFunNode.getOperator().getSymbol());
        if (node instanceof ASTFunNode && ((ASTFunNode)node).isOperator()) {
            this.printBrackets(node);
        } else {
            this.printNoBrackets(node);
        }
        return object;
    }

    private boolean testLeft(XOperator xOperator, Node node) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (node instanceof ASTFunNode && ((ASTFunNode)node).isOperator()) {
            XOperator xOperator2 = (XOperator)((ASTFunNode)node).getOperator();
            if (xOperator == xOperator2) {
                if (xOperator.getBinding() == 4 && xOperator.isAssociative()) {
                    return false;
                }
                return !xOperator.useBindingForPrint();
            }
            if (xOperator.getPrecedence() == xOperator2.getPrecedence()) {
                if (xOperator2.getBinding() == 4 && xOperator2.isAssociative()) {
                    return false;
                }
                return !xOperator2.useBindingForPrint();
            }
            return xOperator.getPrecedence() <= xOperator2.getPrecedence();
        }
        return false;
    }

    private boolean testMid(XOperator xOperator, Node node) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (node instanceof ASTFunNode && ((ASTFunNode)node).isOperator()) {
            XOperator xOperator2 = (XOperator)((ASTFunNode)node).getOperator();
            if (xOperator == xOperator2) {
                return false;
            }
            if (xOperator.getPrecedence() == xOperator2.getPrecedence()) {
                return false;
            }
            return xOperator.getPrecedence() <= xOperator2.getPrecedence();
        }
        return false;
    }

    private boolean testRight(XOperator xOperator, Node node) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (node instanceof ASTFunNode && ((ASTFunNode)node).isOperator()) {
            XOperator xOperator2 = (XOperator)((ASTFunNode)node).getOperator();
            if (xOperator == xOperator2) {
                return xOperator.getBinding() != 8 && !xOperator.isAssociative();
            }
            if (xOperator.getPrecedence() == xOperator2.getPrecedence()) {
                return xOperator.getBinding() != 4 || !xOperator.isAssociative();
            }
            return xOperator.getPrecedence() <= xOperator2.getPrecedence();
        }
        return false;
    }

    private Object visitNaryBinary(ASTFunNode aSTFunNode, XOperator xOperator) throws ParseException {
        int n = aSTFunNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node;
            if (i > 0) {
                this.sb.append(xOperator.getSymbol());
            }
            if (this.testMid(xOperator, node = aSTFunNode.jjtGetChild(i))) {
                this.printBrackets(node);
                continue;
            }
            this.printNoBrackets(node);
        }
        return null;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        if (!aSTFunNode.isOperator()) {
            return this.visitFun(aSTFunNode);
        }
        if (aSTFunNode instanceof PrintRulesI) {
            ((PrintRulesI)((Object)aSTFunNode)).append(aSTFunNode, this);
            return null;
        }
        if (aSTFunNode.getOperator() == null) {
            throw new ParseException("Null operator in print for " + aSTFunNode);
        }
        if (this.specialRules.containsKey(aSTFunNode.getOperator())) {
            ((PrintRulesI)this.specialRules.get(aSTFunNode.getOperator())).append(aSTFunNode, this);
            return null;
        }
        if (aSTFunNode.getPFMC() instanceof List) {
            this.append("[");
            for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    this.append(",");
                }
                aSTFunNode.jjtGetChild(i).jjtAccept(this, null);
            }
            this.append("]");
            return null;
        }
        if (((XOperator)aSTFunNode.getOperator()).isUnary()) {
            return this.visitUnary(aSTFunNode, object);
        }
        if (((XOperator)aSTFunNode.getOperator()).isBinary()) {
            XOperator xOperator = (XOperator)aSTFunNode.getOperator();
            if (aSTFunNode.jjtGetNumChildren() != 2) {
                return this.visitNaryBinary(aSTFunNode, xOperator);
            }
            Node node = aSTFunNode.jjtGetChild(0);
            Node node2 = aSTFunNode.jjtGetChild(1);
            if (this.testLeft(xOperator, node)) {
                this.printBrackets(node);
            } else {
                this.printNoBrackets(node);
            }
            this.sb.append(aSTFunNode.getOperator().getSymbol());
            if (this.testRight(xOperator, node2)) {
                this.printBrackets(node2);
            } else {
                this.printNoBrackets(node2);
            }
        }
        return null;
    }

    private Object visitFun(ASTFunNode aSTFunNode) throws ParseException {
        this.sb.append(aSTFunNode.getName() + "(");
        for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
            if (i > 0) {
                this.sb.append(",");
            }
            aSTFunNode.jjtGetChild(i).jjtAccept(this, null);
        }
        this.sb.append(")");
        return null;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        this.sb.append(aSTVarNode.getName());
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) {
        Object object2 = aSTConstant.getValue();
        this.formatValue(object2, this.sb);
        return object;
    }

    public void formatValue(Object object, StringBuffer stringBuffer) {
        if (this.format != null) {
            if (object instanceof Number) {
                this.format.format(object, stringBuffer, this.fp);
            } else if (object instanceof Complex) {
                if ((this.mode | 2) == 2) {
                    stringBuffer.append(((Complex)object).toString(this.format, true));
                } else {
                    stringBuffer.append(((Complex)object).toString(this.format));
                }
            } else {
                stringBuffer.append(object);
            }
        } else {
            stringBuffer.append(object);
        }
    }

    public String formatValue(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        this.formatValue(object, stringBuffer);
        return stringBuffer.toString();
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getMode(int n) {
        return (this.mode | n) == n;
    }

    public void setMode(int n, boolean bl) {
        this.mode = bl ? (this.mode |= n) : (this.mode ^= n);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public void setMaxLen(int n) {
        this.maxLen = n;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public static interface PrintRulesI {
        public void append(Node var1, PrintVisitor var2) throws ParseException;
    }
}

