/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.text.TextWindow;

public class NewPlugin
implements PlugIn {
    public static final int MACRO = 0;
    public static final int PLUGIN = 1;
    public static final int PLUGIN_FILTER = 2;
    public static final int PLUGIN_FRAME = 3;
    public static final int TEXT_FILE = 4;
    public static final int TABLE = 5;
    private static int type = 0;
    private static String name = "Macro";
    private static String[] types = new String[]{"Macro", "Plugin", "Plugin Filter", "Plugin Frame", "Text File", "Table"};
    private static int rows = 16;
    private static int columns = 60;
    private static boolean monospaced;
    private boolean menuBar = true;
    private Editor ed;
    private int saveType = type;
    private String saveName = name;
    private int saveRows = rows;
    private int saveColumns = columns;
    private boolean saveMonospaced = monospaced;

    public void run(String arg) {
        if (arg.equals("") && !this.showDialog()) {
            return;
        }
        if (arg.equals("text")) {
            type = 4;
            arg = "";
        }
        if (arg.equals("")) {
            if (type == 0 || type == 4) {
                if (type == 4 && name.equals("Macro")) {
                    name = "Untitled.txt";
                }
                this.createMacro(name);
            } else if (type == 5) {
                this.createTextWindow();
            } else {
                this.createPlugin(name, type, arg);
            }
        } else {
            this.createPlugin("Converted_Macro.java", 1, arg);
        }
        if (IJ.macroRunning()) {
            type = this.saveType;
            name = this.saveName;
            rows = this.saveRows;
            columns = this.saveColumns;
            monospaced = this.saveMonospaced;
        }
        IJ.register(NewPlugin.class);
    }

    public void createMacro(String name) {
        int options = (monospaced ? 1 : 0) + (this.menuBar ? 2 : 0);
        this.ed = new Editor(rows, columns, 0, options);
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - 5);
        }
        if (type == 0 && !name.endsWith(".txt")) {
            name = name + ".txt";
        }
        this.ed.create(name, "");
    }

    void createTextWindow() {
        String tableName = name;
        if (tableName.equals("Macro")) {
            tableName = "Table";
        }
        if (columns < 128 || rows < 75) {
            new TextWindow(tableName, "", 350, 250);
        } else {
            new TextWindow(tableName, "", columns, rows);
        }
    }

    public void createPlugin(String name, int type, String methods) {
        this.ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (this.ed == null) {
            return;
        }
        if (name.equals("Macro") || name.equals("Macro.txt") || name.equals("Untitled.txt")) {
            switch (type) {
                case 1: {
                    name = "My_Plugin.java";
                    break;
                }
                case 2: {
                    name = "Filter_Plugin.java";
                    break;
                }
                case 3: {
                    name = "Plugin_Frame.java";
                }
            }
        }
        String pluginName = name;
        if (!name.endsWith(".java") && !name.endsWith(".JAVA")) {
            if (pluginName.endsWith(".txt")) {
                pluginName = pluginName.substring(0, pluginName.length() - 4);
            }
            pluginName = pluginName + ".java";
        }
        String className = pluginName.substring(0, pluginName.length() - 5);
        String text = "";
        text = text + "import ij.*;\n";
        text = text + "import ij.process.*;\n";
        text = text + "import ij.gui.*;\n";
        text = text + "import java.awt.*;\n";
        switch (type) {
            case 1: {
                text = text + "import ij.plugin.*;\n";
                text = text + "\n";
                text = text + "public class " + className + " implements PlugIn {\n";
                text = text + "\n";
                text = text + "\tpublic void run(String arg) {\n";
                text = methods.equals("") ? text + "\t\tIJ.showMessage(\"" + className + "\",\"Hello world!\");\n" : text + methods;
                text = text + "\t}\n";
                break;
            }
            case 2: {
                text = text + "import ij.plugin.filter.*;\n";
                text = text + "\n";
                text = text + "public class " + className + " implements PlugInFilter {\n";
                text = text + "\tImagePlus imp;\n";
                text = text + "\n";
                text = text + "\tpublic int setup(String arg, ImagePlus imp) {\n";
                text = text + "\t\tthis.imp = imp;\n";
                text = text + "\t\treturn DOES_ALL;\n";
                text = text + "\t}\n";
                text = text + "\n";
                text = text + "\tpublic void run(ImageProcessor ip) {\n";
                text = text + "\t\tip.invert();\n";
                text = text + "\t\timp.updateAndDraw();\n";
                text = text + "\t\tIJ.wait(500);\n";
                text = text + "\t\tip.invert();\n";
                text = text + "\t\timp.updateAndDraw();\n";
                text = text + "\t}\n";
                break;
            }
            case 3: {
                text = text + "import ij.plugin.frame.*;\n";
                text = text + "\n";
                text = text + "public class " + className + " extends PlugInFrame {\n";
                text = text + "\n";
                text = text + "\tpublic " + className + "() {\n";
                text = text + "\t\tsuper(\"" + className + "\");\n";
                text = text + "\t\tTextArea ta = new TextArea(15, 50);\n";
                text = text + "\t\tadd(ta);\n";
                text = text + "\t\tpack();\n";
                text = text + "\t\tGUI.center(this);\n";
                text = text + "\t\tshow();\n";
                text = text + "\t}\n";
            }
        }
        text = text + "\n";
        text = text + "}\n";
        this.ed.create(pluginName, text);
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("New Text Window");
        gd.addStringField("Name:", name, 16);
        gd.addChoice("Type:", types, types[type]);
        gd.addMessage("");
        gd.addNumericField("Width:", columns, 0, 3, "characters");
        gd.addNumericField("Height:", rows, 0, 3, "lines");
        gd.setInsets(5, 30, 0);
        gd.addCheckbox("Menu Bar", this.menuBar);
        gd.setInsets(0, 30, 0);
        gd.addCheckbox("Monospaced Font", monospaced);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        type = gd.getNextChoiceIndex();
        columns = (int)gd.getNextNumber();
        rows = (int)gd.getNextNumber();
        this.menuBar = gd.getNextBoolean();
        monospaced = gd.getNextBoolean();
        if (rows < 1) {
            rows = 1;
        }
        if (type != 5 && rows > 100) {
            rows = 100;
        }
        if (columns < 1) {
            columns = 1;
        }
        if (type != 5 && columns > 200) {
            columns = 200;
        }
        return true;
    }

    public Editor getEditor() {
        return this.ed;
    }
}

