/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.BlackBoxElt;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class BlackBox
implements TangoConst {
    private BlackBoxElt[] box;
    private int insert_elt;
    private int nb_elt;
    private int max_elt;
    private StringBuffer elt_str;

    public BlackBox() {
        this.box = new BlackBoxElt[25];
        for (int i = 0; i < 25; ++i) {
            this.box[i] = new BlackBoxElt();
        }
        this.insert_elt = 0;
        this.nb_elt = 0;
        this.max_elt = 25;
        Util tg = Util.instance();
        Object base = null;
    }

    public BlackBox(int max_size) {
        this.box = new BlackBoxElt[max_size];
        for (int i = 0; i < max_size; ++i) {
            this.box[i] = new BlackBoxElt();
        }
        this.insert_elt = 0;
        this.nb_elt = 0;
        this.max_elt = max_size;
        Util tg = Util.instance();
        Object base = null;
    }

    public synchronized void insert_attr(int attr) {
        this.box[this.insert_elt].req_type = 2;
        this.box[this.insert_elt].attr_type = attr;
        this.box[this.insert_elt].op_type = 0;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public synchronized void insert_attr(int attr, String host) {
        this.box[this.insert_elt].req_type = 2;
        this.box[this.insert_elt].attr_type = attr;
        this.box[this.insert_elt].op_type = 0;
        this.box[this.insert_elt].host = host;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    public synchronized void insert_cmd(String cmd, int version) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = version == 2 ? 11 : 1;
        this.box[this.insert_elt].cmd_name = cmd;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public synchronized void insert_cmd(String cmd, String host) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = 1;
        this.box[this.insert_elt].cmd_name = cmd;
        this.box[this.insert_elt].host = host;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    public synchronized void insert_op(int op) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = op;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public synchronized void insert_op(int op, String host) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = op;
        this.box[this.insert_elt].host = host;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    private void inc_indexes() {
        ++this.insert_elt;
        if (this.insert_elt == this.max_elt) {
            this.insert_elt = 0;
        }
        if (this.nb_elt != this.max_elt) {
            ++this.nb_elt;
        }
    }

    private void get_client_host() {
    }

    private void build_info_as_str(int index) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SS");
        sdf.setTimeZone(TimeZone.getTimeZone("ECT"));
        String da = sdf.format(this.box[index].when);
        this.elt_str = new StringBuffer(da);
        this.elt_str.append(" : ");
        if (this.box[index].req_type == 1) {
            this.elt_str.append("Operation ");
            switch (this.box[index].op_type) {
                case 1: {
                    this.elt_str.append("command_inout (cmd = ");
                    this.elt_str.append(this.box[index].cmd_name);
                    this.elt_str.append(") ");
                    break;
                }
                case 3: {
                    this.elt_str.append("ping ");
                    break;
                }
                case 4: {
                    this.elt_str.append("info ");
                    break;
                }
                case 2: {
                    this.elt_str.append("blackbox ");
                    break;
                }
                case 5: {
                    this.elt_str.append("command_list_query ");
                    break;
                }
                case 6: {
                    this.elt_str.append("command_query ");
                    break;
                }
                case 7: {
                    this.elt_str.append("get_attribute_config ");
                    break;
                }
                case 8: {
                    this.elt_str.append("set_attribute_config ");
                    break;
                }
                case 9: {
                    this.elt_str.append("read_attributes ");
                    break;
                }
                case 10: {
                    this.elt_str.append("write_attributes ");
                    break;
                }
                case 11: {
                    this.elt_str.append("command_inout_2 (cmd = " + this.box[index].cmd_name + ") ");
                    break;
                }
                case 12: {
                    this.elt_str.append("command_list_query_2 ");
                    break;
                }
                case 13: {
                    this.elt_str.append("command_query_2 ");
                    break;
                }
                case 14: {
                    this.elt_str.append("get_attribute_config_2 ");
                    break;
                }
                case 15: {
                    this.elt_str.append("read_attributes_2 ");
                    break;
                }
                case 16: {
                    this.elt_str.append("command_inout_history_2 ");
                    break;
                }
                case 17: {
                    this.elt_str.append("read_attribute_history_2");
                    break;
                }
                case 0: {
                    this.elt_str.append("unknown operation !!!!!");
                    return;
                }
            }
        } else if (this.box[index].req_type == 2) {
            this.elt_str.append("Attribute ");
            switch (this.box[index].attr_type) {
                case 1: {
                    this.elt_str.append("name ");
                    break;
                }
                case 2: {
                    this.elt_str.append("description ");
                    break;
                }
                case 4: {
                    this.elt_str.append("status ");
                    break;
                }
                case 3: {
                    this.elt_str.append("state ");
                    break;
                }
                case 5: {
                    this.elt_str.append("adm_name ");
                    break;
                }
                case 0: {
                    this.elt_str.append("unknown attribute !!!!!");
                    return;
                }
            }
        } else {
            this.elt_str.append("Unknown CORBA request type !!!!!");
            return;
        }
        if (!this.box[index].host.equals("Unknown")) {
            int[] conv_addr = new int[4];
            for (int i = 0; i < 4; ++i) {
                conv_addr[i] = this.box[index].host_ip[i] < 0 ? 255 + this.box[index].host_ip[i] + 1 : this.box[index].host_ip[i];
            }
            StringBuffer host_str = new StringBuffer();
            host_str.append(conv_addr[0]);
            host_str.append(".");
            host_str.append(conv_addr[1]);
            host_str.append(".");
            host_str.append(conv_addr[2]);
            host_str.append(".");
            host_str.append(conv_addr[3]);
            this.elt_str.append("requested from ");
            InetAddress ad = null;
            try {
                ad = InetAddress.getByName(host_str.toString());
                this.elt_str.append(ad.getHostName());
            }
            catch (UnknownHostException ex) {
                this.elt_str.append(host_str.toString());
            }
        }
    }

    public String[] read(int wanted_elt) throws DevFailed {
        if (wanted_elt <= 0) {
            Except.throw_exception("API_BlackBoxArgument", "Argument to read black box out of range", "BlackBox::read");
        }
        if (this.nb_elt == 0) {
            Except.throw_exception("API_BlackBoxEmpty", "Nothing stored yet in black-box", "BlackBox::read");
        }
        if (wanted_elt > this.max_elt) {
            wanted_elt = this.max_elt;
        }
        if (wanted_elt > this.nb_elt) {
            wanted_elt = this.nb_elt;
        }
        String[] ret = new String[wanted_elt];
        int read_index = this.insert_elt == 0 ? this.max_elt - 1 : this.insert_elt - 1;
        for (int i = 0; i < wanted_elt; ++i) {
            this.build_info_as_str(read_index);
            ret[i] = new String(this.elt_str);
            if (--read_index >= 0) continue;
            read_index = this.max_elt - 1;
        }
        return ret;
    }
}

